/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Provider;
import org.gradle.api.Project;
import org.jspecify.annotations.Nullable;

public class RewriteExtension {
    private static final String magicalMetricsLogString = "LOG";
    private final List<String> activeRecipes = new ArrayList<String>();
    private final List<String> activeStyles = new ArrayList<String>();
    private boolean configFileSetDeliberately;
    protected final Project project;
    private File configFile;
    @javax.annotation.Nullable
    private Provider<File> checkstyleConfigProvider;
    @javax.annotation.Nullable
    private Provider<Map<String, Object>> checkstylePropertiesProvider;
    @javax.annotation.Nullable
    private File checkstyleConfigFile;
    private String metricsUri = "LOG";
    private boolean enableExperimentalGradleBuildScriptParsing = true;
    private boolean exportDatatables;
    private final List<String> exclusions = new ArrayList<String>();
    private final List<String> plainTextMasks = new ArrayList<String>();
    private int sizeThresholdMb = 10;
    @javax.annotation.Nullable
    private String rewriteVersion;
    @javax.annotation.Nullable
    private Properties versionProps;
    private boolean logCompilationWarningsAndErrors;
    private boolean failOnInvalidActiveRecipes;
    private boolean failOnDryRunResults;
    private boolean throwOnParseFailures;
    @javax.annotation.Nullable
    private String rewritePolyglotVersion;
    @javax.annotation.Nullable
    private String rewriteGradleModelVersion;
    @javax.annotation.Nullable
    private String rewriteKotlinVersion;

    public RewriteExtension(Project project) {
        this.project = project;
        this.configFile = project.file((Object)"rewrite.yml");
    }

    public void setConfigFile(File configFile) {
        this.configFileSetDeliberately = true;
        this.configFile = configFile;
    }

    public void setConfigFile(String configFilePath) {
        this.configFileSetDeliberately = true;
        this.configFile = this.project.file((Object)configFilePath);
    }

    public void setCheckstyleConfigFile(File configFile) {
        this.checkstyleConfigFile = configFile;
    }

    @javax.annotation.Nullable
    public @Nullable File getCheckstyleConfigFile() {
        if (this.checkstyleConfigFile == null && this.checkstyleConfigProvider != null) {
            try {
                return (File)this.checkstyleConfigProvider.get();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.checkstyleConfigFile;
    }

    public Map<String, Object> getCheckstyleProperties() {
        if (this.checkstyleConfigProvider == null) {
            return Collections.emptyMap();
        }
        return (Map)this.checkstylePropertiesProvider.get();
    }

    public boolean getConfigFileSetDeliberately() {
        return this.configFileSetDeliberately;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void enableRouteMetricsToLog() {
        this.metricsUri = magicalMetricsLogString;
    }

    public boolean isRouteMetricsToLog() {
        return this.metricsUri.equals(magicalMetricsLogString);
    }

    public String getMetricsUri() {
        return this.metricsUri;
    }

    public void setMetricsUri(String value) {
        this.metricsUri = value;
    }

    public void activeRecipe(String ... recipes) {
        this.activeRecipes.addAll(Arrays.asList(recipes));
    }

    public void clearActiveRecipes() {
        this.activeRecipes.clear();
    }

    public void setActiveRecipes(List<String> activeRecipes) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeRecipes);
    }

    public void activeStyle(String ... styles) {
        this.activeStyles.addAll(Arrays.asList(styles));
    }

    public void clearActiveStyles() {
        this.activeStyles.clear();
    }

    public void setActiveStyles(List<String> activeStyles) {
        this.activeRecipes.clear();
        this.activeRecipes.addAll(activeStyles);
    }

    public List<String> getActiveStyles() {
        return this.activeStyles;
    }

    public List<String> getActiveRecipes() {
        return this.activeRecipes;
    }

    public Properties getVersionProps() {
        if (this.versionProps == null) {
            try (InputStream is = RewriteExtension.class.getResourceAsStream("/rewrite/versions.properties");){
                this.versionProps = new Properties();
                this.versionProps.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.versionProps;
    }

    public String getRewriteVersion() {
        if (this.rewriteVersion == null) {
            return this.getVersionProps().getProperty("org.openrewrite:rewrite-core");
        }
        return this.rewriteVersion;
    }

    public String getRewritePolyglotVersion() {
        if (this.rewritePolyglotVersion == null) {
            return this.getVersionProps().getProperty("org.openrewrite:rewrite-polyglot");
        }
        return this.rewritePolyglotVersion;
    }

    public String getRewriteGradleModelVersion() {
        if (this.rewriteGradleModelVersion == null) {
            this.rewriteGradleModelVersion = this.getVersionProps().getProperty("org.openrewrite.gradle.tooling:model");
        }
        return this.rewriteGradleModelVersion;
    }

    public String getRewriteKotlinVersion() {
        if (this.rewriteKotlinVersion == null) {
            this.rewriteKotlinVersion = this.getVersionProps().getProperty("org.openrewrite:rewrite-kotlin");
        }
        return this.rewriteKotlinVersion;
    }

    public void setRewriteVersion(String value) {
        this.rewriteVersion = value;
    }

    public boolean getFailOnInvalidActiveRecipes() {
        return this.failOnInvalidActiveRecipes;
    }

    public void setFailOnInvalidActiveRecipes(boolean failOnInvalidActiveRecipes) {
        this.failOnInvalidActiveRecipes = failOnInvalidActiveRecipes;
    }

    public boolean getFailOnDryRunResults() {
        return this.failOnDryRunResults;
    }

    public void setFailOnDryRunResults(boolean failOnDryRunResults) {
        this.failOnDryRunResults = failOnDryRunResults;
    }

    public boolean getLogCompilationWarningsAndErrors() {
        return this.logCompilationWarningsAndErrors;
    }

    public void setLogCompilationWarningsAndErrors(boolean logCompilationWarningsAndErrors) {
        this.logCompilationWarningsAndErrors = logCompilationWarningsAndErrors;
    }

    public Provider<File> getCheckstyleConfigProvider() {
        return this.checkstyleConfigProvider;
    }

    public void setCheckstyleConfigProvider(Provider<File> checkstyleConfigProvider) {
        this.checkstyleConfigProvider = checkstyleConfigProvider;
    }

    public Provider<Map<String, Object>> getCheckstylePropertiesProvider() {
        return this.checkstylePropertiesProvider;
    }

    public void setCheckstylePropertiesProvider(Provider<Map<String, Object>> checkstylePropertiesProvider) {
        this.checkstylePropertiesProvider = checkstylePropertiesProvider;
    }

    public boolean isEnableExperimentalGradleBuildScriptParsing() {
        return this.enableExperimentalGradleBuildScriptParsing;
    }

    public void setEnableExperimentalGradleBuildScriptParsing(boolean enableExperimentalGradleBuildScriptParsing) {
        this.enableExperimentalGradleBuildScriptParsing = enableExperimentalGradleBuildScriptParsing;
    }

    public boolean isExportDatatables() {
        return this.exportDatatables;
    }

    public void setExportDatatables(boolean exportDatatables) {
        this.exportDatatables = exportDatatables;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public void exclusion(String ... exclusions) {
        this.exclusions.addAll(Arrays.asList(exclusions));
    }

    public void exclusion(Collection<String> exclusions) {
        this.exclusions.addAll(exclusions);
    }

    public List<String> getPlainTextMasks() {
        if (this.plainTextMasks.isEmpty()) {
            this.plainTextMasks.addAll(Arrays.asList("**/*.adoc", "**/*.aj", "**/*.bash", "**/*.bat", "**/CODEOWNERS", "**/*.css", "**/*.config", "**/Dockerfile*", "**/*.env", "**/.gitattributes", "**/.gitignore", "**/*.htm*", "**/gradlew", "**/.java-version", "**/*.jelly", "**/*.jsp", "**/*.ksh", "**/*.lock", "**/lombok.config", "**/*.md", "**/*.mf", "**/META-INF/services/**", "**/META-INF/spring/**", "**/META-INF/spring.factories", "**/mvnw", "**/*.qute.java", "**/.sdkmanrc", "**/*.sh", "**/*.sql", "**/*.svg", "**/*.tsx", "**/*.txt"));
        }
        return this.plainTextMasks;
    }

    public void plainTextMask(String ... masks) {
        this.plainTextMasks.addAll(Arrays.asList(masks));
    }

    public void plainTextMask(Collection<String> masks) {
        this.plainTextMasks.addAll(masks);
    }

    public int getSizeThresholdMb() {
        return this.sizeThresholdMb;
    }

    public void setSizeThresholdMb(int thresholdMb) {
        this.sizeThresholdMb = thresholdMb;
    }

    public String getJacksonModuleKotlinVersion() {
        return this.getVersionProps().getProperty("com.fasterxml.jackson.module:jackson-module-kotlin");
    }

    public boolean getThrowOnParseFailures() {
        if (this.project.getProperties().containsKey("rewrite.throwOnParseFailures")) {
            return true;
        }
        return this.throwOnParseFailures;
    }

    public void setThrowOnParseFailures(boolean throwOnParseFailures) {
        this.throwOnParseFailures = throwOnParseFailures;
    }
}

