/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrewrite.gradle.GradleProjectSpec;
import org.openrewrite.gradle.GradleSourceSetSpec;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010%\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u0000J\u0010\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u0005\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u0006J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00062\b\b\u0001\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u0006J'\u0010!\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00062\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0#\u00a2\u0006\u0002\b$J'\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00062\u0017\u0010\"\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001d0#\u00a2\u0006\u0002\b$J\u0016\u0010&\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0006R \u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\b\"\u0004\b\u0012\u0010\nR \u0010\u0013\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\b\"\u0004\b\u0015\u0010\nR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/openrewrite/gradle/GradleProjectSpec;", "", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "checkstyleXml", "", "getCheckstyleXml", "()Ljava/lang/String;", "setCheckstyleXml", "(Ljava/lang/String;)V", "groovyBuildScript", "getGroovyBuildScript", "setGroovyBuildScript", "propertiesFiles", "", "rewriteYaml", "getRewriteYaml", "setRewriteYaml", "settingsGradle", "getSettingsGradle", "setSettingsGradle", "sourceSets", "", "Lorg/openrewrite/gradle/GradleSourceSetSpec;", "subprojects", "textFiles", "build", "buildGradle", "", "text", "propertiesFile", "name", "sourceSet", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "subproject", "textFile", "plugin"})
public final class GradleProjectSpec {
    @NotNull
    private final File dir;
    @NotNull
    private final List<GradleProjectSpec> subprojects;
    @NotNull
    private final List<GradleSourceSetSpec> sourceSets;
    @Language(value="groovy")
    @Nullable
    private String groovyBuildScript;
    @Language(value="groovy")
    @Nullable
    private String settingsGradle;
    @Language(value="yaml")
    @Nullable
    private String rewriteYaml;
    @Language(value="xml")
    @Nullable
    private String checkstyleXml;
    @NotNull
    private final Map<String, String> propertiesFiles;
    @NotNull
    private final Map<String, String> textFiles;

    public GradleProjectSpec(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.subprojects = new ArrayList();
        this.sourceSets = new ArrayList();
        this.propertiesFiles = new LinkedHashMap();
        this.textFiles = new LinkedHashMap();
    }

    @Nullable
    public final String getGroovyBuildScript() {
        return this.groovyBuildScript;
    }

    public final void setGroovyBuildScript(@Nullable String string) {
        this.groovyBuildScript = string;
    }

    public final void buildGradle(@Language(value="groovy") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.groovyBuildScript = StringsKt.trimIndent((String)text);
    }

    @Nullable
    public final String getSettingsGradle() {
        return this.settingsGradle;
    }

    public final void setSettingsGradle(@Nullable String string) {
        this.settingsGradle = string;
    }

    public final void settingsGradle(@Language(value="groovy") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.settingsGradle = StringsKt.trimIndent((String)text);
    }

    @Nullable
    public final String getRewriteYaml() {
        return this.rewriteYaml;
    }

    public final void setRewriteYaml(@Nullable String string) {
        this.rewriteYaml = string;
    }

    public final void rewriteYaml(@Language(value="yaml") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.rewriteYaml = StringsKt.trimIndent((String)text);
    }

    @Nullable
    public final String getCheckstyleXml() {
        return this.checkstyleXml;
    }

    public final void setCheckstyleXml(@Nullable String string) {
        this.checkstyleXml = string;
    }

    public final void checkstyleXml(@Language(value="xml") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.checkstyleXml = StringsKt.trimIndent((String)text);
    }

    public final void propertiesFile(@NotNull String name, @Language(value="properties") @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.propertiesFiles.put(name, text);
    }

    public final void textFile(@NotNull String name, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.textFiles.put(name, text);
    }

    @NotNull
    public final GradleProjectSpec subproject(@NotNull String name, @NotNull Function1<? super GradleProjectSpec, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        GradleProjectSpec gradleProjectSpec = new GradleProjectSpec(new File(this.dir, name));
        init.invoke((Object)gradleProjectSpec);
        GradleProjectSpec subproject = gradleProjectSpec;
        this.subprojects.add(subproject);
        return subproject;
    }

    @NotNull
    public final GradleSourceSetSpec sourceSet(@NotNull String name, @NotNull Function1<? super GradleSourceSetSpec, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        GradleSourceSetSpec gradleSourceSetSpec = new GradleSourceSetSpec(name);
        init.invoke((Object)gradleSourceSetSpec);
        GradleSourceSetSpec sourceSet = gradleSourceSetSpec;
        this.sourceSets.add(sourceSet);
        return sourceSet;
    }

    @NotNull
    public final GradleProjectSpec build() {
        boolean bl;
        this.dir.mkdirs();
        File settings = new File(this.dir, "settings.gradle");
        if (this.settingsGradle == null) {
            String settingsText = "rootProject.name = \"" + this.dir.getName() + "\"\n";
            if (this.subprojects.isEmpty()) {
                FilesKt.writeText$default((File)settings, (String)("rootProject.name = \"" + this.dir.getName() + "\"\n"), null, (int)2, null);
            } else {
                String string = CollectionsKt.joinToString$default((Iterable)this.subprojects, (CharSequence)"\n", null, null, (int)0, null, (Function1)build.subprojectsDeclarations.1.INSTANCE, (int)30, null);
                FilesKt.writeText$default((File)settings, (String)(settingsText + string), null, (int)2, null);
            }
        } else {
            String string = this.settingsGradle;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)settings, (String)string, null, (int)2, null);
        }
        if (this.groovyBuildScript != null) {
            File file = new File(this.dir, "build.gradle");
            String string = this.groovyBuildScript;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        if (this.rewriteYaml != null) {
            File file = new File(this.dir, "rewrite.yml");
            String string = this.rewriteYaml;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default((File)file, (String)string, null, (int)2, null);
        }
        if (this.checkstyleXml != null) {
            Iterator<Object> iterator = new File(this.dir, "config/checkstyle/checkstyle.xml");
            Iterator<Map.Entry<String, String>> iterator2 = iterator;
            boolean bl2 = false;
            ((File)((Object)iterator2)).getParentFile().mkdirs();
            String string = this.checkstyleXml;
            Intrinsics.checkNotNull((Object)string);
            FilesKt.writeText$default(iterator2, (String)string, null, (int)2, null);
        }
        for (Map.Entry entry : this.propertiesFiles.entrySet()) {
            File file;
            File $this$build_u24lambda_u241 = file = new File(this.dir, (String)entry.getKey());
            bl = false;
            $this$build_u24lambda_u241.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u241, (String)((String)entry.getValue()), null, (int)2, null);
        }
        for (Map.Entry<String, String> entry : this.textFiles.entrySet()) {
            File file;
            File $this$build_u24lambda_u242 = file = new File(this.dir, entry.getKey());
            bl = false;
            $this$build_u24lambda_u242.getParentFile().mkdirs();
            FilesKt.writeText$default((File)$this$build_u24lambda_u242, (String)entry.getValue(), null, (int)2, null);
        }
        for (GradleSourceSetSpec gradleSourceSetSpec : this.sourceSets) {
            gradleSourceSetSpec.build(new File(this.dir, "src"));
        }
        for (GradleProjectSpec gradleProjectSpec : this.subprojects) {
            gradleProjectSpec.build();
        }
        return this;
    }

    public static final /* synthetic */ File access$getDir$p(GradleProjectSpec $this) {
        return $this.dir;
    }
}

