/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.time.Duration;

public final class TimeUtils {
    public static final int MINUTES_PER_HOUR = 60;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;

    private TimeUtils() {
    }

    public static String prettyPrint(Duration duration) {
        StringBuilder result = new StringBuilder();
        long days = duration.getSeconds() / 86400L;
        boolean startedPrinting = false;
        if (days > 0L) {
            startedPrinting = true;
            result.append(days);
            result.append(" day");
            if (days != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long hours = duration.toHours() % 24L;
        if (startedPrinting || hours > 0L) {
            startedPrinting = true;
            result.append(hours);
            result.append(" hour");
            if (hours != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long minutes = duration.getSeconds() / 60L % 60L;
        if (startedPrinting || minutes > 0L) {
            result.append(minutes);
            result.append(" minute");
            if (minutes != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long seconds = duration.getSeconds() % 60L;
        if (startedPrinting || seconds > 0L) {
            result.append(seconds);
            result.append(" second");
            if (seconds != 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        long millis = duration.getNano() / 1000000;
        result.append(millis);
        result.append(" millisecond");
        if (millis != 1L) {
            result.append("s");
        }
        return result.toString();
    }
}

