/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.openrewrite.gradle.RewriteExtension;

public class ResolveRewriteDependenciesTask
extends DefaultTask {
    private Set<File> resolvedDependencies;
    private Configuration configuration;
    protected RewriteExtension extension;

    public ResolveRewriteDependenciesTask setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public ResolveRewriteDependenciesTask setExtension(RewriteExtension extension) {
        this.extension = extension;
        return this;
    }

    @Internal
    public Set<File> getResolvedDependencies() {
        if (this.resolvedDependencies == null) {
            String rewriteVersion = this.extension.getRewriteVersion();
            Project project = this.getProject();
            DependencyHandler deps = project.getDependencies();
            Dependency[] dependencies = new Dependency[]{deps.create((Object)("org.openrewrite:rewrite-core:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-groovy:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-gradle:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-hcl:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-json:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-kotlin:" + this.extension.getRewriteKotlinVersion())), deps.create((Object)("org.openrewrite:rewrite-python:" + this.extension.getRewritePythonVersion())), deps.create((Object)("org.openrewrite:rewrite-java:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-17:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-11:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-java-8:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-maven:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-properties:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-protobuf:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-xml:" + rewriteVersion)), deps.create((Object)("org.openrewrite:rewrite-yaml:" + rewriteVersion)), deps.create((Object)("org.openrewrite.recipe:rewrite-all:" + this.extension.getRewriteAllVersion())), deps.create((Object)("org.openrewrite.gradle.tooling:model:" + this.extension.getRewriteGradleModelVersion())), deps.create((Object)("com.puppycrawl.tools:checkstyle:" + this.extension.getCheckstyleToolsVersion())), deps.create((Object)("com.fasterxml.jackson.module:jackson-module-kotlin:" + this.extension.getJacksonModuleKotlinVersion())), deps.create((Object)("com.fasterxml.jackson.datatype:jackson-datatype-jsr310:" + this.extension.getJacksonModuleKotlinVersion()))};
            if (this.configuration != null) {
                dependencies = (Dependency[])Stream.concat(Arrays.stream(dependencies), this.configuration.getDependencies().stream()).toArray(Dependency[]::new);
            }
            Configuration detachedConf = project.getConfigurations().detachedConfiguration(dependencies);
            try {
                ObjectFactory objectFactory = project.getObjects();
                detachedConf.attributes(attributes -> {
                    attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)objectFactory.named(Category.class, "library")));
                    attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)objectFactory.named(Usage.class, "java-runtime")));
                    attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)objectFactory.named(LibraryElements.class, "jar")));
                    attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)objectFactory.named(Bundling.class, "external")));
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            this.resolvedDependencies = detachedConf.resolve();
        }
        return this.resolvedDependencies;
    }

    @TaskAction
    void run() {
        this.getResolvedDependencies();
    }
}

