/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import io.micrometer.prometheus.rsocket.PrometheusRSocketClient;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import io.rsocket.transport.netty.client.WebsocketClientTransport;
import java.net.URI;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.openrewrite.gradle.RewriteMetricsExtension;
import reactor.netty.http.client.HttpClient;
import reactor.netty.tcp.TcpClient;
import reactor.util.retry.Retry;

public class RewriteMetricsPlugin
implements Plugin<Project> {
    private RewriteMetricsExtension extension;
    private final PrometheusMeterRegistry rootProjectMeterRegistry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);

    public void apply(Project project) {
        if (project.getRootProject() == project) {
            this.extension = (RewriteMetricsExtension)project.getExtensions().create("rewriteMetrics", RewriteMetricsExtension.class, new Object[0]);
            project.afterEvaluate(p -> {
                this.rootProjectMeterRegistry.config().commonTags(new String[]{"project.root.project.name", project.getName(), "gradle.version", project.getGradle().getGradleVersion()}).commonTags(this.extension.getExtraMetricsTags());
                new JvmGcMetrics().bindTo((MeterRegistry)this.rootProjectMeterRegistry);
                new JvmMemoryMetrics().bindTo((MeterRegistry)this.rootProjectMeterRegistry);
                new JvmHeapPressureMetrics().bindTo((MeterRegistry)this.rootProjectMeterRegistry);
                new ProcessorMetrics().bindTo((MeterRegistry)this.rootProjectMeterRegistry);
                this.connectToPrometheusProxy(project);
            });
        } else {
            project.getLogger().warn("org.gradle.rewrite-metrics should only be applied to the root project");
        }
    }

    private void connectToPrometheusProxy(Project project) {
        URI uri = this.extension.getMetricsUri();
        if (uri != null) {
            TcpClientTransport clientTransport;
            switch (uri.getScheme()) {
                case "ephemeral": 
                case "https": 
                case "wss": {
                    TcpClient tcpClient = TcpClient.create().secure().host(uri.getHost()).port(RewriteMetricsPlugin.getPort(uri, 443));
                    clientTransport = this.websocketClientTransport(tcpClient);
                    break;
                }
                case "http": 
                case "ws": {
                    TcpClient tcpClient = TcpClient.create().host(uri.getHost()).port(RewriteMetricsPlugin.getPort(uri, 80));
                    clientTransport = this.websocketClientTransport(tcpClient);
                    break;
                }
                case "tcp": {
                    clientTransport = TcpClientTransport.create((String)uri.getHost(), (int)uri.getPort());
                    break;
                }
                default: {
                    project.getLogger().warn("Unable to publish metrics. Unrecognized scheme {}", (Object)uri.getScheme());
                    return;
                }
            }
            final PrometheusRSocketClient metricsClient = PrometheusRSocketClient.build((MeterRegistry)this.rootProjectMeterRegistry, () -> this.rootProjectMeterRegistry.scrape() + this.scrapeFromEachProject(project), (ClientTransport)clientTransport).retry((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofSeconds(1L)).maxBackoff(Duration.ofSeconds(3L))).connect();
            project.getGradle().addBuildListener((BuildListener)new BuildAdapter(){

                public void buildFinished(BuildResult result) {
                    try {
                        metricsClient.pushAndClose().block(Duration.ofSeconds(3L));
                    }
                    catch (Throwable ignore) {
                        ignore.printStackTrace();
                    }
                }
            });
        }
    }

    private String scrapeFromEachProject(Project rootProject) {
        throw new RuntimeException("Not implemented. Put this back in once metrics have been wired back in to RewritePlugin");
    }

    private ClientTransport websocketClientTransport(TcpClient tcpClient) {
        HttpClient httpClient = HttpClient.from((TcpClient)tcpClient).wiretap(true);
        if (this.extension.getMetricsUsername() != null && this.extension.getMetricsPassword() != null) {
            httpClient = httpClient.headers(h -> h.add("Authorization", (Object)("Basic: " + Base64.getUrlEncoder().encodeToString((this.extension.getMetricsUsername() + ":" + this.extension.getMetricsPassword()).getBytes()))));
        }
        return WebsocketClientTransport.create((HttpClient)httpClient, (String)"/");
    }

    static int getPort(URI uri, int defaultPort) {
        Objects.requireNonNull(uri, "uri must not be null");
        return uri.getPort() == -1 ? defaultPort : uri.getPort();
    }

    Iterable<Tag> getExtraTags() {
        return this.extension.getExtraMetricsTags();
    }
}

