/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collection;
import java.util.SortedSet;
import javax.inject.Inject;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.RewriteReflectiveFacade;
import org.openrewrite.gradle.ui.RecipeDescriptorTreePrompter;

public class RewriteDiscoverTask
extends AbstractRewriteTask {
    private static final Logger log = Logging.getLogger(RewriteDiscoverTask.class);
    private boolean interactive;

    @Option(description="Whether to enter an interactive shell to explore available recipes.", option="interactive")
    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    @Input
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Inject
    public RewriteDiscoverTask() {
        this.setGroup("rewrite");
        this.setDescription("Lists all available recipes and their visitors");
    }

    @TaskAction
    public void run() {
        RewriteReflectiveFacade.Environment env = this.environment();
        Collection<RewriteReflectiveFacade.RecipeDescriptor> availableRecipeDescriptors = env.listRecipeDescriptors();
        if (this.interactive) {
            log.quiet("Entering interactive mode, Ctrl-C to exit...");
            UserInputHandler prompter = (UserInputHandler)this.getServices().get(UserInputHandler.class);
            RecipeDescriptorTreePrompter treePrompter = new RecipeDescriptorTreePrompter(prompter);
            RewriteReflectiveFacade.RecipeDescriptor rd = treePrompter.execute(availableRecipeDescriptors);
            this.writeRecipeDescriptor(rd, true, 0);
        } else {
            SortedSet<String> activeRecipes = this.getActiveRecipes();
            Collection<RewriteReflectiveFacade.NamedStyles> availableStyles = env.listStyles();
            SortedSet<String> activeStyles = this.getActiveStyles();
            log.quiet("Available Recipes:");
            for (RewriteReflectiveFacade.RecipeDescriptor recipeDescriptor : availableRecipeDescriptors) {
                log.quiet(RewriteDiscoverTask.indent(1, recipeDescriptor.getName()));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Available Styles:");
            for (RewriteReflectiveFacade.NamedStyles namedStyles : availableStyles) {
                log.quiet(RewriteDiscoverTask.indent(1, namedStyles.getName()));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Active Styles:");
            for (String string : activeStyles) {
                log.quiet(RewriteDiscoverTask.indent(1, string));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Active Recipes:");
            for (String string : activeRecipes) {
                log.quiet(RewriteDiscoverTask.indent(1, string));
            }
            log.quiet(RewriteDiscoverTask.indent(0, ""));
            log.quiet("Found " + availableRecipeDescriptors.size() + " available recipes and " + availableStyles.size() + " available styles.");
            log.quiet("Configured with " + activeRecipes.size() + " active recipes and " + activeStyles.size() + " active styles.");
        }
    }

    private void writeRecipeDescriptor(RewriteReflectiveFacade.RecipeDescriptor rd, boolean verbose, int indentLevel) {
        if (verbose) {
            log.quiet(RewriteDiscoverTask.indent(indentLevel, rd.getDisplayName()));
            log.quiet(RewriteDiscoverTask.indent(indentLevel + 1, rd.getName()));
            if (rd.getDescription() != null && !rd.getDescription().isEmpty()) {
                log.quiet(RewriteDiscoverTask.indent(indentLevel + 1, rd.getDescription()));
            }
            if (!rd.getOptions().isEmpty()) {
                log.quiet(RewriteDiscoverTask.indent(indentLevel, "options: "));
                for (RewriteReflectiveFacade.OptionDescriptor od : rd.getOptions()) {
                    log.quiet(RewriteDiscoverTask.indent(indentLevel + 1, od.getName() + ": " + od.getType() + (od.isRequired() ? "!" : "")));
                    if (od.getDescription() == null || od.getDescription().isEmpty()) continue;
                    log.quiet(RewriteDiscoverTask.indent(indentLevel + 2, od.getDescription()));
                }
            }
        } else {
            log.quiet(RewriteDiscoverTask.indent(indentLevel, rd.getName()));
        }
        if (verbose) {
            log.quiet(RewriteDiscoverTask.indent(indentLevel, ""));
        }
    }
}

