/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.invocation.DefaultGradle;
import org.gradle.util.GradleVersion;
import org.openrewrite.ExecutionContext;
import org.openrewrite.SourceFile;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.TimeUtils;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.hcl.HclParser;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.json.JsonParser;
import org.openrewrite.marker.Marker;
import org.openrewrite.properties.PropertiesParser;
import org.openrewrite.protobuf.ProtoParser;
import org.openrewrite.python.PythonParser;
import org.openrewrite.quark.QuarkParser;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.text.PlainTextParser;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.style.Autodetect;
import org.openrewrite.xml.tree.Xml;
import org.openrewrite.yaml.YamlParser;

public class ResourceParser {
    private static final Set<String> DEFAULT_IGNORED_DIRECTORIES = new HashSet<String>(Arrays.asList("build", "target", "out", ".sonar", ".gradle", ".idea", ".project", "node_modules", ".git", ".metadata", ".DS_Store"));
    private static final Logger logger = Logging.getLogger(ResourceParser.class);
    private final Path baseDir;
    private final Project project;
    private final Collection<PathMatcher> exclusions;
    private final JavaTypeCache typeCache;
    private final Collection<PathMatcher> plainTextMasks;
    private final int sizeThresholdMb;

    public ResourceParser(Path baseDir, Project project, RewriteExtension extension, JavaTypeCache typeCache) {
        this.baseDir = baseDir;
        this.project = project;
        this.exclusions = this.pathMatchers(baseDir, ResourceParser.mergeExclusions(project, extension));
        this.plainTextMasks = this.pathMatchers(baseDir, extension.getPlainTextMasks());
        this.typeCache = typeCache;
        this.sizeThresholdMb = extension.getSizeThresholdMb();
    }

    private static Collection<String> mergeExclusions(Project project, RewriteExtension extension) {
        return Stream.concat(project.getSubprojects().stream().map(subproject -> project.getProjectDir().toPath().relativize(subproject.getProjectDir().toPath()).toString()), extension.getExclusions().stream()).collect(Collectors.toList());
    }

    private Collection<PathMatcher> pathMatchers(Path basePath, Collection<String> pathExpressions) {
        return pathExpressions.stream().map(o -> basePath.getFileSystem().getPathMatcher("glob:" + o)).collect(Collectors.toList());
    }

    public List<SourceFile> parse(Path projectDir, Collection<Path> alreadyParsed, ExecutionContext ctx) {
        return this.parse(projectDir, alreadyParsed, Collections.emptyList(), Collections.emptyList(), ctx);
    }

    public List<SourceFile> parse(Path projectDir, Collection<Path> alreadyParsed, List<Path> classpath, List<NamedStyles> styles, ExecutionContext ctx) {
        ArrayList<SourceFile> sourceFiles;
        logger.info("Parsing other sources from {}", (Object)projectDir);
        Instant start = Instant.now();
        try {
            sourceFiles = new ArrayList<SourceFile>(this.parseSourceFiles(projectDir, alreadyParsed, classpath, styles, ctx));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UncheckedIOException(e);
        }
        if (sourceFiles.size() > 0) {
            Duration duration = Duration.between(start, Instant.now());
            logger.info("Finished parsing {} other sources from {} in {} ({} per source)", new Object[]{sourceFiles.size(), projectDir, TimeUtils.prettyPrint(duration), TimeUtils.prettyPrint(duration.dividedBy(sourceFiles.size()))});
        }
        return sourceFiles;
    }

    public List<Path> listSources(final Path searchDir) throws IOException {
        final JsonParser jsonParser = new JsonParser();
        final XmlParser xmlParser = new XmlParser();
        final YamlParser yamlParser = new YamlParser();
        final PropertiesParser propertiesParser = new PropertiesParser();
        final ProtoParser protoParser = new ProtoParser();
        final PythonParser pythonParser = PythonParser.builder().build();
        final HclParser hclParser = HclParser.builder().build();
        final GroovyParser groovyParser = GroovyParser.builder().build();
        final GradleParser gradleParser = GradleParser.builder().build();
        final ArrayList<Path> resources = new ArrayList<Path>();
        Files.walkFileTree(searchDir, Collections.emptySet(), 16, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (ResourceParser.this.isExcluded(dir) || ResourceParser.this.isIgnoredDirectory(searchDir, dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (attrs.size() != 0L && !attrs.isOther() && !ResourceParser.this.isExcluded(file) && !ResourceParser.this.isOverSizeThreshold(attrs.size()) && (jsonParser.accept(file) || xmlParser.accept(file) || yamlParser.accept(file) || propertiesParser.accept(file) || protoParser.accept(file) || hclParser.accept(file) || pythonParser.accept(file) || groovyParser.accept(file) || gradleParser.accept(file) || ResourceParser.this.isParsedAsPlainText(file))) {
                    resources.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return resources;
    }

    public List<SourceFile> parseSourceFiles(final Path searchDir, final Collection<Path> alreadyParsed, List<Path> classpath, List<NamedStyles> styles, ExecutionContext ctx) throws IOException {
        List settingsClasspath;
        final ArrayList resources = new ArrayList();
        final ArrayList quarkPaths = new ArrayList();
        final ArrayList plainTextPaths = new ArrayList();
        Files.walkFileTree(searchDir, Collections.emptySet(), 16, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (ResourceParser.this.isExcluded(dir) || ResourceParser.this.isIgnoredDirectory(searchDir, dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!(attrs.isOther() || attrs.isSymbolicLink() || alreadyParsed.contains(file) || ResourceParser.this.isExcluded(file))) {
                    if (ResourceParser.this.isOverSizeThreshold(attrs.size())) {
                        logger.info("Parsing as quark {} as its size {}Mb exceeds size threshold {}Mb", new Object[]{file, attrs.size() / 0x100000L, ResourceParser.this.sizeThresholdMb});
                        quarkPaths.add(file);
                    } else if (ResourceParser.this.isParsedAsPlainText(file)) {
                        plainTextPaths.add(file);
                    } else {
                        resources.add(file);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        ArrayList<SourceFile> sourceFiles = new ArrayList<SourceFile>(resources.size());
        JsonParser jsonParser = new JsonParser();
        ArrayList jsonPaths = new ArrayList();
        XmlParser xmlParser = new XmlParser();
        ArrayList xmlPaths = new ArrayList();
        YamlParser yamlParser = new YamlParser();
        ArrayList yamlPaths = new ArrayList();
        PropertiesParser propertiesParser = new PropertiesParser();
        ArrayList propertiesPaths = new ArrayList();
        ProtoParser protoParser = new ProtoParser();
        ArrayList protoPaths = new ArrayList();
        HclParser hclParser = HclParser.builder().build();
        ArrayList hclPaths = new ArrayList();
        PythonParser pythonParser = PythonParser.builder().typeCache(this.typeCache).build();
        ArrayList pythonPaths = new ArrayList();
        GroovyParser groovyParser = GroovyParser.builder().classpath(classpath).typeCache(this.typeCache).styles(styles).logCompilationWarningsAndErrors(false).build();
        ArrayList groovyPaths = new ArrayList();
        List buildscriptClasspath = this.project.getBuildscript().getConfigurations().getByName("classpath").resolve().stream().map(File::toPath).collect(Collectors.toList());
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.4")) >= 0) {
            SettingsInternal settings = ((DefaultGradle)this.project.getGradle()).getSettings();
            settingsClasspath = settings.getBuildscript().getConfigurations().getByName("classpath").resolve().stream().map(File::toPath).collect(Collectors.toList());
        } else {
            settingsClasspath = Collections.emptyList();
        }
        GradleParser gradleParser = GradleParser.builder().groovyParser(GroovyParser.builder().typeCache(this.typeCache).styles(styles).logCompilationWarningsAndErrors(false)).buildscriptClasspath(buildscriptClasspath).settingsClasspath(settingsClasspath).build();
        ArrayList gradlePaths = new ArrayList();
        PlainTextParser plainTextParser = new PlainTextParser();
        QuarkParser quarkParser = new QuarkParser();
        resources.forEach(path -> {
            if (jsonParser.accept(path)) {
                jsonPaths.add(path);
            } else if (xmlParser.accept(path)) {
                xmlPaths.add(path);
            } else if (yamlParser.accept(path)) {
                yamlPaths.add(path);
            } else if (propertiesParser.accept(path)) {
                propertiesPaths.add(path);
            } else if (protoParser.accept(path)) {
                protoPaths.add(path);
            } else if (hclParser.accept(path)) {
                hclPaths.add(path);
            } else if (pythonParser.accept(path)) {
                pythonPaths.add(path);
            } else if (groovyParser.accept(path)) {
                groovyPaths.add(path);
            } else if (gradleParser.accept(path)) {
                gradlePaths.add(path);
            } else if (quarkParser.accept(path)) {
                quarkPaths.add(path);
            }
        });
        sourceFiles.addAll(jsonParser.parse(jsonPaths, this.baseDir, ctx));
        alreadyParsed.addAll(jsonPaths);
        sourceFiles.addAll(this.autodetectXmlStyles(xmlParser.parse(xmlPaths, this.baseDir, ctx)));
        alreadyParsed.addAll(xmlPaths);
        sourceFiles.addAll(yamlParser.parse(yamlPaths, this.baseDir, ctx));
        alreadyParsed.addAll(yamlPaths);
        sourceFiles.addAll(propertiesParser.parse(propertiesPaths, this.baseDir, ctx));
        alreadyParsed.addAll(propertiesPaths);
        sourceFiles.addAll(protoParser.parse(protoPaths, this.baseDir, ctx));
        alreadyParsed.addAll(protoPaths);
        sourceFiles.addAll(hclParser.parse(hclPaths, this.baseDir, ctx));
        alreadyParsed.addAll(hclPaths);
        sourceFiles.addAll(pythonParser.parse(pythonPaths, this.baseDir, ctx));
        alreadyParsed.addAll(pythonPaths);
        sourceFiles.addAll(groovyParser.parse(groovyPaths, this.baseDir, ctx));
        alreadyParsed.addAll(groovyPaths);
        sourceFiles.addAll(gradleParser.parse(gradlePaths, this.baseDir, ctx));
        alreadyParsed.addAll(gradlePaths);
        sourceFiles.addAll(plainTextParser.parse(plainTextPaths, this.baseDir, ctx));
        alreadyParsed.addAll(plainTextPaths);
        sourceFiles.addAll(quarkParser.parse(quarkPaths, this.baseDir, ctx));
        alreadyParsed.addAll(quarkPaths);
        return sourceFiles;
    }

    private boolean isOverSizeThreshold(long fileSize) {
        return this.sizeThresholdMb > 0 && fileSize > (long)this.sizeThresholdMb * 1024L * 1024L;
    }

    private boolean isExcluded(Path path) {
        if (!this.exclusions.isEmpty()) {
            Path relative = this.baseDir.relativize(path);
            for (PathMatcher excluded : this.exclusions) {
                if (!excluded.matches(relative)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isParsedAsPlainText(Path path) {
        if (!this.plainTextMasks.isEmpty()) {
            Path computed = this.baseDir.relativize(path);
            for (PathMatcher matcher : this.plainTextMasks) {
                if (!matcher.matches(computed)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIgnoredDirectory(Path searchDir, Path path) {
        for (Path pathSegment : searchDir.relativize(path)) {
            if (!DEFAULT_IGNORED_DIRECTORIES.contains(pathSegment.toString())) continue;
            return true;
        }
        return false;
    }

    private List<Xml.Document> autodetectXmlStyles(List<Xml.Document> xmls) {
        Autodetect xmlStyle = Autodetect.detect(xmls);
        return ListUtils.map(xmls, xml -> xml.withMarkers(xml.getMarkers().add((Marker)xmlStyle)));
    }
}

