/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.io.File;
import java.util.Map;
import javax.inject.Provider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.openrewrite.gradle.AbstractRewriteTask;
import org.openrewrite.gradle.ResolveRewriteDependenciesTask;
import org.openrewrite.gradle.RewriteDiscoverTask;
import org.openrewrite.gradle.RewriteDryRunTask;
import org.openrewrite.gradle.RewriteExtension;
import org.openrewrite.gradle.RewriteRunTask;

public class RewritePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        boolean isRootProject;
        boolean bl = isRootProject = project == project.getRootProject();
        if (!isRootProject && project.getRootProject().getPluginManager().hasPlugin("org.openrewrite.rewrite")) {
            return;
        }
        if (project.getRootProject().getPluginManager().hasPlugin("io.moderne.rewrite")) {
            return;
        }
        RewriteExtension extension = (RewriteExtension)project.getExtensions().create("rewrite", RewriteExtension.class, new Object[]{project});
        Configuration rewriteConf = (Configuration)project.getConfigurations().maybeCreate("rewrite");
        ResolveRewriteDependenciesTask resolveRewriteDependenciesTask = ((ResolveRewriteDependenciesTask)project.getTasks().create("rewriteResolveDependencies", ResolveRewriteDependenciesTask.class)).setExtension(extension).setConfiguration(rewriteConf);
        RewriteRunTask rewriteRun = (RewriteRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteRunTask)project.getTasks().create("rewriteRun", RewriteRunTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask));
        rewriteRun.dependsOn(new Object[]{rewriteConf});
        RewriteDryRunTask rewriteDryRun = (RewriteDryRunTask)((Object)((AbstractRewriteTask)((Object)((RewriteDryRunTask)project.getTasks().create("rewriteDryRun", RewriteDryRunTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask));
        rewriteDryRun.dependsOn(new Object[]{rewriteConf});
        RewriteDiscoverTask rewriteDiscover = (RewriteDiscoverTask)((Object)((AbstractRewriteTask)((Object)((RewriteDiscoverTask)project.getTasks().create("rewriteDiscover", RewriteDiscoverTask.class)).setExtension(extension))).setResolveDependenciesTask(resolveRewriteDependenciesTask));
        rewriteDiscover.dependsOn(new Object[]{rewriteConf});
        if (isRootProject) {
            project.allprojects(subproject -> RewritePlugin.configureProject(subproject, extension, rewriteDryRun, rewriteRun));
        } else {
            RewritePlugin.configureProject(project, extension, rewriteDryRun, rewriteRun);
        }
    }

    private static void configureProject(Project project, RewriteExtension extension, RewriteDryRunTask rewriteDryRun, RewriteRunTask rewriteRun) {
        project.getPlugins().all(plugin -> {
            if (plugin instanceof CheckstylePlugin) {
                CheckstyleExtension checkstyleExtension = (CheckstyleExtension)project.getExtensions().getByType(CheckstyleExtension.class);
                extension.setCheckstyleConfigProvider((Provider<File>)((Provider)() -> ((CheckstyleExtension)checkstyleExtension).getConfigFile()));
                extension.setCheckstylePropertiesProvider((Provider<Map<String, Object>>)((Provider)() -> ((CheckstyleExtension)checkstyleExtension).getConfigProperties()));
            }
            if (!(plugin instanceof JavaBasePlugin)) {
                return;
            }
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            javaConvention.getSourceSets().all(sourceSet -> {
                Task compileTask = project.getTasks().getByPath(sourceSet.getCompileJavaTaskName());
                rewriteRun.dependsOn(new Object[]{compileTask});
                rewriteDryRun.dependsOn(new Object[]{compileTask});
            });
        });
    }
}

