/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.isolated;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openrewrite.RecipeRun;
import org.openrewrite.Result;
import org.openrewrite.internal.lang.Nullable;

public class ResultsContainer {
    final Path projectRoot;
    final RecipeRun recipeRun;
    final List<Result> generated = new ArrayList<Result>();
    final List<Result> deleted = new ArrayList<Result>();
    final List<Result> moved = new ArrayList<Result>();
    final List<Result> refactoredInPlace = new ArrayList<Result>();

    public ResultsContainer(Path projectRoot, @Nullable RecipeRun recipeRun) {
        this.projectRoot = projectRoot;
        this.recipeRun = recipeRun;
        if (recipeRun != null) {
            for (Result result : recipeRun.getResults()) {
                if (result.getBefore() == null && result.getAfter() == null) continue;
                if (result.getBefore() == null && result.getAfter() != null) {
                    this.generated.add(result);
                    continue;
                }
                if (result.getBefore() != null && result.getAfter() == null) {
                    this.deleted.add(result);
                    continue;
                }
                if (result.getBefore() != null && !result.getBefore().getSourcePath().equals(result.getAfter().getSourcePath())) {
                    this.moved.add(result);
                    continue;
                }
                this.refactoredInPlace.add(result);
            }
        }
    }

    public Path getProjectRoot() {
        return this.projectRoot;
    }

    public boolean isNotEmpty() {
        return !this.generated.isEmpty() || !this.deleted.isEmpty() || !this.moved.isEmpty() || !this.refactoredInPlace.isEmpty();
    }
}

