/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import com.puppycrawl.tools.checkstyle.Checker;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.style.CheckstyleConfigLoader;
import org.openrewrite.style.NamedStyles;

public abstract class ConfigurableRewriteMojo
extends AbstractMojo {
    @Parameter(property="rewrite.configLocation", alias="configLocation", defaultValue="${maven.multiModuleProjectDirectory}/rewrite.yml")
    protected String configLocation;
    @Parameter(property="activeRecipes")
    protected List<String> activeRecipes = Collections.emptyList();
    @Nullable
    @Parameter(property="rewrite.activeRecipes")
    protected String rewriteActiveRecipes;
    @Parameter(property="activeStyles")
    protected Set<String> activeStyles = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.activeStyles")
    protected String rewriteActiveStyles;
    @Nullable
    @Parameter(property="rewrite.metricsUri", alias="metricsUri")
    protected String metricsUri;
    @Nullable
    @Parameter(property="rewrite.metricsUsername", alias="metricsUsername")
    protected String metricsUsername;
    @Nullable
    @Parameter(property="rewrite.metricsPassword", alias="metricsPassword")
    protected String metricsPassword;
    @Parameter(property="rewrite.pomCacheEnabled", alias="pomCacheEnabled", defaultValue="true")
    protected boolean pomCacheEnabled;
    @Nullable
    @Parameter(property="rewrite.pomCacheDirectory", alias="pomCacheDirectory")
    protected String pomCacheDirectory;
    @Parameter(property="rewrite.skip", defaultValue="false")
    protected boolean rewriteSkip;
    @Parameter(property="skipMavenParsing", defaultValue="false")
    protected boolean skipMavenParsing;
    @Nullable
    @Parameter(property="rewrite.checkstyleConfigFile", alias="checkstyleConfigFile")
    protected String checkstyleConfigFile;
    @Nullable
    @Parameter(property="rewrite.checkstyleDetectionEnabled", alias="checkstyleDetectionEnabled", defaultValue="true")
    protected boolean checkstyleDetectionEnabled;
    @Parameter(property="exclusions")
    private Set<String> exclusions = Collections.emptySet();
    @Nullable
    @Parameter(property="rewrite.exclusions")
    private String rewriteExclusions;
    @Parameter(property="plainTextMasks")
    private Set<String> plainTextMasks = new HashSet<String>();
    @Nullable
    @Parameter(property="rewrite.plainTextMasks")
    private String rewritePlainTextMasks;
    @Nullable
    @Parameter(property="sizeThresholdMb", defaultValue="10")
    protected int sizeThresholdMb;
    @Parameter(property="rewrite.failOnInvalidActiveRecipes", alias="failOnInvalidActiveRecipes", defaultValue="false")
    protected boolean failOnInvalidActiveRecipes;
    @Parameter(property="rewrite.runPerSubmodule", alias="runPerSubmodule", defaultValue="false")
    protected boolean runPerSubmodule;
    @Nullable
    @Parameter(property="rewrite.recipeArtifactCoordinates")
    private String recipeArtifactCoordinates;
    @Nullable
    private volatile Set<String> computedRecipes;
    @Nullable
    private volatile Set<String> computedStyles;
    @Nullable
    private volatile Set<String> computedRecipeArtifactCoordinates;

    protected Set<String> getExclusions() {
        if (this.rewriteExclusions == null) {
            return this.exclusions;
        }
        Set<String> allExclusions = ConfigurableRewriteMojo.toSet(this.rewriteExclusions);
        allExclusions.addAll(this.exclusions);
        return allExclusions;
    }

    protected Set<String> getPlainTextMasks() {
        if (this.plainTextMasks.isEmpty() && this.rewritePlainTextMasks == null) {
            return new HashSet<String>(Arrays.asList("**/*.adoc", "**/*.bash", "**/*.bat", "**/CODEOWNERS", "**/*.css", "**/*.config", "**/Dockerfile*", "**/.gitattributes", "**/.gitignore", "**/*.htm*", "**/gradlew", "**/.java-version", "**/*.jsp", "**/*.ksh", "**/lombok.config", "**/*.md", "**/*.mf", "**/META-INF/services/**", "**/META-INF/spring/**", "**/META-INF/spring.factories", "**/mvnw", "**/mvnw.cmd", "**/*.qute.java", "**/.sdkmanrc", "**/*.sh", "**/*.sql", "**/*.svg", "**/*.txt"));
        }
        Set<String> masks = ConfigurableRewriteMojo.toSet(this.rewritePlainTextMasks);
        masks.addAll(this.plainTextMasks);
        return masks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveRecipes() {
        if (this.computedRecipes == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipes == null) {
                    Set<String> res = ConfigurableRewriteMojo.toLinkedHashSet(this.rewriteActiveRecipes);
                    if (res.isEmpty()) {
                        res.addAll(this.activeRecipes.stream().filter(Objects::nonNull).collect(Collectors.toList()));
                    }
                    this.computedRecipes = Collections.unmodifiableSet(res);
                }
            }
        }
        return this.computedRecipes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getActiveStyles() {
        if (this.computedStyles == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedStyles == null) {
                    Set<String> res = ConfigurableRewriteMojo.toSet(this.rewriteActiveStyles);
                    if (res.isEmpty()) {
                        res.addAll(this.activeStyles);
                    }
                    this.computedStyles = Collections.unmodifiableSet(res);
                }
            }
        }
        return this.computedStyles;
    }

    protected List<NamedStyles> loadStyles(MavenProject project, Environment env) {
        List styles;
        block12: {
            styles = env.activateStyles(this.getActiveStyles());
            try {
                Object checkstyleConfRaw;
                Plugin checkstylePlugin = project.getPlugin("org.apache.maven.plugins:maven-checkstyle-plugin");
                if (this.checkstyleConfigFile != null && !this.checkstyleConfigFile.isEmpty()) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)Paths.get(this.checkstyleConfigFile, new String[0]), Collections.emptyMap()));
                    break block12;
                }
                if (!this.checkstyleDetectionEnabled || checkstylePlugin == null || !((checkstyleConfRaw = checkstylePlugin.getConfiguration()) instanceof Xpp3Dom)) break block12;
                Xpp3Dom xmlCheckstyleConf = (Xpp3Dom)checkstyleConfRaw;
                Xpp3Dom xmlConfigLocation = xmlCheckstyleConf.getChild("configLocation");
                if (xmlConfigLocation == null) {
                    try (InputStream is = Checker.class.getResourceAsStream("/sun_checks.xml");){
                        if (is != null) {
                            styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((InputStream)is, Collections.emptyMap()));
                        }
                        break block12;
                    }
                }
                Path configPath = Paths.get(checkstylePlugin.getLocation((Object)"").getSource().getLocation(), new String[0]).resolveSibling(xmlConfigLocation.getValue());
                if (configPath.toFile().exists()) {
                    styles.add(CheckstyleConfigLoader.loadCheckstyleConfig((Path)configPath, Collections.emptyMap()));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)"Unable to parse checkstyle configuration. Checkstyle will not inform rewrite execution.", (Throwable)e);
            }
        }
        return styles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRecipeArtifactCoordinates() {
        if (this.computedRecipeArtifactCoordinates == null) {
            ConfigurableRewriteMojo configurableRewriteMojo = this;
            synchronized (configurableRewriteMojo) {
                if (this.computedRecipeArtifactCoordinates == null) {
                    this.computedRecipeArtifactCoordinates = Collections.unmodifiableSet(ConfigurableRewriteMojo.toSet(this.recipeArtifactCoordinates));
                }
            }
        }
        return this.computedRecipeArtifactCoordinates;
    }

    private static Set<String> toSet(@Nullable String propertyValue) {
        return Optional.ofNullable(propertyValue).filter(s -> !s.isEmpty()).map(s -> new HashSet<String>(Arrays.asList(s.split(",")))).orElseGet(HashSet::new);
    }

    private static Set<String> toLinkedHashSet(@Nullable String propertyValue) {
        return Optional.ofNullable(propertyValue).filter(s -> !s.isEmpty()).map(s -> new LinkedHashSet<String>(Arrays.asList(s.split(",")))).orElseGet(LinkedHashSet::new);
    }
}

