/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;

public class LauncherUtils {
    static final Pattern JAVA_STYLE_UNC_URL = Pattern.compile("^file:////([^/]+/.*)$");

    protected static File createCustomProfileDir(String sessionId) {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String customProfileDirParent = tmpDir.exists() && tmpDir.isDirectory() ? tmpDir.getAbsolutePath() : ".";
        File customProfileDir = new File(customProfileDirParent + "/customProfileDir" + sessionId);
        if (customProfileDir.exists()) {
            LauncherUtils.recursivelyDeleteDir(customProfileDir);
        }
        customProfileDir.mkdir();
        return customProfileDir;
    }

    protected static void recursivelyDeleteDir(File customProfileDir) {
        if (customProfileDir == null || !customProfileDir.exists()) {
            return;
        }
        Delete delete = new Delete();
        delete.setProject(new Project());
        delete.setDir(customProfileDir);
        delete.setFailOnError(true);
        delete.execute();
    }

    protected static void deleteTryTryAgain(File dir, int tries) {
        try {
            LauncherUtils.recursivelyDeleteDir(dir);
        }
        catch (BuildException e) {
            if (tries > 0) {
                AsyncExecute.sleepTight(2000L);
                LauncherUtils.deleteTryTryAgain(dir, tries - 1);
            }
            throw e;
        }
    }

    protected static File makeProxyPAC(File parentDir, int port) throws FileNotFoundException {
        return LauncherUtils.makeProxyPAC(parentDir, port, true);
    }

    protected static File makeProxyPAC(File parentDir, int port, boolean proxySeleniumTrafficOnly) throws FileNotFoundException {
        if (SeleniumServer.isAlwaysProxy()) {
            proxySeleniumTrafficOnly = false;
        }
        File proxyPAC = new File(parentDir, "proxy.pac");
        PrintStream out = new PrintStream(new FileOutputStream(proxyPAC));
        String defaultProxy = "DIRECT";
        String configuredProxy = System.getProperty("http.proxyHost");
        if (configuredProxy != null) {
            defaultProxy = "PROXY " + configuredProxy;
            String proxyPort = System.getProperty("http.proxyPort");
            if (proxyPort != null) {
                defaultProxy = defaultProxy + ":" + proxyPort;
            }
        }
        out.println("function FindProxyForURL(url, host) {");
        if (proxySeleniumTrafficOnly) {
            out.println("    if(shExpMatch(url, '*/selenium-server/*')) {");
        }
        out.println("        return 'PROXY localhost:" + Integer.toString(port) + "; " + defaultProxy + "';");
        if (configuredProxy != null) {
            out.println("    } else {");
            out.println("        return '" + defaultProxy + "';");
        }
        if (proxySeleniumTrafficOnly) {
            out.println("    }");
        }
        out.println("}");
        out.close();
        return proxyPAC;
    }

    public static String stripStartURL(String url) {
        try {
            URL u = new URL(url);
            return u.getProtocol() + "://" + u.getAuthority();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getQueryString(String url) {
        try {
            URL u = new URL(url);
            String query = u.getQuery();
            return query == null ? "" : query;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getDefaultHTMLSuiteUrl(String browserURL, String suiteUrl, boolean multiWindow) {
        String url = LauncherUtils.stripStartURL(browserURL);
        return url + "/selenium-server/core/TestRunner.html?auto=true&" + "multiWindow=" + multiWindow + "&resultsUrl=../postResults&test=" + suiteUrl;
    }

    protected static String getDefaultRemoteSessionUrl(String startURL, String sessionId, boolean multiWindow) {
        String url = LauncherUtils.stripStartURL(startURL);
        return url + "/selenium-server/core/RemoteRunner.html?" + "sessionId=" + sessionId + "&multiWindow=" + multiWindow + "&debugMode=" + SeleniumServer.isDebugMode();
    }

    protected static File extractHTAFile(File dir, int port, String resourceFile, String outFile) {
        InputStream input = HTABrowserLauncher.class.getResourceAsStream(resourceFile);
        BufferedReader br = new BufferedReader(new InputStreamReader(input));
        File hta = new File(dir, outFile);
        try {
            FileWriter fw = new FileWriter(hta);
            String line = br.readLine();
            fw.write(line);
            fw.write(10);
            fw.write("<base href=\"http://localhost:" + port + "/selenium-server/core/\">");
            while ((line = br.readLine()) != null) {
                fw.write(line);
                fw.write(10);
            }
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return hta;
    }

    protected static void assertNotScriptFile(File f) {
        try {
            FileReader r = new FileReader(f);
            char[] firstTwoChars = new char[2];
            int charsRead = r.read(firstTwoChars);
            if (charsRead != 2) {
                return;
            }
            if (firstTwoChars[0] == '#' && firstTwoChars[1] == '!') {
                throw new RuntimeException("File was a script file, not a real executable: " + f.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void copyDirectory(File source, File dest) {
        Project p = new Project();
        Copy c = new Copy();
        c.setProject(p);
        c.setTodir(dest);
        FileSet fs = new FileSet();
        fs.setDir(source);
        c.addFileset(fs);
        c.execute();
    }

    protected static void generatePacAndPrefJs(File customProfileDir, int port, boolean proxySeleniumTrafficOnly) throws FileNotFoundException {
        LauncherUtils.generatePacAndPrefJs(customProfileDir, port, proxySeleniumTrafficOnly, null);
    }

    protected static void generatePacAndPrefJs(File customProfileDir, int port, boolean proxySeleniumTrafficOnly, String homePage) throws FileNotFoundException {
        File proxyPAC = LauncherUtils.makeProxyPAC(customProfileDir, port, proxySeleniumTrafficOnly);
        File prefsJS = new File(customProfileDir, "prefs.js");
        PrintStream out = new PrintStream(new FileOutputStream(prefsJS, true));
        out.println("user_pref('browser.shell.checkDefaultBrowser', false);");
        out.println("user_pref('network.http.phishy-userpass-length', 255);");
        out.println("user_pref('browser.allowpopups', true);");
        out.println("user_pref('dom.disable_open_during_load', false);");
        out.println("user_pref('browser.link.open_external', 2);");
        out.println("user_pref('browser.link.open_newwindow', 2);");
        out.println("user_pref('network.proxy.type', 2);");
        out.println("user_pref('network.proxy.autoconfig_url', '" + LauncherUtils.pathToBrowserURL(proxyPAC.getAbsolutePath()) + "');");
        if (homePage != null) {
            out.println("user_pref('startup.homepage_override_url', '" + homePage + "');");
            out.println("user_pref('browser.startup.homepage', '" + homePage + "');");
            out.println("user_pref('startup.homepage_welcome_url', '');");
        }
        out.println("user_pref('security.warn_submit_insecure', false);");
        out.println("user_pref('security.warn_submit_insecure.show_once', false);");
        out.println("user_pref('security.warn_entering_secure', false);");
        out.println("user_pref('security.warn_entering_secure.show_once', false);");
        out.println("user_pref('security.warn_entering_weak', false);");
        out.println("user_pref('security.warn_entering_weak.show_once', false);");
        out.println("user_pref('security.warn_leaving_secure', false);");
        out.println("user_pref('security.warn_leaving_secure.show_once', false);");
        out.println("user_pref('security.warn_viewing_mixed', false);");
        out.println("user_pref('security.warn_viewing_mixed.show_once', false);");
        out.println("user_pref('browser.cache.disk.enable', false);");
        out.println("user_pref('browser.cache.memory.enable', false);");
        out.println("user_pref('signon.rememberSignons', false);");
        out.close();
    }

    private static String pathToBrowserURL(String path) {
        if (path == null) {
            return null;
        }
        String url = new File(path).toURI().toString();
        Matcher m = JAVA_STYLE_UNC_URL.matcher(url);
        if (m.find()) {
            url = "file://///";
            url = url + m.group(1);
        }
        return url;
    }
}

