/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import com.google.gradle.osdetector.OsDetector;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;

public enum JavaFXPlatform {
    LINUX("linux", "linux-x86_64"),
    LINUX_AARCH64("linux-aarch64", "linux-aarch_64"),
    WINDOWS("win", "windows-x86_64"),
    OSX("mac", "osx-x86_64"),
    OSX_AARCH64("mac-aarch64", "osx-aarch_64");

    private final String classifier;
    private final String osDetectorClassifier;

    private JavaFXPlatform(String classifier, String osDetectorClassifier) {
        this.classifier = classifier;
        this.osDetectorClassifier = osDetectorClassifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public static JavaFXPlatform detect(Project project) {
        String osClassifier = ((OsDetector)project.getExtensions().getByType(OsDetector.class)).getClassifier();
        for (JavaFXPlatform platform : JavaFXPlatform.values()) {
            if (!platform.osDetectorClassifier.equals(osClassifier)) continue;
            return platform;
        }
        String supportedPlatforms = Arrays.stream(JavaFXPlatform.values()).map(p -> p.osDetectorClassifier).collect(Collectors.joining("', '", "'", "'"));
        throw new GradleException(String.format("Unsupported JavaFX platform found: '%s'! This plugin is designed to work on supported platforms only.Current supported platforms are %s.", osClassifier, supportedPlatforms));
    }
}

