/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.util;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.patterns.PatternProvider;

public class RegexUtil {
    public static String regex_or_match(String ... items) {
        String r = StringUtils.join((Object[])items, (String)"|");
        r = '(' + r + ')';
        return r;
    }

    public static String regex_or_match(PatternProvider ... patterns) {
        String[] allpat = new String[patterns.length];
        int i = 0;
        for (PatternProvider patternProvider : patterns) {
            allpat[i++] = patternProvider.patternString();
        }
        return RegexUtil.regex_or_match(allpat);
    }

    public static String regex_or_match(List<String> items) {
        String r = StringUtils.join(items, (String)"|");
        r = '(' + r + ')';
        return r;
    }

    public static String regex_char_neg(List<String> puncs) {
        String r = StringUtils.join(puncs, (String)"");
        r = "[" + r + ']';
        return r;
    }

    public static String pos_lookahead(String r) {
        return "(?=" + r + ')';
    }

    public static String neg_lookahead(String r) {
        return "(?!" + r + ')';
    }

    public static String optional(String r) {
        return String.format("(%s)?", r);
    }
}

