/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.model.wordlist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.feature.IdentityFeatureExtractor;
import org.openimaj.io.IOUtils;
import org.openimaj.ml.annotation.ScoredAnnotation;
import org.openimaj.text.nlp.sentiment.model.TokenSentimentAnnotator;
import org.openimaj.text.nlp.sentiment.model.wordlist.util.TFF;
import org.openimaj.text.nlp.sentiment.type.BipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.TFFCountSentiment;

@Reference(author={"Janyce Wiebe", "Theresa Wilson", "Claire Cardie"}, title="Annotating expressions of opinions and emotions in language. ", type=ReferenceType.Article, year="2005")
public class MPQAToken
extends TokenSentimentAnnotator<IdentityFeatureExtractor<String>, MPQAToken> {
    private static final String DEFAULT_MODEL = "/org/openimaj/text/sentiment/mpqa/subjclueslen1polar.tff";
    private TFF model;

    public MPQAToken() throws IOException {
        super(new IdentityFeatureExtractor());
        this.model = (TFF)IOUtils.read((InputStream)MPQAToken.class.getResourceAsStream(DEFAULT_MODEL), TFF.class);
    }

    public MPQAToken(File f) throws IOException {
        super(new IdentityFeatureExtractor());
        this.model = (TFF)IOUtils.read((File)f, TFF.class);
    }

    public MPQAToken(MPQAToken mpqa) {
        super(new IdentityFeatureExtractor());
        this.model = mpqa.model.clone();
    }

    public List<ScoredAnnotation<BipolarSentiment>> annotate(String word) {
        ArrayList<ScoredAnnotation<BipolarSentiment>> ret = new ArrayList<ScoredAnnotation<BipolarSentiment>>();
        List<TFF.Clue> clueList = this.model.entriesMap.get(word);
        if (clueList == null) {
            return ret;
        }
        for (TFF.Clue clue : clueList) {
            ret.add((ScoredAnnotation<BipolarSentiment>)new ScoredAnnotation((Object)TFFCountSentiment.bipolar(clue), 1.0f));
        }
        return ret;
    }
}

