/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.patterns;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.patterns.PatternProvider;
import org.openimaj.text.nlp.patterns.PunctuationPatternProvider;
import org.openimaj.text.util.RegexUtil;

public class EmbeddedDashPatternProvider
extends PatternProvider {
    private String EmbeddedDash;
    private String[] potentialDash = new String[]{"-"};

    public EmbeddedDashPatternProvider(PunctuationPatternProvider punctuation) {
        List<String> puncs = punctuation.notMinus(this.potentialDash);
        String notpuncs = RegexUtil.regex_char_neg(puncs);
        String dashPuncs = "[" + StringUtils.join((Object[])this.potentialDash, (String)"") + "]";
        this.EmbeddedDash = String.format("%s+(%s%s+)+\\b", notpuncs, dashPuncs, notpuncs);
    }

    @Override
    public String patternString() {
        return this.EmbeddedDash;
    }
}

