/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.patterns;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openimaj.text.nlp.patterns.PatternProvider;
import org.openimaj.text.nlp.patterns.PunctuationPatternProvider;
import org.openimaj.text.util.RegexUtil;

public class EmbeddedApostrophePatternProvider
extends PatternProvider {
    private final String EmbeddedApostrophe;
    private final String[] potentialApostrphe = new String[]{"'", "\u2019", "\u2018", "\u201b", "\\-"};

    public EmbeddedApostrophePatternProvider(PunctuationPatternProvider punctuation) {
        List<String> puncs = punctuation.notMinus(new String[0]);
        puncs.add(" ");
        String notpuncs = RegexUtil.regex_char_neg(puncs);
        String apostrophePuncs = "(?:[" + StringUtils.join((Object[])this.potentialApostrphe, (String)"]+|[") + "])";
        this.EmbeddedApostrophe = String.format(notpuncs + "+" + apostrophePuncs + "" + notpuncs + "+", new Object[0]);
    }

    @Override
    public String patternString() {
        return this.EmbeddedApostrophe;
    }
}

