/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import java.util.ArrayList;

public class SparqlQueryPager {
    private String endPoint;
    private int increaseFactor = 5;

    public SparqlQueryPager(String endPoint) {
        this.endPoint = endPoint;
    }

    public ArrayList<QuerySolution> pageQuery(String queryString) {
        ArrayList<QuerySolution> subResult;
        int rollBacks = 0;
        ArrayList<QuerySolution> result = new ArrayList<QuerySolution>();
        int currentOffset = 0;
        int currentChunkSize = 500;
        while (true) {
            String pageQueryString;
            if ((subResult = this.fetch(pageQueryString = queryString + " OFFSET " + currentOffset + " LIMIT " + currentChunkSize)) == null) {
                if (rollBacks > 2) {
                    return result;
                }
                currentChunkSize /= this.increaseFactor;
                ++rollBacks;
                continue;
            }
            if (subResult.size() < currentChunkSize) break;
            result.addAll(subResult);
            currentOffset += currentChunkSize;
            currentChunkSize *= this.increaseFactor;
        }
        result.addAll(subResult);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<QuerySolution> fetch(String pageQueryString) {
        ArrayList<QuerySolution> result = new ArrayList<QuerySolution>();
        Query q = QueryFactory.create((String)pageQueryString);
        try (QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.endPoint, (Query)q);){
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln);
            }
        }
        return result;
    }
}

