/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.PlainTextConverter;
import info.bliki.wiki.model.WikiModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.openimaj.text.nlp.namedentity.NamedEntity;
import org.openimaj.text.nlp.namedentity.QuickIndexer;
import org.openimaj.text.nlp.namedentity.YagoNamedEntity;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EntityExtractionResourceBuilder {
    public static String DEFAULT_ALIAS_NAME = "AliasMapFile.txt";
    public static String DEFAULT_CONTEXT_NAME = "YagoLucene";
    private static String DEFAULT_ROOT_NAME = ".YagoEntityExtraction";
    private static String wikiApiPrefix = "http://en.wikipedia.org/w/api.php?format=xml&action=query&titles=";
    private static String wikiApiSuffix = "&prop=revisions&rvprop=content";
    private boolean verbose = true;
    private boolean locations = false;
    private static BufferedWriter logOut;

    public void buildCandidateAliasFile(String seedDirectoryPath) {
        this.buildCandidateAliasFile(seedDirectoryPath, EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + DEFAULT_ALIAS_NAME);
    }

    public void buildCandidateAliasFile(String seedDirectoryPath, String destinationPath) {
        this.writeAliasFile(this.getEntities(seedDirectoryPath), destinationPath, seedDirectoryPath);
    }

    public void buildContextLuceneIndex(String seedDirectoryPath) {
        this.buildContextLuceneIndex(seedDirectoryPath, EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + DEFAULT_CONTEXT_NAME);
    }

    public void buildContextLuceneIndex(String seedDirectoryPath, String destinationPath) {
        try {
            this.buildIndex(this.getEntities(seedDirectoryPath), destinationPath, seedDirectoryPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildAll(String seedDirectoryPath) {
        this.validateFileStructure();
        EntityExtractionResourceBuilder.createLogging(EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + "log.txt");
        this.buildAll(seedDirectoryPath, EntityExtractionResourceBuilder.getDefaultRootPath());
        try {
            logOut.flush();
            logOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildAll(String seedDirectoryPath, String destinationPath) {
        this.print("Building All...");
        HashMap<String, YagoNamedEntity> entities = this.getEntities(seedDirectoryPath);
        this.writeAliasFile(entities, destinationPath + File.separator + DEFAULT_ALIAS_NAME, seedDirectoryPath);
        try {
            this.buildIndex(entities, destinationPath + File.separator + DEFAULT_CONTEXT_NAME, seedDirectoryPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.print("Done");
    }

    public static String getDefaultRootPath() {
        return System.getProperty("user.home") + File.separator + DEFAULT_ROOT_NAME;
    }

    public static String getDefaultAliasFilePath() {
        return EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + DEFAULT_ALIAS_NAME;
    }

    public static String getDefaultIndexDirectoryPath() {
        return EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + DEFAULT_CONTEXT_NAME;
    }

    public static String getAliasFrom(String rootName) {
        String noGeo = null;
        noGeo = rootName.startsWith("geoent_") ? rootName.substring(rootName.indexOf(95) + 1, rootName.lastIndexOf(95)) : rootName;
        String spaces = noGeo.replaceAll("_", " ");
        String noParen = spaces.contains("(") ? spaces.substring(0, spaces.indexOf("(")) : spaces;
        String dropComma = noParen.contains(",") ? noParen.substring(0, spaces.indexOf(",")) : noParen;
        String result = dropComma;
        return result;
    }

    private void validateFileStructure() {
        File indexDir;
        File rootDir = new File(EntityExtractionResourceBuilder.getDefaultRootPath());
        if (!rootDir.isDirectory()) {
            rootDir.mkdir();
        }
        if (!(indexDir = new File(EntityExtractionResourceBuilder.getDefaultRootPath() + File.separator + DEFAULT_CONTEXT_NAME)).isDirectory()) {
            indexDir.mkdir();
        } else {
            for (File f : indexDir.listFiles()) {
                f.delete();
            }
        }
    }

    private static void createLogging(String logFilePath) {
        File f = new File(logFilePath);
        if (!f.isFile()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileWriter fstream = null;
        try {
            fstream = new FileWriter(logFilePath);
            logOut = new BufferedWriter(fstream);
            logOut.write("");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void buildIndex(HashMap<String, YagoNamedEntity> entities, String destinationPath, String seedDirectoryPath) throws IOException {
        this.print("Building Index...");
        this.setEntityContextValues(entities, seedDirectoryPath);
        this.print("Initializing Lucene objects...");
        String[] names = new String[]{"uri", "context", "type"};
        FieldType ti = new FieldType();
        ti.setIndexed(true);
        ti.setTokenized(true);
        ti.setStored(true);
        FieldType n = new FieldType();
        n.setStored(true);
        n.setIndexed(true);
        FieldType[] types = new FieldType[]{n, ti, n};
        File f = new File(destinationPath);
        QuickIndexer qi = new QuickIndexer((Directory)new SimpleFSDirectory(f));
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        Document doc = null;
        WikiModel wikiModel = new WikiModel("http://www.mywiki.com/wiki/${image}", "http://www.mywiki.com/wiki/${title}");
        int count = 0;
        this.print("Building Lucene Index...");
        for (YagoNamedEntity entity : entities.values()) {
            if (++count % 5000 == 0) {
                this.print("Processed " + count);
            }
            if (entity.wikiURL != null) {
                String title = entity.wikiURL.substring(entity.wikiURL.lastIndexOf("/") + 1);
                try {
                    doc = docBuilder.parse(wikiApiPrefix + title + wikiApiSuffix);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                doc.getDocumentElement().normalize();
                NodeList revisions = doc.getElementsByTagName("rev");
                if (revisions.getLength() > 0) {
                    String markup = revisions.item(0).getTextContent();
                    String plainStr = wikiModel.render((ITextConverter)new PlainTextConverter(), markup);
                    entity.addContext(plainStr);
                }
            }
            String[] values = new String[]{entity.rootName, entity.getContext(), entity.type.toString()};
            qi.addDocumentFromFields(names, values, types);
        }
        qi.finalise();
    }

    private void setEntityContextValues(final HashMap<String, YagoNamedEntity> entities, String seedDirectoryPath) {
        this.print("Setting Context Values...");
        BufferedReader in = null;
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "created_stripped.tsv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        StreamLooper sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = values[1];
                String context = EntityExtractionResourceBuilder.convertResource(values[2]);
                if (entities.keySet().contains(rootName)) {
                    ((YagoNamedEntity)entities.get(rootName)).addContext(context);
                }
            }
        };
        sl.loop();
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "hasWikipediaAnchorText_stripped.tsv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = values[1];
                String context = EntityExtractionResourceBuilder.convertLiteral(values[2]);
                if (entities.keySet().contains(rootName)) {
                    ((YagoNamedEntity)entities.get(rootName)).addContext(context);
                }
            }
        };
        sl.loop();
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "hasWikipediaUrl_stripped.tsv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = values[1];
                if (entities.keySet().contains(rootName)) {
                    ((YagoNamedEntity)entities.get((Object)rootName)).wikiURL = values[2].replaceAll("\"", "");
                }
            }
        };
        sl.loop();
        this.print("Validating Context...");
        int noContext = 0;
        for (YagoNamedEntity ne : entities.values()) {
            for (String alias : ne.aliasList) {
                ne.addContext(alias);
            }
            if (ne.getContext() != null && !ne.getContext().equals("") || ne.wikiURL != null) continue;
            ++noContext;
        }
        this.print("No Context: " + noContext);
    }

    private void setEntityAliasValues(final HashMap<String, YagoNamedEntity> entities, String seedDirectoryPath) {
        this.print("Setting Alias Values...");
        BufferedReader in = null;
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "isCalled_stripped.tsv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        StreamLooper sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = values[1];
                String alias = EntityExtractionResourceBuilder.convertLiteral(values[2]);
                if (entities.keySet().contains(rootName)) {
                    ((YagoNamedEntity)entities.get(rootName)).addAlias(alias);
                }
            }
        };
        sl.loop();
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "means_stripped.tsv");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = values[2];
                String alias = EntityExtractionResourceBuilder.convertLiteral(values[1]);
                if (entities.keySet().contains(rootName)) {
                    ((YagoNamedEntity)entities.get(rootName)).addAlias(alias);
                }
            }
        };
        sl.loop();
        this.print("Validating Aliases...");
        for (YagoNamedEntity ne : entities.values()) {
            String alias = EntityExtractionResourceBuilder.getAliasFrom(ne.rootName);
            ne.addAlias(alias);
        }
    }

    private void writeAliasFile(HashMap<String, YagoNamedEntity> entities, String destinationPath, String seedDirectoryPath) {
        this.setEntityAliasValues(entities, seedDirectoryPath);
        try {
            BufferedWriter w = EntityExtractionResourceBuilder.openFileAsWriteStream(destinationPath);
            w.write("");
            for (YagoNamedEntity ne : entities.values()) {
                if (ne.aliasList.size() <= 0) continue;
                w.append("+" + ne.rootName + "\n");
                for (String alias : ne.aliasList) {
                    w.append("." + alias + "\n");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashMap<String, YagoNamedEntity> getEntities(String seedDirectoryPath) {
        this.print("Getting Entities...");
        final HashMap<String, YagoNamedEntity> result = new HashMap<String, YagoNamedEntity>();
        BufferedReader in = null;
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "wordnet_person_100007846.txt");
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        StreamLooper sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = EntityExtractionResourceBuilder.convertLiteral(values[1]);
                if (!rootName.startsWith("Category:")) {
                    YagoNamedEntity ne = new YagoNamedEntity(rootName, NamedEntity.Type.Person);
                    result.put(rootName, ne);
                }
            }
        };
        sl.loop();
        try {
            in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "wordnet_organization_108008335.txt");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        sl = new StreamLooper(in){

            @Override
            protected void doWork(String s) {
                String[] values = s.split("\\s+");
                String rootName = EntityExtractionResourceBuilder.convertLiteral(values[1]);
                if (!rootName.startsWith("Category:") && !rootName.startsWith("geoent_")) {
                    YagoNamedEntity ne = new YagoNamedEntity(rootName, NamedEntity.Type.Organisation);
                    result.put(rootName, ne);
                }
            }
        };
        sl.loop();
        if (this.locations) {
            try {
                in = EntityExtractionResourceBuilder.openFileAsReadStream(seedDirectoryPath + File.separator + "wordnet_location_100027167.txt");
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            sl = new StreamLooper(in){

                @Override
                protected void doWork(String s) {
                    String[] values = s.split("\\s+");
                    String rootName = EntityExtractionResourceBuilder.convertLiteral(values[1]);
                    if (!rootName.startsWith("Category:")) {
                        YagoNamedEntity ne = new YagoNamedEntity(rootName, NamedEntity.Type.Location);
                        result.put(rootName, ne);
                    }
                }
            };
            sl.loop();
        }
        this.print("Total Entities: " + result.size());
        return result;
    }

    public static BufferedReader openFileAsReadStream(String path) throws FileNotFoundException {
        FileReader fr = null;
        fr = new FileReader(path);
        BufferedReader br = new BufferedReader(fr);
        return br;
    }

    public static BufferedWriter openFileAsWriteStream(String path) throws IOException {
        FileWriter fw = null;
        fw = new FileWriter(path);
        BufferedWriter bw = new BufferedWriter(fw);
        return bw;
    }

    private static String convertLiteral(String literal) {
        String escaped = StringEscapeUtils.unescapeJava((String)literal);
        String first = null;
        first = escaped.startsWith("\"") ? escaped.substring(1) : escaped;
        if (first.endsWith("\"")) {
            return first.substring(0, first.length() - 1);
        }
        return first;
    }

    private static String convertResource(String literal) {
        String escaped = StringEscapeUtils.unescapeJava((String)literal);
        return escaped.replaceAll("_", " ");
    }

    private void print(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
        if (logOut != null) {
            this.log(message);
        }
    }

    private void log(String message) {
        try {
            logOut.append(message + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new EntityExtractionResourceBuilder().buildCandidateAliasFile(args[0]);
    }

    public static abstract class StreamLooper {
        BufferedReader reader;

        public StreamLooper(BufferedReader reader) {
            this.reader = reader;
        }

        public void loop() {
            String s = null;
            try {
                while ((s = this.reader.readLine()) != null) {
                    this.doWork(s);
                }
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected abstract void doWork(String var1);
    }
}

