/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import org.cqframework.cql.elm.execution.Union;
import org.opencds.cqf.cql.engine.elm.execution.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MeetsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OrEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class UnionEvaluator
extends Union {
    public static Object union(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Boolean overlapsOrMeets;
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart == null || leftEnd == null || rightStart == null || rightEnd == null) {
                return null;
            }
            String precision = null;
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
            }
            if ((overlapsOrMeets = OrEvaluator.or(OverlapsEvaluator.overlaps(left, right, precision), MeetsEvaluator.meets(left, right, precision))) == null || !overlapsOrMeets.booleanValue()) {
                return null;
            }
            Object min = LessEvaluator.less(leftStart, rightStart) != false ? leftStart : rightStart;
            Object max = GreaterEvaluator.greater(leftEnd, rightEnd) != false ? leftEnd : rightEnd;
            return new Interval(min, true, max, true);
        }
        if (left instanceof Iterable) {
            ArrayList result = new ArrayList();
            for (Object leftElement : (Iterable)left) {
                result.add(leftElement);
            }
            for (Object rightElement : (Iterable)right) {
                result.add(rightElement);
            }
            return DistinctEvaluator.distinct(result);
        }
        throw new InvalidOperatorArgument("Union(Interval<T>, Interval<T>) or Union(List<T>, List<T>)", String.format("Union(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return UnionEvaluator.union(left, right);
    }
}

