/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.ToQuantity;
import org.opencds.cqf.cql.engine.elm.execution.DivideEvaluator;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Ratio;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToQuantityEvaluator
extends ToQuantity {
    public static Quantity toQuantity(String str) {
        StringBuilder number = new StringBuilder();
        StringBuilder unit = new StringBuilder();
        for (char c : str.toCharArray()) {
            if ((Character.isDigit(c) || c == '.' || c == '+' || c == '-') && unit.length() == 0) {
                number.append(c);
                continue;
            }
            if (Character.isLetter(c) || c == '/') {
                unit.append(c);
                continue;
            }
            if (c == ' ' || c == '\'') continue;
            throw new IllegalArgumentException(String.format("%c is not allowed in ToQuantity format", Character.valueOf(c)));
        }
        try {
            BigDecimal ret = new BigDecimal(number.toString());
            if (Value.validateDecimal(ret, null) == null) {
                return null;
            }
            return new Quantity().withValue(ret).withUnit(unit.toString());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Quantity toQuantity(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof String) {
            String str = (String)operand;
            return ToQuantityEvaluator.toQuantity(str);
        }
        if (operand instanceof Integer) {
            BigDecimal ret = new BigDecimal((Integer)operand);
            if (Value.validateDecimal(ret, null) == null) {
                return null;
            }
            return new Quantity().withValue(ret).withDefaultUnit();
        }
        if (operand instanceof BigDecimal) {
            if (Value.validateDecimal((BigDecimal)operand, null) == null) {
                return null;
            }
            return new Quantity().withValue((BigDecimal)operand).withDefaultUnit();
        }
        if (operand instanceof Ratio) {
            return (Quantity)DivideEvaluator.divide(((Ratio)operand).getNumerator(), ((Ratio)operand).getDenominator());
        }
        throw new IllegalArgumentException(String.format("Cannot cast a value of type %s as Quantity - use String, Integer, Decimal, or Ratio values.", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToQuantityEvaluator.toQuantity(operand);
    }
}

