/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import org.cqframework.cql.elm.execution.Intersect;
import org.opencds.cqf.cql.engine.elm.execution.DistinctEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class IntersectEvaluator
extends Intersect {
    public static Object intersect(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval) {
            Object max;
            Boolean overlaps;
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            Object leftStart = leftInterval.getStart();
            Object leftEnd = leftInterval.getEnd();
            Object rightStart = rightInterval.getStart();
            Object rightEnd = rightInterval.getEnd();
            if (leftStart == null || leftEnd == null || rightStart == null || rightEnd == null) {
                return null;
            }
            String precision = null;
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)leftEnd, (BaseTemporal)rightStart, (BaseTemporal)rightEnd);
            }
            if ((overlaps = OverlapsEvaluator.overlaps(leftInterval, rightInterval, precision)) == null || !overlaps.booleanValue()) {
                return null;
            }
            Boolean leftStartGtRightStart = GreaterEvaluator.greater(leftStart, rightStart);
            Boolean leftEndLtRightEnd = LessEvaluator.less(leftEnd, rightEnd);
            if (leftStartGtRightStart == null && precision != null) {
                max = ((BaseTemporal)leftStart).getPrecision().toString().equals(precision) ? leftStart : rightStart;
            } else {
                Object object = leftStartGtRightStart == null ? null : (max = leftStartGtRightStart != false ? leftStart : rightStart);
            }
            Object min = leftEndLtRightEnd == null && precision != null ? (((BaseTemporal)leftEnd).getPrecision().toString().equals(precision) ? leftEnd : rightEnd) : (leftEndLtRightEnd == null ? null : (leftEndLtRightEnd != false ? leftEnd : rightEnd));
            return new Interval(max, max != null, min, min != null);
        }
        if (left instanceof Iterable) {
            Iterable leftArr = (Iterable)left;
            Iterable rightArr = (Iterable)right;
            ArrayList result = new ArrayList();
            for (Object leftItem : leftArr) {
                Boolean in = InEvaluator.in(leftItem, rightArr, null);
                if (in == null || !in.booleanValue()) continue;
                result.add(leftItem);
            }
            return DistinctEvaluator.distinct(result);
        }
        throw new InvalidOperatorArgument("Intersect(Interval<T>, Interval<T>) or Intersect(List<T>, List<T>)", String.format("Intersect(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return IntersectEvaluator.intersect(left, right);
    }
}

