/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.Iterator;
import org.cqframework.cql.elm.execution.Combine;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class CombineEvaluator
extends Combine {
    public static Object combine(Object source, String separator) {
        if (source == null || separator == null) {
            return null;
        }
        if (source instanceof Iterable) {
            StringBuffer buffer = new StringBuffer("");
            Iterator iterator = ((Iterable)source).iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (item == null) {
                    return null;
                }
                if (item instanceof String) {
                    if (!first) {
                        buffer.append(separator);
                    } else {
                        first = false;
                    }
                    buffer.append((String)item);
                    continue;
                }
                throw new InvalidOperatorArgument("Combine(List<String>) or Combine(List<String>, String)", String.format("Combine(List<%s>%s)", item.getClass().getName(), separator.equals("") ? "" : ", " + separator));
            }
            return buffer.toString();
        }
        throw new InvalidOperatorArgument("Combine(List<String>) or Combine(List<String>, String)", String.format("Combine(%s%s)", source.getClass().getName(), separator.equals("") ? "" : ", " + separator));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        String separator = this.getSeparator() == null ? "" : (String)this.getSeparator().evaluate(context);
        return CombineEvaluator.combine(source, separator);
    }
}

