/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.CalculateAgeAt;
import org.opencds.cqf.cql.engine.elm.execution.DurationBetweenEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class CalculateAgeAtEvaluator
extends CalculateAgeAt {
    public static Object calculateAgeAt(Object birthDate, Object asOf, String precision) {
        if (birthDate == null || asOf == null) {
            return null;
        }
        if (birthDate instanceof Date && asOf instanceof Date || birthDate instanceof DateTime && asOf instanceof DateTime) {
            return DurationBetweenEvaluator.duration(birthDate, asOf, Precision.fromString(precision));
        }
        throw new InvalidOperatorArgument("CalculateAgeInYearsAt(Date, Date), CalculateAgeInYearsAt(DateTime, DateTime), CalculateAgeInMonthsAt(Date, Date), CalculateAgeInMonthsAt(DateTime, DateTime), CalculateAgeInWeeksAt(Date, Date), CalculateAgeInWeeksAt(DateTime, DateTime), CalculateAgeInDaysAt(Date, Date), CalculateAgeInDaysAt(DateTime, DateTime), CalculateAgeInHoursAt(Date, Date), CalculateAgeInHoursAt(DateTime, DateTime), CalculateAgeInMinutesAt(Date, Date), CalculateAgeInMinutesAt(DateTime, DateTime), CalculateAgeInSecondsAt(Date, Date), CalculateAgeInSecondsAt(DateTime, DateTime)", String.format("CalculateAgeIn%ssAt(%s, %s)", precision, birthDate.getClass().getName(), asOf.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object birthDate = this.getOperand().get(0).evaluate(context);
        Object asOf = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision().value();
        return CalculateAgeAtEvaluator.calculateAgeAt(birthDate, asOf, precision);
    }
}

