/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="VersionService", title="Version service", abstractText="Provides latest opencast version", notes={"This service offers the GET method to retrieve the latest opencast version from https://api.github.com ."})
@Component(immediate=true, service={VersionEndpoint.class}, property={"service.description=Admin UI - Latest Version Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.VersionEndpoint", "opencast.service.path=/admin-ng/oc-version"})
public class VersionEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(VersionEndpoint.class);
    private String version = "";
    private static final String URL = "https://api.github.com/repos/opencast/opencast/releases";
    private long lastUpdated = 0L;
    private static final Gson gson = new Gson();
    private static final Type mapArrayType = new TypeToken<Map<String, Object>[]>(){}.getType();

    @Activate
    protected void activate() {
        logger.info("Activate the Admin ui - Latest version endpoint");
    }

    @GET
    @Path(value="version.json")
    @Produces(value={"application/json"})
    @RestQuery(name="latestversion", description="Returns the latest Opencast version", returnDescription="Returns the latest Opencast version retrieved from GitHub", responses={@RestResponse(responseCode=200, description="The latest Opencast version.")})
    public String getVersion() {
        if (System.currentTimeMillis() / 1000L - this.lastUpdated >= 3600L) {
            this.updateVersion();
        }
        return gson.toJson((Object)this.version);
    }

    private synchronized void updateVersion() {
        String responseString;
        if (System.currentTimeMillis() / 1000L - this.lastUpdated < 3600L) {
            return;
        }
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        HttpGet request = new HttpGet(URL);
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            responseString = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8");
        }
        catch (IOException e) {
            logger.debug("Could not get version from GitHub", (Throwable)e);
            return;
        }
        try {
            Map[] data = (Map[])gson.fromJson(responseString, mapArrayType);
            double latestVersion = 0.0;
            for (Map release : data) {
                if (!(Double.parseDouble((String)release.get("tag_name")) > latestVersion)) continue;
                latestVersion = Double.parseDouble((String)release.get("tag_name"));
                this.version = (String)release.get("tag_name");
            }
            this.lastUpdated = System.currentTimeMillis() / 1000L;
        }
        catch (Exception e) {
            logger.warn("Error while parsing the Opencast version from GitHub", (Throwable)e);
        }
    }
}

