/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.adminui.endpoint;

import java.io.IOException;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opencastproject.adminui.endpoint.ServerEndpoint;
import org.opencastproject.adminui.usersettings.UserSetting;
import org.opencastproject.adminui.usersettings.UserSettings;
import org.opencastproject.adminui.usersettings.UserSettingsService;
import org.opencastproject.adminui.usersettings.persistence.UserSettingsServiceException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="usersettings", title="User Settings service", abstractText="Provides operations for user settings", notes={"This service offers the default CRUD Operations for user settings for the admin UI.", "<strong>Important:</strong> <em>This service is for exclusive use by the module admin-ui. Its API might change anytime without prior notice. Any dependencies other than the admin UI will be strictly ignored. DO NOT use this for integration of third-party applications.<em>"})
@Component(immediate=true, service={UserSettingsEndpoint.class}, property={"service.description=Admin UI - Users Settings facade Endpoint", "opencast.service.type=org.opencastproject.adminui.endpoint.UserSettingsEndpoint", "opencast.service.path=/admin-ng/user-settings"})
public class UserSettingsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ServerEndpoint.class);
    private String endpointBaseUrl;
    private UserSettingsService userSettingsService;

    @Reference
    public void setUserSettingsService(UserSettingsService userSettingsService) {
        this.userSettingsService = userSettingsService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        logger.info("Activate the Admin ui - Users facade endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc);
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
    }

    @GET
    @Path(value="/settings.json")
    @Produces(value={"application/json"})
    @RestQuery(name="getUserSettings", description="Returns a list of the user settings for the current user", returnDescription="Returns a JSON representation of the list of user settings", restParameters={@RestParameter(defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, name="limit", type=RestParameter.Type.STRING), @RestParameter(defaultValue="0", description="The page number.", isRequired=false, name="offset", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user settings.")})
    public Response getUserSettings(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws IOException {
        UserSettings userSettings;
        if (limit < 1) {
            limit = 100;
        }
        try {
            userSettings = this.userSettingsService.findUserSettings(limit, offset);
        }
        catch (UserSettingsServiceException e) {
            logger.error("Unable to get user settings:", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok((Object)userSettings.toJson().toJson()).build();
    }

    @POST
    @Path(value="/setting")
    @Produces(value={"application/json"})
    @RestQuery(name="createUserSetting", description="Create a new user setting", returnDescription="Status ok", restParameters={@RestParameter(description="The key used to represent this setting.", isRequired=true, name="key", type=RestParameter.Type.STRING), @RestParameter(description="The value representing this setting.", isRequired=true, name="value", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="User setting has been created.")})
    public Response createUserSetting(@FormParam(value="key") String key, @FormParam(value="value") String value) throws NotFoundException {
        try {
            UserSetting newUserSetting = this.userSettingsService.addUserSetting(key, value);
            return Response.ok((Object)newUserSetting.toJson().toJson(), (String)"application/json").build();
        }
        catch (UserSettingsServiceException e) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="/setting/{settingId}")
    @Produces(value={"application/json"})
    @RestQuery(name="updateUserSetting", description="Update a user setting", returnDescription="The updated user setting as JSON", pathParameters={@RestParameter(name="settingId", description="The setting's id", isRequired=true, type=RestParameter.Type.INTEGER)}, restParameters={@RestParameter(description="The key used to represent this setting.", isRequired=true, name="key", type=RestParameter.Type.STRING), @RestParameter(description="The value representing this setting.", isRequired=true, name="value", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="User setting has been created.")})
    public Response updateUserSetting(@PathParam(value="settingId") int id, @FormParam(value="key") String key, @FormParam(value="value") String value) throws NotFoundException {
        try {
            UserSetting updatedUserSetting = this.userSettingsService.updateUserSetting(id, key, value);
            return Response.ok((Object)updatedUserSetting.toJson().toJson(), (String)"application/json").build();
        }
        catch (UserSettingsServiceException e) {
            logger.error("Unable to update user setting", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/setting/{settingId}")
    @RestQuery(name="deleteUserSetting", description="Delete a user setting", returnDescription="Status ok", pathParameters={@RestParameter(name="settingId", type=RestParameter.Type.INTEGER, isRequired=true, description="The id of the user setting.")}, responses={@RestResponse(responseCode=200, description="User setting has been deleted."), @RestResponse(responseCode=404, description="User setting not found.")})
    public Response deleteUserSetting(@PathParam(value="settingId") long id) throws NotFoundException {
        try {
            this.userSettingsService.deleteUserSetting(id);
        }
        catch (UserSettingsServiceException e) {
            logger.error("Unable to remove user setting id:'%s':", (Object)id, (Object)e);
            return Response.serverError().build();
        }
        logger.debug("User setting with id %d removed.", (Object)id);
        return Response.status((int)200).build();
    }
}

