/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.file.FileSynchronizer;
import org.openbase.jul.storage.registry.FileSynchronizedRegistryImpl;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.jp.JPGitRegistryPluginRemoteURL;
import org.openbase.jul.storage.registry.jp.JPInitializeDB;
import org.openbase.jul.storage.registry.plugin.FileRegistryPluginAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitRegistryPlugin<KEY, ENTRY extends Identifiable<KEY>>
extends FileRegistryPluginAdapter<KEY, ENTRY> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FileSynchronizedRegistryImpl registry;
    private final Git git;
    private boolean detached;

    public GitRegistryPlugin(FileSynchronizedRegistryImpl registry) throws InstantiationException {
        try {
            this.detached = false;
            this.registry = registry;
            this.git = this.detectGitRepository(registry.getDatabaseDirectory());
            this.initialSync();
        }
        catch (Exception ex) {
            this.shutdown();
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    @Override
    public void init(Registry<KEY, ENTRY> config) throws InitializationException, InterruptedException {
    }

    private void initialSync() throws CouldNotPerformException {
        try {
            try {
                this.git.pull().call().isSuccessful();
            }
            catch (DetachedHeadException ex) {
                this.detached = true;
            }
            try {
                this.git.submoduleInit();
                this.git.submoduleUpdate();
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init db submodules!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            }
        }
        catch (GitAPIException ex) {
            throw new CouldNotPerformException("Initial sync failed!", (Throwable)ex);
        }
    }

    private Git detectGitRepository(File databaseDirectory) throws CouldNotPerformException {
        try {
            Repository repo;
            try {
                FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(databaseDirectory);
                if (repositoryBuilder.getGitDir() == null) {
                    throw new NotAvailableException("git repository");
                }
                repo = repositoryBuilder.build();
            }
            catch (IOException | NullPointerException | CouldNotPerformException ex) {
                this.logger.info("Could not find git repository in db Directory[" + databaseDirectory + "] for Registry[" + this.registry + "]!");
                Map remoteRepositoryMap = (Map)((JPGitRegistryPluginRemoteURL)JPService.getProperty(JPGitRegistryPluginRemoteURL.class)).getValue();
                if (remoteRepositoryMap.containsKey(this.registry.getName()) && !((String)remoteRepositoryMap.get(this.registry.getName())).isEmpty()) {
                    this.logger.info("Cloning git repository from " + (String)remoteRepositoryMap.get(this.registry.getName()) + " into db Directory[" + databaseDirectory + "] ...");
                    return Git.cloneRepository().setURI((String)remoteRepositoryMap.get(this.registry.getName())).setDirectory(databaseDirectory).call();
                }
                if (!((Boolean)((JPInitializeDB)JPService.getProperty(JPInitializeDB.class)).getValue()).booleanValue()) {
                    throw ex;
                }
                repo = FileRepositoryBuilder.create((File)databaseDirectory);
            }
            return new Git(repo);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not detect git repo of Directory[" + databaseDirectory.getAbsolutePath() + "]!", (Throwable)ex);
        }
    }

    @Override
    public void afterRegister(Identifiable entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.commitAllChanges();
    }

    @Override
    public void afterUpdate(Identifiable entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.commitAllChanges();
    }

    @Override
    public void afterRemove(Identifiable entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.commitAllChanges();
    }

    private void commitAllChanges() throws CouldNotPerformException {
        try {
            if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                this.logger.warn("Skip commit because test mode is enabled!");
                return;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        if (this.detached) {
            this.logger.info("Skip commit because branch detached!");
            return;
        }
        try {
            this.git.add().addFilepattern(".").call();
            this.git.commit().setMessage(JPService.getApplicationName() + " commited all changes.").call();
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not commit all database changes!", (Throwable)ex);
        }
    }

    @Override
    public void checkAccess() throws RejectedException {
        try {
            if (GitRegistryPlugin.isTag(GitRegistryPlugin.getHead(this.git.getRepository()))) {
                throw new RejectedException("Database based on tag revision and can not be modifiered!");
            }
            if (this.detached) {
                throw new RejectedException("Database based on detached branch and can not be modifiered!");
            }
        }
        catch (IOException ex) {
            throw new RejectedException("Could not access database!", (Throwable)ex);
        }
    }

    private static Ref getHead(Repository repository) throws IOException {
        return repository.getRef("HEAD");
    }

    private static boolean isTag(Ref ref) {
        return !ref.getTarget().getName().contains("refs/heads");
    }

    @Override
    public final void shutdown() {
        if (this.git == null) {
            return;
        }
        try {
            this.git.getRepository().close();
            this.git.close();
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not shutdown", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
        }
    }
}

