/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry.plugin;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.file.FileSynchronizer;
import org.openbase.jul.storage.registry.plugin.FileRegistryPlugin;
import org.openbase.jul.storage.registry.plugin.RegistryPluginPool;
import org.slf4j.Logger;

public class FileRegistryPluginPool<KEY, ENTRY extends Identifiable<KEY>, P extends FileRegistryPlugin<KEY, ENTRY>>
extends RegistryPluginPool<KEY, ENTRY, P>
implements FileRegistryPlugin<KEY, ENTRY> {
    @Override
    public void beforeRegister(ENTRY entry, FileSynchronizer fileSynchronizer) throws RejectedException {
        for (FileRegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeRegister(entry, fileSynchronizer);
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] registration!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        }
    }

    @Override
    public void afterRegister(ENTRY entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.pluginList.stream().forEach(plugin -> {
            try {
                plugin.afterRegister(entry, fileSynchronizer);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about successfully Entry[" + entry + "] registration!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        });
    }

    @Override
    public void beforeRemove(ENTRY entry, FileSynchronizer fileSynchronizer) throws RejectedException {
        for (FileRegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeRemove(entry, fileSynchronizer);
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] removal!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        }
    }

    @Override
    public void afterRemove(ENTRY entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.pluginList.stream().forEach(plugin -> {
            try {
                plugin.afterRemove(entry, fileSynchronizer);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about successfully Entry[" + entry + "] removal!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        });
    }

    @Override
    public void beforeUpdate(ENTRY entry, FileSynchronizer fileSynchronizer) throws RejectedException {
        for (FileRegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeUpdate(entry, fileSynchronizer);
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + entry + "] update!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        }
    }

    @Override
    public void afterUpdate(ENTRY entry, FileSynchronizer fileSynchronizer) throws CouldNotPerformException {
        this.pluginList.stream().forEach(plugin -> {
            try {
                plugin.afterUpdate(entry, fileSynchronizer);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about successfully Entry[" + entry + "] update!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        });
    }

    @Override
    public void beforeGet(KEY key, FileSynchronizer fileSynchronizer) throws RejectedException {
        for (FileRegistryPlugin plugin : this.pluginList) {
            try {
                plugin.beforeGet(key, fileSynchronizer);
            }
            catch (RejectedException ex) {
                throw ex;
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not inform RegistryPlugin[" + plugin + "] about planned Entry[" + key + "] publishment!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            }
        }
    }
}

