/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import com.google.protobuf.GeneratedMessage;
import java.util.Map;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.VerificationFailedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.IdentifiableMessage;
import org.openbase.jul.extension.protobuf.IdentifiableMessageMap;
import org.openbase.jul.extension.protobuf.ProtobufListDiff;
import org.openbase.jul.iface.Configurable;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.RecurrenceEventFilter;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistrySynchronizer<KEY, ENTRY extends Configurable<KEY, CONFIG_M>, CONFIG_M extends GeneratedMessage, CONFIG_MB extends GeneratedMessage.Builder<CONFIG_MB>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Registry<KEY, ENTRY> localRegistry;
    private final Observer<Map<KEY, IdentifiableMessage<KEY, CONFIG_M, CONFIG_MB>>> remoteChangeObserver;
    private final RecurrenceEventFilter recurrenceSyncFilter;
    private final ProtobufListDiff<KEY, CONFIG_M, CONFIG_MB> entryConfigDiff;
    private final Factory<ENTRY, CONFIG_M> factory;
    protected final RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry;

    public RegistrySynchronizer(Registry<KEY, ENTRY> registry, RemoteRegistry<KEY, CONFIG_M, CONFIG_MB> remoteRegistry, Factory<ENTRY, CONFIG_M> factory) throws InstantiationException {
        try {
            this.localRegistry = registry;
            this.remoteRegistry = remoteRegistry;
            this.entryConfigDiff = new ProtobufListDiff();
            this.factory = factory;
            this.recurrenceSyncFilter = new RecurrenceEventFilter(15000L){

                public void relay() throws Exception {
                    RegistrySynchronizer.this.internalSync();
                }
            };
            this.remoteChangeObserver = (source, data) -> this.sync();
        }
        catch (Exception ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws CouldNotPerformException, InterruptedException {
        this.remoteRegistry.addObserver(this.remoteChangeObserver);
        try {
            this.internalSync();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial sync failed!", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.ERROR);
            try {
                if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                    throw ex;
                }
            }
            catch (JPServiceException exx) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)exx), (Logger)this.logger);
            }
        }
    }

    public void shutdown() {
        this.remoteRegistry.removeObserver(this.remoteChangeObserver);
        this.recurrenceSyncFilter.cancel();
    }

    private void sync() {
        this.recurrenceSyncFilter.trigger();
    }

    private synchronized void internalSync() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Perform registry sync...");
        try {
            this.entryConfigDiff.diff(this.remoteRegistry.getMessages());
            MultiException.ExceptionStack removeExceptionStack = null;
            for (Object config : this.entryConfigDiff.getRemovedMessageMap().getMessages()) {
                try {
                    this.remove(config);
                }
                catch (CouldNotPerformException ex) {
                    removeExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), removeExceptionStack);
                }
            }
            MultiException.ExceptionStack updateExceptionStack = null;
            for (Object config : this.entryConfigDiff.getUpdatedMessageMap().getMessages()) {
                try {
                    if (this.verifyConfig(config)) {
                        this.update(config);
                        continue;
                    }
                    this.remove(config);
                    this.entryConfigDiff.getOriginMessages().removeMessage((GeneratedMessage)config);
                }
                catch (CouldNotPerformException ex) {
                    updateExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), updateExceptionStack);
                }
            }
            MultiException.ExceptionStack registerExceptionStack = null;
            for (GeneratedMessage config : this.entryConfigDiff.getNewMessageMap().getMessages()) {
                try {
                    if (!this.verifyConfig(config)) continue;
                    this.register(config);
                }
                catch (CouldNotPerformException ex) {
                    registerExceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), registerExceptionStack);
                }
            }
            int errorCounter = MultiException.size((MultiException.ExceptionStack)removeExceptionStack) + MultiException.size((MultiException.ExceptionStack)updateExceptionStack) + MultiException.size(registerExceptionStack);
            this.logger.info(this.entryConfigDiff.getChangeCounter() + " registry changes applied. " + errorCounter + " are skipped.");
            IdentifiableMessageMap newOriginEntryMap = new IdentifiableMessageMap();
            for (Configurable entry : this.localRegistry.getEntries()) {
                newOriginEntryMap.put(this.remoteRegistry.get(entry.getId()));
            }
            this.entryConfigDiff.replaceOriginMap(newOriginEntryMap);
            MultiException.ExceptionStack exceptionStack = null;
            try {
                int counter = removeExceptionStack != null ? removeExceptionStack.size() : 0;
                MultiException.checkAndThrow((String)("Could not remove " + counter + " entries!"), (MultiException.ExceptionStack)removeExceptionStack);
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
            }
            try {
                int counter = updateExceptionStack != null ? updateExceptionStack.size() : 0;
                MultiException.checkAndThrow((String)("Could not update " + counter + " entries!"), (MultiException.ExceptionStack)updateExceptionStack);
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
            }
            try {
                int counter = registerExceptionStack != null ? registerExceptionStack.size() : 0;
                MultiException.checkAndThrow((String)("Could not register " + counter + " entries!"), (MultiException.ExceptionStack)registerExceptionStack);
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
            }
            MultiException.checkAndThrow((String)"Could not sync all entries!", (MultiException.ExceptionStack)exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Entry registry sync failed!", (Throwable)ex);
        }
    }

    public ENTRY register(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        return (ENTRY)((Configurable)this.localRegistry.register((Identifiable)this.factory.newInstance(config)));
    }

    public ENTRY update(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        Configurable entry = (Configurable)this.localRegistry.get(this.remoteRegistry.getId(config));
        entry.applyConfigUpdate(config);
        return (ENTRY)entry;
    }

    public ENTRY remove(CONFIG_M config) throws CouldNotPerformException, InterruptedException {
        return (ENTRY)((Configurable)this.localRegistry.remove(this.getId(config)));
    }

    public KEY getId(CONFIG_M entry) throws CouldNotPerformException {
        Object key = entry.getField(entry.getDescriptorForType().findFieldByName("id"));
        if (!this.localRegistry.contains(key)) {
            throw new CouldNotPerformException("Entry for given Key[" + key + "] is not available for local registry!");
        }
        return (KEY)key;
    }

    public boolean verifyConfig(CONFIG_M config) throws VerificationFailedException {
        return true;
    }
}

