/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.util.Map;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.storage.registry.AbstractRegistry;
import org.openbase.jul.storage.registry.Registry;
import org.openbase.jul.storage.registry.RegistrySandbox;
import org.openbase.jul.storage.registry.clone.RITSCloner;
import org.openbase.jul.storage.registry.clone.RegistryCloner;
import org.openbase.jul.storage.registry.plugin.RegistryPlugin;

public class RegistrySandboxImpl<KEY, ENTRY extends Identifiable<KEY>, MAP extends Map<KEY, ENTRY>, R extends Registry<KEY, ENTRY>, P extends RegistryPlugin<KEY, ENTRY>>
extends AbstractRegistry<KEY, ENTRY, MAP, R, P>
implements RegistrySandbox<KEY, ENTRY, MAP, R> {
    private RegistryCloner<KEY, ENTRY, MAP> cloner;
    private Registry<KEY, ENTRY> originRegistry;

    public RegistrySandboxImpl(MAP entryMap, Registry<KEY, ENTRY> originRegistry) throws CouldNotPerformException, InterruptedException {
        this(entryMap, new RITSCloner(), originRegistry);
    }

    public RegistrySandboxImpl(MAP entryMap, RegistryCloner<KEY, ENTRY, MAP> cloner, Registry<KEY, ENTRY> originRegistry) throws CouldNotPerformException, InterruptedException {
        super(cloner.deepCloneRegistryMap(entryMap));
        this.cloner = cloner;
        this.originRegistry = originRegistry;
    }

    @Override
    public void replaceInternalMap(Map<KEY, ENTRY> map, boolean finishTransaction) throws CouldNotPerformException {
        super.replaceInternalMap(this.cloner.deepCloneMap(map), finishTransaction);
    }

    @Override
    public ENTRY superRemove(ENTRY entry) throws CouldNotPerformException {
        return super.superRemove(this.cloner.deepCloneEntry(entry));
    }

    @Override
    public ENTRY update(ENTRY entry) throws CouldNotPerformException {
        return super.update(this.cloner.deepCloneEntry(entry));
    }

    @Override
    public ENTRY register(ENTRY entry) throws CouldNotPerformException {
        return super.register(this.cloner.deepCloneEntry(entry));
    }

    @Override
    public void sync(MAP map) throws CouldNotPerformException {
        try {
            this.replaceInternalMap((Map<KEY, ENTRY>)map, false);
            this.consistent = true;
        }
        catch (Exception ex) {
            throw new FatalImplementationErrorException("FATAL: Sandbox sync failed!", (Throwable)ex);
        }
    }

    public void addObserver(Observer<Map<KEY, ENTRY>> observer) {
        this.logger.warn("Observer registration on sandbox instance skiped!");
    }

    @Override
    protected void finishTransaction() throws CouldNotPerformException {
        try {
            this.checkConsistency();
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Given transaction is invalid because " + this + " consistency check failed!", (Throwable)ex);
        }
    }

    @Override
    public boolean isSandbox() {
        return true;
    }

    @Override
    public String toString() {
        return this.originRegistry + "Sandbox";
    }
}

