/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.registry;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPForce;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.FatalImplementationErrorException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.processing.FileProcessor;
import org.openbase.jul.processing.StringProcessor;
import org.openbase.jul.storage.file.FileProvider;
import org.openbase.jul.storage.file.FileSynchronizer;
import org.openbase.jul.storage.registry.AbstractRegistry;
import org.openbase.jul.storage.registry.ConsistencyHandler;
import org.openbase.jul.storage.registry.FileSynchronizedRegistry;
import org.openbase.jul.storage.registry.jp.JPResetDB;
import org.openbase.jul.storage.registry.plugin.FileRegistryPlugin;
import org.openbase.jul.storage.registry.plugin.FileRegistryPluginPool;
import org.openbase.jul.storage.registry.version.DBVersionControl;
import org.slf4j.Logger;

public class FileSynchronizedRegistryImpl<KEY, ENTRY extends Identifiable<KEY>, MAP extends Map<KEY, ENTRY>, R extends FileSynchronizedRegistry<KEY, ENTRY>>
extends AbstractRegistry<KEY, ENTRY, MAP, R, FileRegistryPlugin<KEY, ENTRY>>
implements FileSynchronizedRegistry<KEY, ENTRY> {
    private final File databaseDirectory;
    private final Map<KEY, FileSynchronizer<ENTRY>> fileSynchronizerMap;
    private final FileProcessor<ENTRY> fileProcessor;
    private final FileProvider<Identifiable<KEY>> fileProvider;
    private final FileRegistryPluginPool<KEY, ENTRY, FileRegistryPlugin<KEY, ENTRY>> filePluginPool;
    private DBVersionControl versionControl;
    private DatabaseState databaseState;
    private final String databaseName;

    public FileSynchronizedRegistryImpl(MAP entryMap, File databaseDirectory, FileProcessor<ENTRY> fileProcessor, FileProvider<Identifiable<KEY>> fileProvider) throws InstantiationException, InterruptedException {
        this(entryMap, databaseDirectory, fileProcessor, fileProvider, new FileRegistryPluginPool());
    }

    public FileSynchronizedRegistryImpl(MAP entryMap, File databaseDirectory, FileProcessor<ENTRY> fileProcessor, FileProvider<Identifiable<KEY>> fileProvider, FileRegistryPluginPool<KEY, ENTRY, FileRegistryPlugin<KEY, ENTRY>> filePluginPool) throws InstantiationException, InterruptedException {
        super(entryMap, filePluginPool);
        try {
            this.databaseDirectory = databaseDirectory;
            this.fileSynchronizerMap = new HashMap<KEY, FileSynchronizer<ENTRY>>();
            this.fileProcessor = fileProcessor;
            this.fileProvider = fileProvider;
            this.filePluginPool = filePluginPool;
            this.databaseState = DatabaseState.UNKNOWN;
            this.databaseName = this.generateDatabaseName(databaseDirectory);
        }
        catch (NullPointerException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    private String generateDatabaseName(File databaseDirectory) {
        return StringProcessor.transformToCamelCase((String)databaseDirectory.getName().replaceAll("db", "").replaceAll("DB", ""));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void activateVersionControl(String entryType, Package converterPackage) throws CouldNotPerformException {
        if (!this.isEmpty()) {
            throw new CouldNotPerformException("Could not activate version control because registry already loaded! Please activate version control before loading the registry.");
        }
        this.versionControl = new DBVersionControl(entryType, this.fileProvider, converterPackage, this.databaseDirectory, this);
    }

    @Override
    public ENTRY register(ENTRY entry) throws CouldNotPerformException {
        ENTRY result = super.register(entry);
        FileSynchronizer<ENTRY> fileSynchronizer = new FileSynchronizer<ENTRY>(result, new File(this.databaseDirectory, this.fileProvider.getFileName((Identifiable<KEY>)entry)), FileSynchronizer.InitMode.CREATE, this.fileProcessor);
        this.fileSynchronizerMap.put(result.getId(), fileSynchronizer);
        this.filePluginPool.afterRegister(result, fileSynchronizer);
        return result;
    }

    @Override
    public ENTRY update(ENTRY entry) throws CouldNotPerformException {
        ENTRY result = super.update(entry);
        if (!this.fileSynchronizerMap.containsKey(result.getId())) {
            this.logger.debug("Ignore update during registration process of entry " + result);
            return entry;
        }
        FileSynchronizer<ENTRY> fileSynchronizer = this.fileSynchronizerMap.get(result.getId());
        this.filePluginPool.beforeUpdate(result, fileSynchronizer);
        fileSynchronizer.save(result);
        this.filePluginPool.afterUpdate(result, fileSynchronizer);
        return result;
    }

    @Override
    public ENTRY remove(ENTRY entry) throws CouldNotPerformException {
        ENTRY removedValue = super.remove(entry);
        FileSynchronizer<ENTRY> fileSynchronizer = this.fileSynchronizerMap.get(entry.getId());
        this.filePluginPool.beforeRemove(entry, fileSynchronizer);
        fileSynchronizer.delete();
        this.fileSynchronizerMap.remove(entry.getId());
        this.filePluginPool.afterRemove(entry, fileSynchronizer);
        return removedValue;
    }

    @Override
    public void clear() throws CouldNotPerformException {
        super.clear();
        this.fileSynchronizerMap.clear();
    }

    @Override
    public void loadRegistry() throws CouldNotPerformException {
        assert (this.databaseDirectory != null);
        if (this.versionControl != null) {
            try {
                this.versionControl.validateAndUpgradeDBVersion();
                this.databaseState = DatabaseState.LATEST;
            }
            catch (CouldNotPerformException ex) {
                this.databaseState = DatabaseState.OUTDATED;
                try {
                    if (!((Boolean)((JPForce)JPService.getProperty(JPForce.class)).getValue()).booleanValue()) {
                        throw new CouldNotPerformException("Registry is not up-to-date! To fix registry manually start the registry in force mode", (Throwable)ex);
                    }
                }
                catch (JPServiceException exx) {
                    ExceptionPrinter.printHistory((String)"Could not check force flag!", (Throwable)exx, (Logger)this.logger);
                }
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Registry is not up-to-date but force mode is enabled so you are able to apply manual fixes via the registry editor.", (Throwable)ex), (Logger)this.logger);
            }
        }
        try {
            if (((Boolean)((JPResetDB)JPService.getProperty(JPResetDB.class)).getValue()).booleanValue()) {
                return;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        this.logger.debug("Load " + this + " out of " + this.databaseDirectory + "...");
        MultiException.ExceptionStack exceptionStack = null;
        File[] listFiles = this.databaseDirectory.listFiles(this.fileProvider.getFileFilter());
        if (listFiles == null) {
            throw new NotAvailableException("Could not load registry because database directory[" + this.databaseDirectory.getAbsolutePath() + "] is empty!");
        }
        for (File file : listFiles) {
            try {
                FileSynchronizer<ENTRY> fileSynchronizer = new FileSynchronizer<ENTRY>(file, this.fileProcessor);
                Identifiable entry = (Identifiable)fileSynchronizer.getData();
                this.fileSynchronizerMap.put(entry.getId(), fileSynchronizer);
                super.load(entry);
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
            }
        }
        if (!this.isEmpty() || MultiException.size(exceptionStack) > 0) {
            this.logger.info("====== " + this.size() + (this.size() == 1 ? " entry" : " entries") + " of " + this + " successfully loaded." + (MultiException.size((MultiException.ExceptionStack)exceptionStack) > 0 ? MultiException.size((MultiException.ExceptionStack)exceptionStack) + " skipped." : "") + " ======");
        }
        MultiException.checkAndThrow((String)"Could not load all registry entries!", exceptionStack);
        if (this.versionControl != null) {
            List<ConsistencyHandler> versionConsistencyHandlers = this.versionControl.loadDBVersionConsistencyHandlers(this);
            for (ConsistencyHandler handler : versionConsistencyHandlers) {
                try {
                    this.registerConsistencyHandler(handler);
                }
                catch (CouldNotPerformException ex) {
                    throw new FatalImplementationErrorException("FATAL ERROR: During VersionConsistencyHandler[" + handler.getClass().getSimpleName() + "] execution!", (Throwable)ex);
                }
            }
        }
        this.notifyObservers();
    }

    @Override
    public synchronized void saveRegistry() throws MultiException {
        if (JPService.testMode()) {
            return;
        }
        this.logger.debug("Save " + this + " into " + this.databaseDirectory + "...");
        MultiException.ExceptionStack exceptionStack = null;
        for (FileSynchronizer<ENTRY> fileSynchronizer : new ArrayList<FileSynchronizer<ENTRY>>(this.fileSynchronizerMap.values())) {
            try {
                fileSynchronizer.save();
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)ex), exceptionStack);
            }
        }
        for (Map.Entry<KEY, FileSynchronizer<ENTRY>> entry : new ArrayList<Map.Entry<KEY, FileSynchronizer<ENTRY>>>(this.fileSynchronizerMap.entrySet())) {
            FileSynchronizer<ENTRY> fileSynchronizer;
            fileSynchronizer = entry.getValue();
            try {
                String generatedFileName = this.fileProvider.getFileName((Identifiable<KEY>)fileSynchronizer.getData());
                if (fileSynchronizer.getFile().getName().equals(generatedFileName)) continue;
                try {
                    File newFile = new File(fileSynchronizer.getFile().getParent(), generatedFileName);
                    if (!fileSynchronizer.getFile().renameTo(newFile)) {
                        throw new CouldNotPerformException("Rename failed without explicit error code, please rename file manually after registry shutdown!");
                    }
                    FileSynchronizer<ENTRY> newFileSynchronizer = new FileSynchronizer<ENTRY>(fileSynchronizer.getData(), newFile, FileSynchronizer.InitMode.AUTO, this.fileProcessor);
                    this.fileSynchronizerMap.replace(entry.getKey(), fileSynchronizer, newFileSynchronizer);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)this, (Exception)((Object)new CouldNotPerformException("Could not apply db Entry[" + fileSynchronizer.getFile().getName() + "] renaming to Entry[" + generatedFileName + "]!", (Throwable)ex)), (MultiException.ExceptionStack)exceptionStack);
                }
            }
            catch (CouldNotPerformException ex) {
                exceptionStack = MultiException.push((Object)this, (Exception)((Object)new CouldNotPerformException("Could not reconstruct filename of db Entry[" + fileSynchronizer.getFile().getName() + "]!", (Throwable)ex)), (MultiException.ExceptionStack)exceptionStack);
            }
        }
        MultiException.checkAndThrow((String)"Could not save all registry entries!", (MultiException.ExceptionStack)exceptionStack);
    }

    @Override
    public void checkWriteAccess() throws RejectedException {
        try {
            if (((Boolean)((JPForce)JPService.getProperty(JPForce.class)).getValue()).booleanValue()) {
                return;
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)this.logger);
        }
        super.checkWriteAccess();
        if (this.isOutdated()) {
            throw new RejectedException("Database[" + this.databaseDirectory.getAbsolutePath() + "] is outdated!");
        }
        if (!this.databaseDirectory.canWrite()) {
            throw new RejectedException("DatabaseDirectory[" + this.databaseDirectory.getAbsolutePath() + "] not writable!");
        }
    }

    @Override
    public void shutdown() {
        try {
            this.saveRegistry();
        }
        catch (MultiException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Final save failed!", (Throwable)ex), (Logger)this.logger);
        }
        this.fileSynchronizerMap.clear();
        super.shutdown();
    }

    public File getDatabaseDirectory() {
        return this.databaseDirectory;
    }

    @Override
    public Integer getDBVersion() {
        return this.versionControl.getLatestDBVersion();
    }

    @Override
    public boolean isConsistent() {
        return super.isConsistent() && !this.isOutdated();
    }

    public boolean isOutdated() {
        return this.databaseState == DatabaseState.OUTDATED;
    }

    public DatabaseState getDatabaseState() {
        return this.databaseState;
    }

    public static enum DatabaseState {
        UNKNOWN,
        OUTDATED,
        LATEST;

    }
}

