/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.storage.file;

import java.io.FileFilter;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Identifiable;
import org.openbase.jul.storage.file.FileNameConverter;
import org.openbase.jul.storage.file.FileProvider;
import org.openbase.jul.storage.file.filter.JSonFileFilter;

public class ProtoBufJSonFileProvider
implements FileProvider<Identifiable<String>> {
    @Override
    public String getFileName(Identifiable<String> context) throws CouldNotPerformException {
        try {
            if (context == null) {
                throw new NotAvailableException("context");
            }
            return FileNameConverter.convertIntoValidFileName(((String)context.getId()).replaceAll("/", "_")) + ".json";
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not generate file name!", (Throwable)ex);
        }
    }

    @Override
    public String getFileType() {
        return "json";
    }

    @Override
    public FileFilter getFileFilter() {
        return new JSonFileFilter();
    }
}

