/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.schedule.SyncObject;

public class Stopwatch {
    private final SyncObject startWaiter = new SyncObject("StartWaiter");
    private final SyncObject stopWaiter = new SyncObject("StopWaiter");
    private final SyncObject timeSync = new SyncObject("TimeSync");
    private long startTime;
    private long endTime;

    public Stopwatch() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        SyncObject syncObject = this.timeSync;
        synchronized (syncObject) {
            this.startTime = -1L;
            this.endTime = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        SyncObject syncObject = this.startWaiter;
        synchronized (syncObject) {
            SyncObject syncObject2 = this.timeSync;
            synchronized (syncObject2) {
                this.startTime = System.currentTimeMillis();
            }
            this.startWaiter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        SyncObject syncObject = this.timeSync;
        synchronized (syncObject) {
            this.reset();
            this.start();
        }
    }

    public long getTime() throws NotAvailableException {
        SyncObject syncObject = this.timeSync;
        synchronized (syncObject) {
            try {
                if (!this.isRunning()) {
                    throw new InvalidStateException("Stopwatch was never started!");
                }
                if (this.endTime == -1L) {
                    return System.currentTimeMillis() - this.startTime;
                }
                return this.endTime - this.startTime;
            }
            catch (CouldNotPerformException ex) {
                throw new NotAvailableException("time", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        SyncObject syncObject = this.timeSync;
        synchronized (syncObject) {
            return this.startTime != -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop() throws CouldNotPerformException {
        SyncObject syncObject = this.timeSync;
        synchronized (syncObject) {
            if (!this.isRunning()) {
                throw new InvalidStateException("Stopwatch was never started!");
            }
            SyncObject syncObject2 = this.stopWaiter;
            synchronized (syncObject2) {
                this.endTime = System.currentTimeMillis();
                this.stopWaiter.notifyAll();
            }
            return this.getTime();
        }
    }

    public long getStartTime() throws NotAvailableException {
        if (this.startTime == -1L) {
            throw new NotAvailableException("StartTime");
        }
        return this.startTime;
    }

    public long getEndTime() throws NotAvailableException {
        if (this.endTime == -1L) {
            throw new NotAvailableException("StopTime");
        }
        return this.endTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStart(long timeout) throws InterruptedException {
        SyncObject syncObject = this.startWaiter;
        synchronized (syncObject) {
            if (this.isRunning()) {
                return;
            }
            this.startWaiter.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStart() throws InterruptedException {
        SyncObject syncObject = this.startWaiter;
        synchronized (syncObject) {
            if (this.isRunning()) {
                return;
            }
            this.startWaiter.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop(long timeout) throws InterruptedException {
        SyncObject syncObject = this.stopWaiter;
        synchronized (syncObject) {
            if (this.endTime != -1L) {
                return;
            }
            this.stopWaiter.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForStop() throws InterruptedException {
        SyncObject syncObject = this.stopWaiter;
        synchronized (syncObject) {
            if (this.endTime != -1L) {
                return;
            }
            this.stopWaiter.wait();
        }
    }
}

