/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPTestMode;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecurrenceEventFilter<VALUE> {
    private static final Logger logger = LoggerFactory.getLogger(RecurrenceEventFilter.class);
    public static final long DEFAULT_TIMEOUT = 1000L;
    public static final long DEFAULT_TEST_TIMEOUT = 100L;
    private Timeout timeout;
    private VALUE lastValue;
    private boolean changeDetected = false;

    public RecurrenceEventFilter() {
        this(1000L);
    }

    public RecurrenceEventFilter(long timeout) {
        try {
            if (((Boolean)((JPTestMode)JPService.getProperty(JPTestMode.class)).getValue()).booleanValue()) {
                timeout = Math.min(timeout, 100L);
            }
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not access java property!", (Throwable)ex), (Logger)logger);
        }
        this.timeout = new Timeout(timeout){

            @Override
            public void expired() {
                if (RecurrenceEventFilter.this.changeDetected) {
                    RecurrenceEventFilter.this.callRelay();
                }
            }
        };
    }

    public synchronized void trigger(VALUE value) {
        this.lastValue = value;
        this.trigger();
    }

    public synchronized void trigger() {
        if (this.timeout.isActive()) {
            this.changeDetected = true;
            return;
        }
        this.changeDetected = false;
        this.callRelay();
        this.timeout.start();
    }

    public void cancel() {
        this.timeout.cancel();
    }

    public VALUE getLastValue() {
        return this.lastValue;
    }

    private void callRelay() {
        try {
            this.relay();
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)logger, (LogLevel)LogLevel.ERROR);
        }
    }

    public abstract void relay() throws Exception;
}

