/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.schedule;

import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LastValueHandler<V>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LastValueHandler.class);
    public static final long DEFAULT_DELAY = 0L;
    private final String name;
    private V value;
    private V oldValue;
    private final Object exetcuterWaiter = new Object();
    private final Object EXECUTER_CONTROL_LOCK = new Object();
    private Thread executer;
    private boolean valueChanged;
    private long delayUntilNext;

    public LastValueHandler(String name) {
        this(name, 0L);
    }

    public LastValueHandler(String name, long delayUntilNext) {
        this.name = name;
        this.delayUntilNext = delayUntilNext;
        this.value = null;
        this.valueChanged = false;
        this.oldValue = null;
        this.executer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.executer.isInterrupted()) {
                while (this.hasValueChanged()) {
                    this.handle(this.value);
                }
                if (this.delayUntilNext != 0L) {
                    Thread.sleep(this.delayUntilNext);
                }
                try {
                    Object object = this.exetcuterWaiter;
                    synchronized (object) {
                        Thread.yield();
                        this.exetcuterWaiter.wait();
                    }
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
        }
        catch (Exception ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Handler thread crashed!", (Throwable)ex), (Logger)logger);
        }
    }

    private boolean hasValueChanged() {
        if (this.value != this.oldValue) {
            this.oldValue = this.value;
            return true;
        }
        if (this.valueChanged) {
            this.valueChanged = false;
            return true;
        }
        return false;
    }

    public void setDelay(long delay) {
        this.delayUntilNext = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InterruptedException {
        Object object = this.EXECUTER_CONTROL_LOCK;
        synchronized (object) {
            if (this.executer != null) {
                if (this.executer.isAlive()) {
                    return;
                }
                if (this.executer.isInterrupted()) {
                    this.executer.join();
                }
                this.executer = null;
            }
            this.executer = new Thread((Runnable)this, this.name);
            this.executer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        Object object = this.EXECUTER_CONTROL_LOCK;
        synchronized (object) {
            if (this.executer == null) {
                return;
            }
            this.executer.interrupt();
            this.executer.join();
        }
    }

    public V getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(V value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        Object object = this.exetcuterWaiter;
        synchronized (object) {
            this.exetcuterWaiter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceValueChange() {
        this.valueChanged = true;
        Object object = this.exetcuterWaiter;
        synchronized (object) {
            this.exetcuterWaiter.notify();
        }
    }

    public abstract void handle(V var1);
}

