/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.Observer;

public interface Remote<M>
extends Shutdownable,
Activatable {
    public <R> R callMethod(String var1) throws CouldNotPerformException, InterruptedException;

    public <R, T> R callMethod(String var1, T var2) throws CouldNotPerformException, InterruptedException;

    public <R> R callMethod(String var1, long var2) throws CouldNotPerformException, TimeoutException, InterruptedException;

    public <R, T> R callMethod(String var1, T var2, long var3) throws CouldNotPerformException, TimeoutException, InterruptedException;

    public <R> Future<R> callMethodAsync(String var1) throws CouldNotPerformException;

    public <R, T> Future<R> callMethodAsync(String var1, T var2) throws CouldNotPerformException;

    public void init(String var1) throws InitializationException, InterruptedException;

    public void activate(boolean var1) throws CouldNotPerformException, InterruptedException;

    public void addConnectionStateObserver(Observer<ConnectionState> var1);

    public void removeConnectionStateObserver(Observer<ConnectionState> var1);

    public void addDataObserver(Observer<M> var1);

    public void removeDataObserver(Observer<M> var1);

    public boolean isDataAvailable();

    public Class<M> getDataClass();

    public M getData() throws NotAvailableException;

    public CompletableFuture<M> getDataFuture() throws CouldNotPerformException;

    public void waitForData() throws CouldNotPerformException, InterruptedException;

    public void waitForData(long var1, TimeUnit var3) throws NotAvailableException, InterruptedException;

    public boolean isConnected();

    public ConnectionState getConnectionState();

    public CompletableFuture<M> requestData() throws CouldNotPerformException;

    public static enum ConnectionState {
        UNKNOWN,
        CONNECTING,
        CONNECTED,
        DISCONNECTED;

    }
}

