/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.pattern;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.TimeoutException;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableImpl<T>
implements Observable<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObservableImpl.class);
    private static final boolean DEFAULT_UNCHANGED_VALUE_FILTER = true;
    private final boolean unchangedValueFilter;
    private final Object LOCK = new Object();
    private final List<Observer<T>> observers = new ArrayList<Observer<T>>();
    private T value;
    private int latestValueHash;

    public ObservableImpl() {
        this(true);
    }

    public ObservableImpl(boolean unchangedValueFilter) {
        this.unchangedValueFilter = unchangedValueFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(Observer<T> observer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.observers.contains(observer)) {
                LOGGER.warn("Skip observer registration. Observer[" + observer + "] is already registered!");
                return;
            }
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(Observer<T> observer) {
        Object object = this.LOCK;
        synchronized (object) {
            this.observers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            this.observers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForValue(long timeout, TimeUnit timeUnit) throws NotAvailableException, InterruptedException {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.value != null) {
                return;
            }
            if (timeUnit.toMillis(timeout) == 0L) {
                this.LOCK.wait();
            } else {
                timeUnit.timedWait(this.LOCK, timeout);
            }
            if (this.value == null) {
                throw new NotAvailableException("Observable was not available in time.", (Throwable)new TimeoutException());
            }
        }
    }

    @Override
    public T getValue() throws NotAvailableException {
        if (this.value == null) {
            throw new NotAvailableException("Value");
        }
        return this.value;
    }

    public boolean notifyObservers(T observable) throws MultiException {
        return this.notifyObservers(this, observable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean notifyObservers(Observable<T> source, T observable) throws MultiException {
        MultiException.ExceptionStack exceptionStack = null;
        Object object = this.LOCK;
        synchronized (object) {
            try {
                if (observable == null) {
                    LOGGER.debug("Skip notification because observable is null!");
                    boolean bl = false;
                    return bl;
                }
                if (this.unchangedValueFilter && this.value != null && observable.hashCode() == this.latestValueHash) {
                    LOGGER.debug("#+# Skip notification because observable has not been changed!");
                    boolean bl = false;
                    return bl;
                }
                this.value = observable;
                this.latestValueHash = this.value.hashCode();
                for (Observer<T> observer : new ArrayList<Observer<T>>(this.observers)) {
                    try {
                        observer.update(source, observable);
                    }
                    catch (Exception ex) {
                        exceptionStack = MultiException.push(observer, (Exception)ex, exceptionStack);
                    }
                }
            }
            finally {
                this.LOCK.notifyAll();
            }
        }
        MultiException.checkAndThrow((String)("Could not notify Data[" + observable + "] to all observer!"), (MultiException.ExceptionStack)exceptionStack);
        return true;
    }
}

