/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.exception.printer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPVerbose;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablePrinter
implements Printer {
    private static final Logger logger = LoggerFactory.getLogger(VariablePrinter.class);
    private String messages = "";

    @Override
    public void print(String message) {
        this.messages = this.messages + message + "\n";
    }

    @Override
    public void print(String message, Throwable throwable) {
        this.messages = this.messages + message;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        this.messages = this.messages + sw.toString();
        try {
            sw.close();
        }
        catch (IOException ex) {
            ExceptionPrinter.printHistory(new CouldNotPerformException("Could not print stacktrace!", ex), logger);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return (Boolean)((JPVerbose)JPService.getProperty(JPVerbose.class)).getValue();
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory(new CouldNotPerformException("Could not access java property!", ex), logger);
            return true;
        }
    }

    public String getMessages() {
        return this.messages;
    }
}

