/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.jul.exception.printer;

import java.io.PrintStream;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPServiceException;
import org.openbase.jps.preset.JPVerbose;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.Printer;

public class SystemPrinter
implements Printer {
    private final PrintStream printStream;

    public SystemPrinter(PrintStream printStream) {
        this.printStream = printStream;
    }

    @Override
    public void print(String message) {
        this.printStream.println(message);
    }

    @Override
    public void print(String message, Throwable throwable) {
        this.printStream.println(message);
        throwable.printStackTrace(this.printStream);
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return (Boolean)((JPVerbose)JPService.getProperty(JPVerbose.class)).getValue();
        }
        catch (JPServiceException ex) {
            ExceptionPrinter.printHistory(new CouldNotPerformException("Could not access java property!", ex), System.err);
            return true;
        }
    }
}

