/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DataTypeFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpFlightServerCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpFlightServerCodegen.class);
    protected HashSet<String> typeHintable = new HashSet<String>(Arrays.asList("array", "bool", "float", "int", "string"));

    public PhpFlightServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.BearerToken, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeDataTypeFeatures(new DataTypeFeature[]{DataTypeFeature.MapOfCollectionOfEnum, DataTypeFeature.MapOfEnum, DataTypeFeature.MapOfCollectionOfModel, DataTypeFeature.MapOfModel}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.FormMultipart, ParameterFeature.FormUnencoded, ParameterFeature.Cookie}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.templateDir = "php-flight";
        this.embeddedTemplateDir = "php-flight";
        this.importMapping.clear();
        this.srcBasePath = "";
        this.defaultIncludes = new HashSet<String>(Arrays.asList("\\DateTime"));
        this.variableNamingConvention = "camelCase";
        this.artifactVersion = "1.0.0";
        this.setInvokerPackage("OpenAPIServer");
        this.testPackage = this.invokerPackage + "\\Test";
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.outputFolder = "generated-code" + File.separator + "php-flight";
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.apiTestTemplateFiles.clear();
        this.templateDir = "php-flight";
        this.embeddedTemplateDir = "php-flight";
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.stream().filter(o -> Objects.equals(o.getOpt(), "variableNamingConvention")).findFirst().ifPresent(o -> o.defaultValue("camelCase"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-flight";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Flight Framework server library.";
    }

    @Override
    public String apiFileFolder() {
        if (this.apiPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.apiPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        if (this.modelPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.modelPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.inlineSchemaOption.put("RESOLVE_INLINE_ENUMS", "true");
        this.additionalProperties.put("relativeSrcBasePath", this.srcBasePath.isEmpty() ? "" : this.srcBasePath + "/");
        this.additionalProperties.put("modelSrcPath", "./" + this.toSrcPath(this.modelPackage, this.srcBasePath));
        this.additionalProperties.put("apiSrcPath", "./" + this.toSrcPath(this.apiPackage, this.srcBasePath));
        this.additionalProperties.put("testSrcPath", "./" + this.toSrcPath(this.testPackage, this.srcBasePath));
        this.additionalProperties.put("escapedModelPackage", this.modelPackage.replace("\\", "\\\\"));
        if (this.additionalProperties.containsKey("testPackage")) {
            this.testPackage = this.invokerPackage + "\\" + (String)this.additionalProperties.get("testPackage");
        }
        this.additionalProperties.put("testPackage", this.testPackage);
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("phpunit.mustache", "", "phpunit.xml.dist"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("register_routes.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "RegisterRoutes.php"));
        this.supportingFiles.add(new SupportingFile("register_routes_test.mustache", this.toSrcPath(this.testPackage, this.srcBasePath), "RegisterRoutesTest.php"));
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        operationList.forEach(operation -> {
            operation.vendorExtensions.put("x-path", this.mapToFlightPath(operation.path));
            CodegenResponse defaultResponse = operation.responses.stream().filter(r -> r.is2xx && r.dataType != null && !this.getTypeHint(r.dataType, false, false).isEmpty()).findFirst().orElse(null);
            String returnType = defaultResponse != null ? this.getTypeHint(defaultResponse.dataType, false, false) + "|null" : "void";
            operation.vendorExtensions.put("x-return-type", returnType);
            operation.vendorExtensions.put("x-return-type-is-void", returnType.equals("void"));
            operation.vendorExtensions.put("x-return-type-comment", defaultResponse != null ? this.getTypeHint(defaultResponse.dataType, true, false) + "|null" : "void");
            operation.vendorExtensions.put("x-default-media-type", defaultResponse != null ? (defaultResponse.getContent().containsKey("application/json") ? "application/json" : defaultResponse.getContent().keySet().stream().findFirst().orElse(null)) : null);
            operation.vendorExtensions.put("x-default-status-code", defaultResponse != null ? defaultResponse.code : operation.responses.stream().filter(r -> !r.isDefault).findFirst().map(r -> r.code).orElse("200"));
            operation.vendorExtensions.put("x-nonFormParams", operation.allParams.stream().filter(p -> !p.isFormParam).toArray());
            operation.allParams.forEach(param -> {
                param.vendorExtensions.put("x-parameter-type", param.required ? this.getTypeHint(param.dataType, false, false) : this.getTypeHintNullable(param.dataType, false));
                String commentType = param.required ? this.getTypeHint(param.dataType, true, false) : this.getTypeHintNullable(param.dataType, false);
                param.vendorExtensions.put("x-comment-type", commentType);
                param.vendorExtensions.put("x-comment-type-escaped", commentType.replace("\\", "\\\\"));
            });
        });
        this.escapeMediaType(operationList);
        return objs;
    }

    private String mapToFlightPath(String path) {
        return path.replaceAll("\\{([^}]+)}", "@$1");
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        ModelMap models = objs.getModels().get(0);
        CodegenModel model = models.getModel();
        for (CodegenProperty var : model.vars) {
            if (var.dataType == null) continue;
            var.vendorExtensions.put("x-parameter-type", var.required ? this.getTypeHint(var.dataType, false, true) : this.getTypeHintNullable(var.dataType, true));
            var.vendorExtensions.put("x-comment-type", var.required ? this.getTypeHint(var.dataType, true, true) : this.getTypeHintNullableForComments(var.dataType, true));
        }
        return objs;
    }

    protected String getTypeHintNullable(String type, boolean modelContext) {
        String typeHint = this.getTypeHint(type, false, modelContext);
        if (!typeHint.equals("")) {
            return "?" + typeHint;
        }
        return typeHint;
    }

    protected String getTypeHintNullableForComments(String type, boolean modelContext) {
        String typeHint = this.getTypeHint(type, true, modelContext);
        if (!typeHint.equals("")) {
            return typeHint + "|null";
        }
        return typeHint;
    }

    protected String getTypeHint(String type, boolean forComments, boolean modelContext) {
        if (type.endsWith("[]")) {
            if (forComments) {
                String typeWithoutArray = type.substring(0, type.length() - 2);
                return this.getTypeHint(typeWithoutArray, true, modelContext) + "[]";
            }
            return "array";
        }
        if (this.typeHintable.contains(type)) {
            return type;
        }
        if (this.defaultIncludes.contains(type)) {
            return type;
        }
        if (this.isModelClass(type).booleanValue()) {
            return modelContext ? this.extractSimpleName(type) : type;
        }
        return "";
    }

    protected Boolean isModelClass(String type) {
        return type.contains(this.modelPackage());
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return this.toAbstractName("DefaultApi");
        }
        return this.toAbstractName(StringUtils.camelize(name) + "Api");
    }

    @Override
    public String toApiTestFilename(String name) {
        if (name.length() == 0) {
            return "DefaultApiTest";
        }
        return StringUtils.camelize(name) + "ApiTest";
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.encodePath(path);
        return op;
    }
}

