/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.JavaMicronautClientCodegen;
import org.openapitools.codegen.languages.JavaMicronautServerCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaMicronautAbstractCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
OptionalFeatures {
    public static final String OPT_TITLE = "title";
    public static final String OPT_BUILD = "build";
    public static final String OPT_BUILD_GRADLE = "gradle";
    public static final String OPT_BUILD_MAVEN = "maven";
    public static final String OPT_BUILD_ALL = "all";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_TEST_SPOCK = "spock";
    public static final String OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR = "requiredPropertiesInConstructor";
    public static final String OPT_MICRONAUT_VERSION = "micronautVersion";
    public static final String OPT_USE_AUTH = "useAuth";
    public static final String OPT_VISITABLE = "visitable";
    public static final String OPT_DATE_LIBRARY_JAVA8 = "java8";
    public static final String OPT_DATE_LIBRARY_JAVA8_LOCAL_DATETIME = "java8-localdatetime";
    public static final String OPT_DATE_FORMAT = "dateFormat";
    public static final String OPT_DATETIME_FORMAT = "datetimeFormat";
    public static final String OPT_REACTIVE = "reactive";
    public static final String OPT_WRAP_IN_HTTP_RESPONSE = "wrapInHttpResponse";
    public static final String OPT_APPLICATION_NAME = "applicationName";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS = "generateSwaggerAnnotations";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1 = "swagger1";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2 = "swagger2";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE = "true";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE = "false";
    public static final String OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG = "generateOperationOnlyForFirstTag";
    protected final Logger LOGGER = LoggerFactory.getLogger(JavaMicronautAbstractCodegen.class);
    protected String title;
    protected boolean useOptional;
    protected boolean visitable;
    protected String buildTool;
    protected String testTool;
    protected boolean requiredPropertiesInConstructor = true;
    protected String micronautVersion;
    protected boolean reactive;
    protected boolean wrapInHttpResponse;
    protected String appName;
    protected String generateSwaggerAnnotations;
    protected boolean generateOperationOnlyForFirstTag;
    protected String serializationLibrary = SERIALIZATION_LIBRARY_TYPE.jackson.name();
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_ANY = "*/*";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String OFFSET_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXXX";

    public JavaMicronautAbstractCodegen() {
        this.useBeanValidation = true;
        this.useOptional = false;
        this.visitable = false;
        this.buildTool = OPT_BUILD_ALL;
        this.testTool = OPT_TEST_JUNIT;
        this.outputFolder = this instanceof JavaMicronautClientCodegen ? "generated-code/java-micronaut-client" : "generated-code/java-micronaut";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools";
        this.artifactId = this instanceof JavaMicronautClientCodegen ? "openapi-micronaut-client" : "openapi-micronaut";
        this.templateDir = "java-micronaut";
        this.embeddedTemplateDir = "java-micronaut";
        this.apiDocPath = "docs/apis";
        this.modelDocPath = "docs/models";
        this.dateLibrary = OPT_DATE_LIBRARY_JAVA8;
        this.micronautVersion = "3.4.3";
        this.reactive = true;
        this.wrapInHttpResponse = false;
        this.appName = this.artifactId;
        this.generateSwaggerAnnotations = this instanceof JavaMicronautClientCodegen ? OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE : OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
        this.generateOperationOnlyForFirstTag = this instanceof JavaMicronautServerCodegen;
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect})));
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_MICRONAUT_VERSION, "Micronaut version, only >=3.0.0 versions are supported").defaultValue(this.micronautVersion));
        this.cliOptions.add(new CliOption(OPT_APPLICATION_NAME, "Micronaut application name (Defaults to the artifactId value)").defaultValue(this.appName));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean("useOptional", "Use Optional container for optional parameters", this.useOptional));
        this.cliOptions.add(CliOption.newBoolean(OPT_VISITABLE, "Generate visitor for subtypes with a discriminator", this.visitable));
        this.cliOptions.add(CliOption.newBoolean(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, "Allow only to create models with all the required properties provided in constructor", this.requiredPropertiesInConstructor));
        this.cliOptions.add(CliOption.newBoolean(OPT_REACTIVE, "Make the responses use Reactor Mono as wrapper", this.reactive));
        this.cliOptions.add(CliOption.newBoolean(OPT_WRAP_IN_HTTP_RESPONSE, "Wrap the response in HttpResponse object", this.wrapInHttpResponse));
        this.cliOptions.add(CliOption.newBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, "When false, the operation method will be duplicated in each of the tags if multiple tags are assigned to this operation. If true, each operation will be generated only once in the first assigned tag.", this.generateOperationOnlyForFirstTag));
        CliOption buildToolOption = new CliOption(OPT_BUILD, "Specify for which build tool to generate files").defaultValue(this.buildTool);
        HashMap<String, String> buildToolOptionMap = new HashMap<String, String>();
        buildToolOptionMap.put(OPT_BUILD_GRADLE, "Gradle configuration is generated for the project");
        buildToolOptionMap.put(OPT_BUILD_MAVEN, "Maven configuration is generated for the project");
        buildToolOptionMap.put(OPT_BUILD_ALL, "Both Gradle and Maven configurations are generated");
        buildToolOption.setEnum(buildToolOptionMap);
        this.cliOptions.add(buildToolOption);
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        HashMap<String, String> testToolOptionMap = new HashMap<String, String>();
        testToolOptionMap.put(OPT_TEST_JUNIT, "Use JUnit as test tool");
        testToolOptionMap.put(OPT_TEST_SPOCK, "Use Spock as test tool");
        testToolOption.setEnum(testToolOptionMap);
        this.cliOptions.add(testToolOption);
        CliOption generateSwaggerAnnotationsOption = new CliOption(OPT_GENERATE_SWAGGER_ANNOTATIONS, "Specify if you want to generate swagger annotations and which version").defaultValue(this.generateSwaggerAnnotations);
        HashMap<String, String> generateSwaggerAnnotationsOptionMap = new HashMap<String, String>();
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1, "Use io.swagger:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2, "Use io.swagger.core.v3:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE, "Equivalent to \"swagger2\"");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE, "Do not generate swagger annotations");
        generateSwaggerAnnotationsOption.setEnum(generateSwaggerAnnotationsOptionMap);
        this.cliOptions.add(generateSwaggerAnnotationsOption);
        this.cliOptions.add(new CliOption(OPT_DATE_FORMAT, "Specify the format pattern of date as a string"));
        this.cliOptions.add(new CliOption(OPT_DATETIME_FORMAT, "Specify the format pattern of date-time as a string"));
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(opt -> {
            HashMap<String, String> valuesEnum = new HashMap<String, String>();
            valuesEnum.put(OPT_DATE_LIBRARY_JAVA8, opt.getEnum().get(OPT_DATE_LIBRARY_JAVA8));
            valuesEnum.put(OPT_DATE_LIBRARY_JAVA8_LOCAL_DATETIME, opt.getEnum().get(OPT_DATE_LIBRARY_JAVA8_LOCAL_DATETIME));
            opt.setEnum(valuesEnum);
        });
        CliOption serializationLibraryOpt = CliOption.newString("serializationLibrary", "Serialization library for model");
        serializationLibraryOpt.defaultValue(SERIALIZATION_LIBRARY_TYPE.jackson.name());
        HashMap<String, String> serializationLibraryOptions = new HashMap<String, String>();
        serializationLibraryOptions.put(SERIALIZATION_LIBRARY_TYPE.jackson.name(), "Jackson as serialization library");
        serializationLibraryOptions.put(SERIALIZATION_LIBRARY_TYPE.micronaut_serde_jackson.name(), "Use micronaut-serialization with Jackson annotations");
        serializationLibraryOpt.setEnum(serializationLibraryOptions);
        this.cliOptions.add(serializationLibraryOpt);
        String[] reservedWordsArray = new String[]{"client", "format", "queryvalue", "queryparam", "pathvariable", "header", "cookie", "authorization", "body", "application"};
        this.reservedWords.addAll(Arrays.asList(reservedWordsArray));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.invokerPackage = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey(OPT_MICRONAUT_VERSION)) {
            this.micronautVersion = (String)this.additionalProperties.get(OPT_MICRONAUT_VERSION);
        } else {
            this.additionalProperties.put(OPT_MICRONAUT_VERSION, this.micronautVersion);
        }
        if (this.additionalProperties.containsKey(OPT_APPLICATION_NAME)) {
            this.appName = (String)this.additionalProperties.get(OPT_APPLICATION_NAME);
        } else {
            this.additionalProperties.put(OPT_APPLICATION_NAME, this.artifactId);
        }
        if (this.additionalProperties.containsKey("useOptional")) {
            this.setUseOptional(this.convertPropertyToBoolean("useOptional"));
        }
        this.writePropertyBack("useOptional", this.useOptional);
        if (this.additionalProperties.containsKey(OPT_VISITABLE)) {
            this.setVisitable(this.convertPropertyToBoolean(OPT_VISITABLE));
        }
        this.writePropertyBack(OPT_VISITABLE, this.visitable);
        if (this.additionalProperties.containsKey(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR)) {
            this.requiredPropertiesInConstructor = this.convertPropertyToBoolean(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR);
        }
        this.writePropertyBack(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, this.requiredPropertiesInConstructor);
        if (this.additionalProperties.containsKey(OPT_REACTIVE)) {
            this.reactive = this.convertPropertyToBoolean(OPT_REACTIVE);
        }
        this.writePropertyBack(OPT_REACTIVE, this.reactive);
        if (this.additionalProperties.containsKey(OPT_WRAP_IN_HTTP_RESPONSE)) {
            this.wrapInHttpResponse = this.convertPropertyToBoolean(OPT_WRAP_IN_HTTP_RESPONSE);
        }
        this.writePropertyBack(OPT_WRAP_IN_HTTP_RESPONSE, this.wrapInHttpResponse);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG)) {
            this.generateOperationOnlyForFirstTag = this.convertPropertyToBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, this.generateOperationOnlyForFirstTag);
        if (this.additionalProperties.containsKey(OPT_BUILD)) {
            switch ((String)this.additionalProperties.get(OPT_BUILD)) {
                case "gradle": 
                case "maven": 
                case "all": {
                    this.buildTool = (String)this.additionalProperties.get(OPT_BUILD);
                    break;
                }
                default: {
                    throw new RuntimeException("Build tool \"" + this.additionalProperties.get(OPT_BUILD) + "\" is not supported or misspelled.");
                }
            }
        }
        this.additionalProperties.put(OPT_BUILD, this.buildTool);
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            switch ((String)this.additionalProperties.get(OPT_TEST)) {
                case "junit": 
                case "spock": {
                    this.testTool = (String)this.additionalProperties.get(OPT_TEST);
                    break;
                }
                default: {
                    throw new RuntimeException("Test tool \"" + this.additionalProperties.get(OPT_TEST) + "\" is not supported or misspelled.");
                }
            }
        }
        this.additionalProperties.put(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.additionalProperties.put("isTestSpock", true);
        }
        if (this.additionalProperties.containsKey(OPT_GENERATE_SWAGGER_ANNOTATIONS)) {
            String value;
            switch (value = String.valueOf(this.additionalProperties.get(OPT_GENERATE_SWAGGER_ANNOTATIONS))) {
                case "swagger1": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1;
                    break;
                }
                case "swagger2": 
                case "true": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
                    break;
                }
                case "false": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
                    break;
                }
                default: {
                    throw new RuntimeException("Value \"" + value + "\" for the generateSwaggerAnnotations parameter is unsupported or misspelled");
                }
            }
        }
        if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger1Annotations", true);
        } else if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
        }
        this.additionalProperties.put(this.serializationLibrary, true);
        this.jackson = "jackson".equals(this.serializationLibrary);
        String resourceFolder = this.projectFolder + "/resources";
        this.supportingFiles.add(new SupportingFile("common/configuration/application.yml.mustache", resourceFolder, "application.yml").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("common/configuration/logback.xml.mustache", resourceFolder, "logback.xml").doNotOverwrite());
        if (this.buildTool.equals(OPT_BUILD_GRADLE) || this.buildTool.equals(OPT_BUILD_ALL)) {
            this.supportingFiles.add(new SupportingFile("common/configuration/gradle/build.gradle.mustache", "", "build.gradle").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("common/configuration/gradle/settings.gradle.mustache", "", "settings.gradle").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("common/configuration/gradle/gradle.properties.mustache", "", "gradle.properties").doNotOverwrite());
            String gradleWrapperFolder = "gradle/wrapper";
            this.supportingFiles.add(new SupportingFile("common/configuration/gradlew/gradlew.mustache", "", "gradlew"));
            this.supportingFiles.add(new SupportingFile("common/configuration/gradlew/gradlew.bat.mustache", "", "gradlew.bat"));
            this.supportingFiles.add(new SupportingFile("common/configuration/gradlew/gradle-wrapper.properties.mustache", "gradle/wrapper", "gradle-wrapper.properties"));
            this.supportingFiles.add(new SupportingFile("common/configuration/gradlew/gradle-wrapper.jar", "gradle/wrapper", "gradle-wrapper.jar"));
        }
        if (this.buildTool.equals(OPT_BUILD_MAVEN) || this.buildTool.equals(OPT_BUILD_ALL)) {
            this.supportingFiles.add(new SupportingFile("common/configuration/pom.xml.mustache", "", "pom.xml").doNotOverwrite());
            this.supportingFiles.add(new SupportingFile("common/configuration/mavenw/mvnw.mustache", "", "mvnw"));
            this.supportingFiles.add(new SupportingFile("common/configuration/mavenw/mvnw.bat.mustache", "", "mvnw.bat"));
            this.supportingFiles.add(new SupportingFile("common/configuration/mavenw/MavenWrapperDownloader.java.mustache", ".mvn/wrapper", "MavenWrapperDownloader.java"));
            this.supportingFiles.add(new SupportingFile("common/configuration/mavenw/maven-wrapper.jar.mustache", ".mvn/wrapper", "maven-wrapper.jar"));
            this.supportingFiles.add(new SupportingFile("common/configuration/mavenw/maven-wrapper.properties.mustache", ".mvn/wrapper", "maven-wrapper.properties"));
        }
        this.supportingFiles.add(new SupportingFile("common/configuration/git/gitignore.mustache", "", ".gitignore").doNotOverwrite());
        this.additionalProperties.putIfAbsent(OPT_DATE_FORMAT, DATE_FORMAT);
        if (this.dateLibrary.equals(OPT_DATE_LIBRARY_JAVA8)) {
            this.typeMapping.put("DateTime", "OffsetDateTime");
            this.typeMapping.put("date", "LocalDate");
            this.additionalProperties.putIfAbsent(OPT_DATETIME_FORMAT, OFFSET_DATETIME_FORMAT);
        } else if (this.dateLibrary.equals(OPT_DATE_LIBRARY_JAVA8_LOCAL_DATETIME)) {
            this.typeMapping.put("DateTime", "LocalDateTime");
            this.typeMapping.put("date", "LocalDate");
            this.additionalProperties.putIfAbsent(OPT_DATETIME_FORMAT, DATETIME_FORMAT);
        }
        this.importMapping.putIfAbsent("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.putIfAbsent("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.putIfAbsent("LocalDate", "java.time.LocalDate");
        this.modelDocTemplateFiles.clear();
        this.modelDocTemplateFiles.put("common/doc/model_doc.mustache", ".md");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("common/model/model.mustache", ".java");
        this.modelTestTemplateFiles.clear();
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.modelTestTemplateFiles.put("common/test/model_test.mustache", ".java");
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.modelTestTemplateFiles.put("common/test/model_test.groovy.mustache", ".groovy");
        }
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage()).replace('.', '/');
        String modelFolder = (this.sourceFolder + "/" + this.modelPackage()).replace('.', '/');
        this.additionalProperties.put("invokerFolder", invokerFolder);
        this.additionalProperties.put("resourceFolder", resourceFolder);
        this.additionalProperties.put("apiFolder", apiFolder);
        this.additionalProperties.put("modelFolder", modelFolder);
    }

    @Override
    public String apiTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.apiPackage().replaceAll("\\.", "/");
        }
        return this.getOutputDir() + "/src/test/java/" + this.apiPackage().replaceAll("\\.", "/");
    }

    @Override
    public String modelTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.modelPackage().replaceAll("\\.", "/");
        }
        return this.getOutputDir() + "/src/test/java/" + this.modelPackage().replaceAll("\\.", "/");
    }

    @Override
    public String toApiTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toApiName(name) + "Spec";
        }
        return this.toApiName(name) + "Test";
    }

    @Override
    public String toModelTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toModelName(name) + "Spec";
        }
        return this.toModelName(name) + "Test";
    }

    @Override
    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    @Override
    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    @Override
    public String sanitizeTag(String tag) {
        return tag;
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (this.generateOperationOnlyForFirstTag && !co.tags.get(0).getName().equals(tag)) {
            return;
        }
        super.addOperationToGroup(super.sanitizeTag(tag), resourcePath, operation, co, operations);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map<String, CodegenModel> models = allModels.stream().map(ModelMap::getModel).collect(Collectors.toMap(v -> v.classname, v -> v));
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            op.vendorExtensions.put("methodAllowsBody", op.httpMethod.equals("PUT") || op.httpMethod.equals("POST") || op.httpMethod.equals("PATCH"));
            if (op.returnType != null) {
                String groovyExample;
                String example;
                if (models.containsKey(op.returnType)) {
                    CodegenModel m = models.get(op.returnType);
                    List allowableValues = null;
                    if (m.allowableValues != null && m.allowableValues.containsKey("values")) {
                        allowableValues = (List)m.allowableValues.get("values");
                    }
                    example = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, false, false);
                    groovyExample = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, true, false);
                } else {
                    example = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, false, false);
                    groovyExample = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, true, false);
                }
                op.vendorExtensions.put("example", example);
                op.vendorExtensions.put("groovyExample", groovyExample);
            }
            if (CONTENT_TYPE_ANY.equals(op.vendorExtensions.get("x-contentType"))) {
                op.vendorExtensions.put("x-contentType", CONTENT_TYPE_APPLICATION_JSON);
            }
            op.consumes = op.consumes == null ? null : op.consumes.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).collect(Collectors.toList());
            List<Object> list = op.produces = op.produces == null ? null : op.produces.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).collect(Collectors.toList());
            if (CONTENT_TYPE_APPLICATION_FORM_URLENCODED.equals(op.vendorExtensions.get("x-contentType"))) {
                op.formParams.addAll(op.bodyParams);
                op.bodyParams.forEach(p -> {
                    p.isBodyParam = false;
                    p.isFormParam = true;
                });
                op.bodyParams.clear();
                continue;
            }
            if (!CONTENT_TYPE_MULTIPART_FORM_DATA.equals(op.vendorExtensions.get("x-contentType"))) continue;
            op.bodyParams.addAll(op.formParams);
            op.formParams.forEach(p -> {
                p.isBodyParam = true;
                p.isFormParam = false;
            });
            op.formParams.clear();
        }
        return objs;
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        return codegenModel;
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        objs = super.postProcessAllModels(objs);
        for (ModelsMap models : objs.values()) {
            CodegenModel model = models.getModels().get(0).getModel();
            if (model.getParentModel() != null) {
                model.vendorExtensions.put("requiredParentVars", model.getParentModel().requiredVars);
            }
            List requiredVars = model.vars.stream().filter(v -> v.required).collect(Collectors.toList());
            model.vendorExtensions.put("requiredVars", requiredVars);
        }
        return objs;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        p.vendorExtensions.put("groovyExample", this.getParameterExampleValue(p, true));
        p.example = this.getParameterExampleValue(p, false);
    }

    protected String getParameterExampleValue(CodegenParameter p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, p.requiredVars, groovy, false);
    }

    protected String getPropertyExampleValue(CodegenProperty p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, null, groovy, true);
    }

    public String getExampleValue(String defaultValue, String example, String dataType, Boolean isModel, List<Object> allowableValues, String itemsType, String itemsExample, List<CodegenProperty> requiredVars, boolean groovy, boolean isProperty) {
        String containerType;
        example = defaultValue != null ? defaultValue : example;
        String string = containerType = dataType == null ? null : dataType.split("<")[0];
        if ("String".equals(dataType)) {
            example = groovy ? (example != null ? "'" + this.escapeTextGroovy((String)example) + "'" : "'example'") : (example != null ? "\"" + this.escapeText((String)example) + "\"" : "\"example\"");
        } else if ("Integer".equals(dataType) || "Short".equals(dataType)) {
            example = example != null ? example : "56";
        } else if ("Long".equals(dataType)) {
            example = StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "56"), (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(dataType)) {
            example = StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(dataType)) {
            example = StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(dataType)) {
            example = example != null ? example : OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
        } else if ("File".equals(dataType)) {
            example = null;
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("LocalDate".equals(dataType)) {
            example = "LocalDate.of(2001, 2, 3)";
        } else if ("LocalDateTime".equals(dataType)) {
            example = "LocalDateTime.of(2001, 2, 3, 4, 5)";
        } else if ("BigDecimal".equals(dataType)) {
            example = "new BigDecimal(78)";
        } else if (allowableValues != null && !allowableValues.isEmpty()) {
            Object value = example;
            if (value == null || !allowableValues.contains(value)) {
                value = allowableValues.get(0);
            }
            if (isProperty) {
                dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
            }
            example = dataType + ".fromValue(\"" + value + "\")";
        } else if (isModel != null && isModel.booleanValue() || isModel == null && !this.languageSpecificPrimitives.contains(dataType)) {
            if (requiredVars == null) {
                example = null;
            } else if (this.requiredPropertiesInConstructor) {
                StringBuilder builder = new StringBuilder();
                if (isProperty) {
                    dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
                }
                builder.append("new ").append(dataType).append("(");
                for (int i = 0; i < requiredVars.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getPropertyExampleValue(requiredVars.get(i), groovy));
                }
                builder.append(")");
                example = builder.toString();
            } else {
                example = "new " + dataType + "()";
            }
        }
        if ("List".equals(containerType)) {
            Object innerExample;
            if ("String".equals(itemsType)) {
                String string2 = itemsExample = itemsExample != null ? itemsExample : "example";
                innerExample = groovy ? "'" + this.escapeTextGroovy(itemsExample) + "'" : "\"" + this.escapeText(itemsExample) + "\"";
            } else {
                Object object = innerExample = itemsExample != null ? itemsExample : "";
            }
            example = groovy ? "[" + (String)innerExample + "]" : "Arrays.asList(" + (String)innerExample + ")";
        } else if ("Set".equals(containerType)) {
            example = groovy ? "[].asSet()" : "new HashSet<>()";
        } else if ("Map".equals(containerType)) {
            example = groovy ? "[:]" : "new HashMap<>()";
        } else if (example == null) {
            example = "null";
        }
        return example;
    }

    public String escapeTextGroovy(String text) {
        if (text == null) {
            return null;
        }
        return this.escapeText(text).replaceAll("'", "\\'");
    }

    @Override
    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"replaceDotsWithUnderscore", (Object)new ReplaceDotsWithUnderscoreLambda());
    }

    public void setSerializationLibrary(String serializationLibrary) {
        try {
            this.serializationLibrary = SERIALIZATION_LIBRARY_TYPE.valueOf(serializationLibrary).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(serializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SERIALIZATION_LIBRARY_TYPE availableSerializationLibrary : SERIALIZATION_LIBRARY_TYPE.values()) {
                sb.append("\n  ").append(availableSerializationLibrary.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public boolean isUseOptional() {
        return this.useOptional;
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    private static class ReplaceDotsWithUnderscoreLambda
    implements Mustache.Lambda {
        private ReplaceDotsWithUnderscoreLambda() {
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replace('.', '_'));
        }
    }

    public static enum SERIALIZATION_LIBRARY_TYPE {
        jackson,
        micronaut_serde_jackson;

    }
}

