/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Escapers;
import com.samskivert.mustache.Mustache;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenSecurity;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAdaCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractAdaCodegen.class);
    public static final String HTTP_SUPPORT_OPTION = "httpSupport";
    public static final String OPENAPI_PACKAGE_NAME_OPTION = "openApiName";
    private static final String APPLICATION_XML = "application/xml";
    private static final String TEXT_XML = "text/xml";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    private static final String APPLICATION_PROBLEM_JSON = "application/problem+json";
    private static final String APPLICATION_PROBLEM_XML = "application/problem+xml";
    private static final String APPLICATION_MERGE_PATCH_JSON = "application/merge-patch+json";
    private static final String X_ADA_TYPE_NAME = "x-ada-type-name";
    private static final String X_ADA_VECTOR_TYPE_NAME = "x-ada-vector-type-name";
    private static final String X_ADA_NO_VECTOR = "x-ada-no-vector";
    private static final String X_ADA_SERIALIZE_OP = "x-ada-serialize-op";
    protected String packageName = "defaultPackage";
    protected String projectName = "defaultProject";
    protected List<ModelMap> orderedModels;
    protected final Map<String, List<String>> modelDepends;
    protected final Map<String, String> nullableTypeMapping;
    protected final Map<String, String> operationsScopes;
    protected final List<List<String>> mediaGroups;
    protected final List<List<NameBinding>> mediaLists;
    protected final Map<String, String> mediaToVariableName;
    protected final List<NameBinding> mediaVariables;
    protected final List<NameBinding> adaImports;
    protected final Set<String> adaImportSet = new TreeSet<String>();
    protected int scopeIndex = 0;
    protected String httpClientPackageName = "Curl";
    protected String openApiPackageName = "Swagger";
    private static final String bytesType = "swagger::ByteArray";

    public AbstractAdaCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        this.setReservedWordsLowerCase(Arrays.asList("abort", "abs", "abstract", "accept", "access", "aliased", "all", "and", "array", "at", "begin", "body", "case", "constant", "declare", "delay", "digits", "do", "else", "elsif", "end", "entry", "exception", "exit", "for", "function", "generic", "goto", "if", "in", "interface", "is", "limited", "loop", "mod", "new", "not", "null", "of", "or", "others", "out", "overriding", "package", "pragma", "private", "procedure", "protected", "raise", "range", "record", "rem", "renames", "requeue", "return", "reverse", "select", "separate", "some", "subtype", "synchronized", "tagged", "task", "terminate", "then", "type", "until", "use", "when", "while", "with", "xor"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("binary", bytesType);
        this.typeMapping.put("ByteArray", bytesType);
        this.nullableTypeMapping = new HashMap<String, String>();
        this.modelDepends = new HashMap<String, List<String>>();
        this.orderedModels = new ArrayList<ModelMap>();
        this.operationsScopes = new HashMap<String, String>();
        this.mediaGroups = new ArrayList<List<String>>();
        this.mediaLists = new ArrayList<List<NameBinding>>();
        this.mediaToVariableName = new HashMap<String, String>();
        this.mediaVariables = new ArrayList<NameBinding>();
        this.adaImports = new ArrayList<NameBinding>();
        this.importMapping = new HashMap<String, String>();
        this.addOption("projectName", "GNAT project name", this.projectName);
        this.cliOptions.add(CliOption.newString(HTTP_SUPPORT_OPTION, "The name of the HTTP support library.  Possible values include 'curl' or 'aws'."));
        this.cliOptions.add(CliOption.newString(OPENAPI_PACKAGE_NAME_OPTION, "The name of the Ada package which provides support for OpenAPI for the generated client and server code.  The default is 'Swagger'."));
        this.modelNameSuffix = "Type";
        this.templateDir = "Ada";
        this.embeddedTemplateDir = "Ada";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("integer", "boolean", "number", "long", "float", "double", "object", "string", "date", "DateTime", "binary"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(HTTP_SUPPORT_OPTION)) {
            String httpSupport = this.additionalProperties.get(HTTP_SUPPORT_OPTION).toString().toLowerCase(Locale.ROOT);
            if ("aws".equals(httpSupport)) {
                this.httpClientPackageName = "Aws";
            } else if ("curl".equals(httpSupport)) {
                this.httpClientPackageName = "Curl";
            } else {
                this.LOGGER.error("invalid http support option `{}`", (Object)httpSupport);
            }
        }
        if (this.additionalProperties.containsKey(OPENAPI_PACKAGE_NAME_OPTION)) {
            this.openApiPackageName = this.additionalProperties.get(OPENAPI_PACKAGE_NAME_OPTION).toString();
        }
        this.typeMapping.put("date", this.openApiPackageName + ".Date");
        this.typeMapping.put("DateTime", this.openApiPackageName + ".Datetime");
        this.typeMapping.put("string", this.openApiPackageName + ".UString");
        this.typeMapping.put("long", this.openApiPackageName + ".Long");
        this.typeMapping.put("array", this.openApiPackageName + ".Vector");
        this.typeMapping.put("map", this.openApiPackageName + ".Map");
        this.typeMapping.put("object", this.openApiPackageName + ".Object");
        this.typeMapping.put("number", this.openApiPackageName + ".Number");
        this.typeMapping.put("UUID", this.openApiPackageName + ".UString");
        this.typeMapping.put("URI", this.openApiPackageName + ".UString");
        this.typeMapping.put("file", this.openApiPackageName + ".Blob_Ref");
        this.typeMapping.put("binary", this.openApiPackageName + ".Blob_Ref");
        this.typeMapping.put("float", this.openApiPackageName + ".Number");
        this.typeMapping.put("double", this.openApiPackageName + ".Number");
        this.importMapping.put("File", this.openApiPackageName + ".File");
        this.nullableTypeMapping.put(this.openApiPackageName + ".Date", this.openApiPackageName + ".Nullable_Date");
        this.nullableTypeMapping.put(this.openApiPackageName + ".Datetime", this.openApiPackageName + ".Nullable_Date");
        this.nullableTypeMapping.put(this.openApiPackageName + ".UString", this.openApiPackageName + ".Nullable_UString");
        this.nullableTypeMapping.put("Integer", this.openApiPackageName + ".Nullable_Integer");
        this.nullableTypeMapping.put(this.openApiPackageName + ".Long", this.openApiPackageName + ".Nullable_Long");
        this.nullableTypeMapping.put("Boolean", this.openApiPackageName + ".Nullable_Boolean");
        this.nullableTypeMapping.put(this.openApiPackageName + ".Object", this.openApiPackageName + ".Object");
        this.mediaToVariableName.put(TEXT_PLAIN, this.openApiPackageName + ".Mime_Text");
        this.mediaToVariableName.put(APPLICATION_JSON, this.openApiPackageName + ".Mime_Json");
        this.mediaToVariableName.put(APPLICATION_XML, this.openApiPackageName + ".Mime_Xml");
        this.mediaToVariableName.put(APPLICATION_X_WWW_FORM_URLENCODED, this.openApiPackageName + ".Mime_Form");
    }

    public String toFilename(String name) {
        return name.replace(".", "-").toLowerCase(Locale.ROOT);
    }

    protected String toAdaIdentifier(String name, String prefix) {
        if (this.isReservedWord((String)name)) {
            this.LOGGER.warn("Identifier '{}' is a reserved word, renamed to {}{}", new Object[]{name, prefix, name});
            name = prefix + (String)name;
        }
        StringBuilder result = new StringBuilder();
        boolean needUpperCase = true;
        boolean prevUpperCase = false;
        if (((String)name).isEmpty() || Character.isDigit(((String)name).charAt(0)) || ((String)name).charAt(0) == '_') {
            result.append(prefix);
        }
        for (int i = 0; i < ((String)name).length(); ++i) {
            boolean isUpperOrDigit;
            char c = ((String)name).charAt(i);
            boolean bl = isUpperOrDigit = Character.isUpperCase(c) || Character.isDigit(c);
            if (needUpperCase) {
                needUpperCase = false;
                prevUpperCase = isUpperOrDigit;
                result.append(Character.toUpperCase(c));
                continue;
            }
            if (isUpperOrDigit) {
                if (!prevUpperCase) {
                    result.append('_');
                }
                result.append(c);
                needUpperCase = false;
                prevUpperCase = true;
                continue;
            }
            result.append(c);
            prevUpperCase = isUpperOrDigit;
            if (c != '_') continue;
            needUpperCase = true;
        }
        return result.toString();
    }

    @Override
    public String toOperationId(String operationId) {
        return this.toAdaIdentifier(this.sanitizeName(operationId), "Call_");
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        return this.toAdaIdentifier(this.sanitizeName(name), "P_");
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        return this.toAdaIdentifier(super.toParamName(name), "P_");
    }

    @Override
    public String toModelName(String name) {
        Object result = StringUtils.camelize(this.sanitizeName(name));
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            result = this.modelNamePrefix + "_" + (String)result;
        }
        if (this.isReservedWord(name)) {
            String modelName = "Model_" + (String)result;
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        if (((String)result).matches("^\\d.*")) {
            String modelName = "Model_" + (String)result;
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(result)) {
            String modelName = "Model_" + (String)result;
            this.LOGGER.warn("{} (model name matches existing language type) cannot be used as a model name. Renamed to {}", (Object)name, (Object)modelName);
            return modelName;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            result = (String)result + "_" + this.modelNameSuffix;
        }
        return result;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        Object var;
        if (this.enumNameMapping.containsKey(value)) {
            return (String)this.enumNameMapping.get(value);
        }
        if (value.isEmpty()) {
            var = "EMPTY";
        } else if (this.getSymbolName(value) != null) {
            var = this.getSymbolName(value).toUpperCase(Locale.ROOT);
        } else if ("Integer".equals(datatype) || "Long".equals(datatype) || "Float".equals(datatype) || "Double".equals(datatype)) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            var = varName = ((String)varName).replaceAll("\\.", "_DOT_");
        } else {
            var = value.replaceAll("\\W+", "_").toUpperCase(Locale.ROOT);
            var = ((String)var).matches("\\d.*") ? "_" + (String)var : this.sanitizeName((String)var);
        }
        return var;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p, boolean required) {
        CodegenProperty property = super.fromProperty(name, p, required);
        if (property != null) {
            String nameInPascalCase = property.nameInPascalCase;
            property.nameInPascalCase = nameInPascalCase = this.sanitizeName(nameInPascalCase);
        }
        return property;
    }

    @Override
    public String escapeReservedWord(String name) {
        return "p_" + name;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*").replace("-", "_");
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        compiler = super.processCompiler(compiler).emptyStringIsFalse(true);
        return compiler.withEscaper(Escapers.NONE);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        String schemaType = this.getSchemaType(p);
        if (schemaType != null) {
            schemaType = schemaType.replace("-", "_");
        }
        if (ModelUtils.isArraySchema(p)) {
            Schema<?> inner = ModelUtils.getSchemaItems(p);
            String itemType = this.getTypeDeclaration(inner);
            if (itemType.startsWith("OpenAPI.")) {
                return itemType + "_Vector";
            }
            return itemType + "_Vectors.Vector";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            String name = this.getTypeDeclaration(inner) + "_Map";
            if (name.startsWith(this.openApiPackageName)) {
                return name;
            }
            return this.openApiPackageName + "." + name;
        }
        if (this.typeMapping.containsKey(schemaType)) {
            return (String)this.typeMapping.get(schemaType);
        }
        if (this.languageSpecificPrimitives.contains(schemaType)) {
            return schemaType;
        }
        String modelType = this.toModelName(schemaType).replace("-", "_");
        if (ModelUtils.isStringSchema(p) || ModelUtils.isFileSchema(p) || this.languageSpecificPrimitives.contains(modelType)) {
            return modelType;
        }
        return this.modelPackage + ".Models." + modelType;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (parameter.dataType == null) {
            return;
        }
        parameter.vendorExtensions.put("x-is-model-type", this.isModelType(parameter));
        parameter.vendorExtensions.put("x-is-stream-type", this.isStreamType(parameter));
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        List securities = operation.getSecurity();
        if (securities != null && securities.size() > 0) {
            Map securitySchemes = this.openAPI.getComponents() != null ? this.openAPI.getComponents().getSecuritySchemes() : null;
            List globalSecurities = this.openAPI.getSecurity();
            Map<String, List<String>> scopes = this.getAuthScopes(securities, securitySchemes);
            if (scopes.isEmpty() && globalSecurities != null) {
                scopes = this.getAuthScopes(globalSecurities, securitySchemes);
            }
            op.vendorExtensions.put("x-scopes", scopes);
        }
        Set<String> produces = AbstractAdaCodegen.getProducesInfo(this.openAPI, operation);
        boolean producesPlainText = false;
        if (produces != null && !produces.isEmpty()) {
            ArrayList<String> mediaList = new ArrayList<String>();
            ArrayList<Map<String, String>> c = new ArrayList<Map<String, String>>();
            for (String mimeType : produces) {
                HashMap<String, String> mediaType = new HashMap<String, String>();
                if (this.isMimetypePlain(mimeType)) {
                    producesPlainText = true;
                }
                mediaType.put("mediaType", mimeType);
                c.add(mediaType);
                mediaList.add(mimeType);
            }
            op.produces = c;
            op.hasProduces = true;
            op.vendorExtensions.put("x-produces-media-index", this.collectMediaList(mediaList));
        }
        for (CodegenResponse rsp : op.responses) {
            if (rsp.dataType == null || !producesPlainText) continue;
            if (bytesType.equals(rsp.dataType)) {
                rsp.vendorExtensions.put("x-produces-bytes", true);
                continue;
            }
            rsp.vendorExtensions.put("x-produces-plain-text", true);
        }
        return op;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            this.postProcessOperationWithModels(op, allModels);
        }
        this.adaImportSet.remove(this.openApiPackageName);
        for (String adaImport : this.adaImportSet) {
            this.adaImports.add(new NameBinding(0, adaImport, adaImport));
        }
        this.additionalProperties.put("adaImports", this.adaImports);
        this.additionalProperties.put("mediaVariables", this.mediaVariables);
        this.additionalProperties.put("mediaLists", this.mediaLists);
        return objs;
    }

    private void postProcessOperationWithModels(CodegenOperation op, List<ModelMap> allModels) {
        if (op.consumes != null) {
            ArrayList<String> mediaList = new ArrayList<String>();
            for (Map<String, String> consume : op.consumes) {
                String mediaType = consume.get("mediaType");
                if (mediaType == null) continue;
                mediaList.add(mediaType.toLowerCase(Locale.ROOT));
                if (this.isMimetypeWwwFormUrlEncoded(mediaType)) {
                    this.additionalProperties.put("usesUrlEncodedForm", true);
                    continue;
                }
                if (this.isMimetypeMultipartFormData(mediaType)) {
                    op.vendorExtensions.put("x-consumes-multipart", true);
                    this.additionalProperties.put("apiUsesMultipartFormData", true);
                    this.additionalProperties.put("apiUsesMultipart", true);
                    continue;
                }
                if (!this.isMimetypeMultipartRelated(mediaType)) continue;
                op.vendorExtensions.put("x-consumes-multipart-related", true);
                this.additionalProperties.put("apiUsesMultipartRelated", true);
                this.additionalProperties.put("apiUsesMultipart", true);
            }
            op.vendorExtensions.put("x-consumes-media-index", this.collectMediaList(mediaList));
        }
        if (op.summary != null) {
            op.summary = op.summary.trim();
        }
        if (op.notes != null) {
            op.notes = op.notes.trim();
        }
        op.vendorExtensions.put("x-has-notes", op.notes != null && op.notes.length() > 0);
        String prefix = this.modelPackage() + ".Models";
        for (CodegenParameter p : op.allParams) {
            String dataType;
            if (p.isFormParam && p.isFile) {
                p.dataType = this.openApiPackageName + ".File_Part_Type";
            }
            if (!p.required && this.nullableTypeMapping.containsKey(p.dataType)) {
                p.dataType = this.nullableTypeMapping.get(p.dataType);
            }
            if (p.vendorExtensions.containsKey(X_ADA_TYPE_NAME)) {
                dataType = (String)p.vendorExtensions.get(X_ADA_TYPE_NAME);
            } else {
                CodegenProperty schema = p.getSchema();
                dataType = schema != null ? (String)schema.vendorExtensions.get(X_ADA_TYPE_NAME) : p.dataType;
                p.vendorExtensions.put(X_ADA_TYPE_NAME, dataType);
            }
            String pkgName = this.useType(dataType);
            if (pkgName != null && !pkgName.startsWith(prefix)) {
                this.adaImportSet.add(pkgName);
            }
            p.vendorExtensions.put("x-is-imported-type", pkgName != null);
            p.vendorExtensions.put("x-is-model-type", this.isModelType(p));
            p.vendorExtensions.put("x-is-stream-type", this.isStreamType(p));
        }
        for (CodegenParameter p : op.formParams) {
            if (!p.isFile) continue;
            p.dataType = this.openApiPackageName + ".File_Part_Type";
        }
        Map scopes = (Map)op.vendorExtensions.get("x-scopes");
        List<CodegenSecurity> opScopes = this.postProcessAuthMethod(op.authMethods, scopes);
        if (opScopes != null) {
            op.vendorExtensions.put("x-auth-scopes", opScopes);
        }
        CodegenProperty returnProperty = op.returnProperty;
        CodegenProperty returnType = null;
        if (returnProperty != null) {
            CodegenProperty itemType;
            returnType = itemType = returnProperty.getItems();
            if (itemType != null) {
                if (itemType.vendorExtensions.containsKey(X_ADA_VECTOR_TYPE_NAME)) {
                    String dataType = (String)itemType.vendorExtensions.get(X_ADA_VECTOR_TYPE_NAME);
                    returnProperty.vendorExtensions.put(X_ADA_TYPE_NAME, dataType);
                }
                returnProperty.vendorExtensions.put("x-is-model-type", this.isModelType(itemType));
                returnProperty.vendorExtensions.put("x-is-stream-type", this.isStreamType(itemType));
            } else {
                if (!returnProperty.vendorExtensions.containsKey(X_ADA_TYPE_NAME)) {
                    returnProperty.vendorExtensions.put(X_ADA_TYPE_NAME, returnProperty.dataType);
                }
                returnProperty.vendorExtensions.put("x-is-model-type", this.isModelType(returnProperty));
                returnProperty.vendorExtensions.put("x-is-stream-type", this.isStreamType(returnProperty));
            }
        }
        for (CodegenResponse rsp : op.responses) {
            Boolean required;
            if (rsp.dataType == null) continue;
            String dataType = rsp.dataType;
            if (returnType != null) {
                if (returnType.vendorExtensions.containsKey(X_ADA_VECTOR_TYPE_NAME)) {
                    dataType = (String)returnType.vendorExtensions.get(X_ADA_VECTOR_TYPE_NAME);
                    rsp.vendorExtensions.put(X_ADA_TYPE_NAME, dataType);
                }
                rsp.vendorExtensions.put("x-is-model-type", this.isModelType(returnType));
                rsp.vendorExtensions.put("x-is-stream-type", this.isStreamType(returnType));
                rsp.vendorExtensions.put("x-is-nullable", returnType.isNull);
                required = returnType.getHasRequired();
                if (!Boolean.TRUE.equals(required) && this.nullableTypeMapping.containsKey(dataType)) {
                    rsp.dataType = this.nullableTypeMapping.get(dataType);
                    rsp.vendorExtensions.put("x-is-required", false);
                } else {
                    rsp.vendorExtensions.put("x-is-required", true);
                }
                if (!rsp.vendorExtensions.containsKey(X_ADA_SERIALIZE_OP)) {
                    if (returnType.isLong && !required.booleanValue()) {
                        rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
                    } else if (rsp.isLong && "int64".equals(returnType.dataFormat)) {
                        rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Long_Entity");
                    } else {
                        rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
                    }
                }
                rsp.vendorExtensions.put("x-scz-return", true);
                continue;
            }
            rsp.vendorExtensions.put("x-scz-no-return", true);
            if (returnProperty == null) continue;
            if (!rsp.vendorExtensions.containsKey(X_ADA_TYPE_NAME)) {
                rsp.vendorExtensions.put(X_ADA_TYPE_NAME, returnProperty.dataType);
            }
            rsp.vendorExtensions.put("x-is-model-type", this.isModelType(returnProperty));
            rsp.vendorExtensions.put("x-is-stream-type", this.isStreamType(returnProperty));
            rsp.vendorExtensions.put("x-is-nullable", returnProperty.isNull);
            required = returnProperty.getHasRequired();
            if (!Boolean.TRUE.equals(required) && this.nullableTypeMapping.containsKey(dataType)) {
                rsp.dataType = this.nullableTypeMapping.get(dataType);
                rsp.vendorExtensions.put("x-is-required", false);
            } else {
                rsp.vendorExtensions.put("x-is-required", true);
            }
            if (rsp.vendorExtensions.containsKey(X_ADA_SERIALIZE_OP)) continue;
            if (returnProperty.isLong && !required.booleanValue()) {
                rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
                continue;
            }
            if (rsp.isLong && "int64".equals(returnProperty.dataFormat)) {
                rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Long_Entity");
                continue;
            }
            rsp.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
        }
        for (CodegenParameter p : op.pathParams) {
            String path = op.path;
            int pos = 0;
            int index = 0;
            while (pos >= 0 && pos < path.length() && (pos = path.indexOf(123, pos)) >= 0) {
                int last = path.indexOf(125, ++pos);
                ++index;
                if (last < 0 || path.substring(pos, last).equals(p.baseName)) break;
                pos = last + 1;
            }
            p.vendorExtensions.put("x-path-index", index);
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<Map<String, String>> imports = objs.getImports();
        String prefix = this.modelPackage() + ".Models";
        Iterator<Map<String, String>> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = iterator.next().get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        for (ModelMap modelMap : objs.getModels()) {
            String pkgName;
            CodegenModel codegenModel = modelMap.getModel();
            ArrayList<String> d = new ArrayList<String>();
            for (CodegenProperty p : codegenModel.vars) {
                boolean isStreamType;
                boolean isModel = false;
                CodegenProperty item = p;
                String dataType = null;
                String arrayDataType = null;
                if (p.vendorExtensions.containsKey(X_ADA_TYPE_NAME)) {
                    dataType = (String)p.vendorExtensions.get(X_ADA_TYPE_NAME);
                    this.LOGGER.info("Data type {} mapped to {}", (Object)p.dataType, (Object)dataType);
                }
                arrayDataType = (String)p.vendorExtensions.get(X_ADA_VECTOR_TYPE_NAME);
                if (p.isContainer) {
                    item = p.items;
                }
                if (!((isStreamType = this.isStreamType(p)) || item == null || item.isString || item.isPrimitiveType || item.isContainer || item.isInteger)) {
                    if (dataType == null) {
                        dataType = item.dataType;
                        if (dataType.startsWith(this.modelPackage + ".Models.") || item.isFreeFormObject) {
                            p.vendorExtensions.put(X_ADA_TYPE_NAME, dataType);
                        } else {
                            p.vendorExtensions.put(X_ADA_TYPE_NAME, this.modelPackage + ".Models." + dataType);
                        }
                        this.LOGGER.debug("Setting ada-type name {} for datatype {}", (Object)(this.modelPackage + ".Models." + dataType), (Object)dataType);
                    }
                    if (!d.contains(dataType)) {
                        d.add(dataType);
                    }
                    isModel = true;
                }
                Boolean noVector = Boolean.FALSE;
                if (p.vendorExtensions.get(X_ADA_NO_VECTOR) instanceof Boolean) {
                    noVector = (Boolean)p.vendorExtensions.get(X_ADA_NO_VECTOR);
                }
                p.vendorExtensions.put(X_ADA_NO_VECTOR, noVector);
                p.vendorExtensions.put("x-is-model-type", isModel);
                p.vendorExtensions.put("x-is-stream-type", isStreamType);
                String pkgImport = this.useType(dataType);
                p.vendorExtensions.put("x-is-imported-type", pkgImport != null);
                if (pkgImport != null) {
                    this.adaImportSet.add(pkgImport);
                }
                Boolean required = p.getRequired();
                if (!p.vendorExtensions.containsKey(X_ADA_SERIALIZE_OP)) {
                    if (p.isLong && !required.booleanValue()) {
                        p.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
                    } else if (p.isLong && "int64".equals(p.dataFormat)) {
                        p.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Long_Entity");
                    } else {
                        p.vendorExtensions.put(X_ADA_SERIALIZE_OP, "Write_Entity");
                    }
                }
                if (!Boolean.TRUE.equals(required) && this.nullableTypeMapping.containsKey(p.dataType)) {
                    p.dataType = this.nullableTypeMapping.get(p.dataType);
                    p.vendorExtensions.put("x-is-required", false);
                } else {
                    p.vendorExtensions.put("x-is-required", true);
                }
                p.vendorExtensions.put("x-is-nullable", p.isNullable);
            }
            Object name = (String)codegenModel.vendorExtensions.get(X_ADA_TYPE_NAME);
            if (name == null) {
                name = this.modelPackage + ".Models." + codegenModel.classname;
                codegenModel.vendorExtensions.put(X_ADA_TYPE_NAME, name);
            }
            if ((pkgName = this.useType((String)name)) != null) {
                this.adaImportSet.add(pkgName);
            }
            codegenModel.vendorExtensions.put(X_ADA_TYPE_NAME, name);
            codegenModel.vendorExtensions.put("x-is-imported-type", pkgName != null);
            this.modelDepends.put((String)name, d);
            this.orderedModels.add(modelMap);
        }
        objs.setImports(imports);
        TreeSet<ModelDepend> sorted = new TreeSet<ModelDepend>();
        for (ModelMap modelMap : this.orderedModels) {
            String modelName = this.modelPackage + ".Models." + modelMap.getModel().classname;
            sorted.add(new ModelDepend(modelMap, this.modelDepends.get(modelName), modelName));
        }
        ArrayList<ModelDepend> arrayList = new ArrayList<ModelDepend>();
        for (ModelDepend item : sorted) {
            int pos = arrayList.size();
            for (int i = 0; i < arrayList.size(); ++i) {
                ModelDepend second = (ModelDepend)arrayList.get(i);
                if (second.depend == null || !second.depend.contains(item.name)) continue;
                pos = i;
                break;
            }
            arrayList.add(pos, item);
        }
        ArrayList<ModelMap> arrayList2 = new ArrayList<ModelMap>();
        for (ModelDepend model : arrayList) {
            arrayList2.add(model.model);
        }
        this.orderedModels = arrayList2;
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs.put("orderedModels", this.orderedModels);
        this.generateJSONSpecFile(objs);
        List authMethods = (List)objs.get("authMethods");
        this.postProcessAuthMethod(authMethods, null);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        super.postProcessFile(file, fileType);
        if (file == null) {
            return;
        }
        String extension = FilenameUtils.getExtension((String)file.toString());
        if ("ads".equals(extension) || "adb".equals(extension)) {
            String commandPrefix = System.getenv("ADA_POST_PROCESS_FILE");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)commandPrefix)) {
                commandPrefix = "gnatpp";
            }
            try {
                Process p = Runtime.getRuntime().exec(new String[]{commandPrefix, "--no-compact", "--quiet", file.toString()});
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({} {}). Exit code: {}", new Object[]{commandPrefix, file, exitValue});
                } else {
                    this.LOGGER.debug("Successfully executed: {} {}", (Object)commandPrefix, (Object)file);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({} {}). Exception: {}", new Object[]{commandPrefix, file, e.getMessage()});
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.ADA;
    }

    private List<CodegenSecurity> postProcessAuthMethod(List<CodegenSecurity> authMethods, Map<String, List<String>> scopes) {
        ArrayList<CodegenSecurity> result;
        ArrayList<CodegenSecurity> arrayList = result = scopes == null ? null : new ArrayList<CodegenSecurity>();
        if (authMethods != null) {
            for (CodegenSecurity authMethod : authMethods) {
                if (authMethod.scopes != null) {
                    for (Map<String, Object> scope : authMethod.scopes) {
                        Object ident;
                        String name = (String)scope.get("scope");
                        if (this.operationsScopes.containsKey(name)) {
                            scope.put("ident", this.operationsScopes.get(name));
                            continue;
                        }
                        if (name.startsWith("https://")) {
                            int pos = name.lastIndexOf(47);
                            ident = name.substring(pos + 1);
                        } else {
                            ident = name;
                        }
                        ++this.scopeIndex;
                        ident = this.toAdaIdentifier(this.sanitizeName(((String)ident).replaceAll(":", "_")), "S_");
                        if (this.operationsScopes.containsValue(ident)) {
                            ident = (String)ident + "_" + this.scopeIndex;
                        }
                        this.operationsScopes.put(name, (String)ident);
                        scope.put("ident", ident);
                    }
                }
                List<String> opScopes = scopes == null ? null : scopes.get(authMethod.name);
                authMethod.name = StringUtils.camelize(this.sanitizeName(authMethod.name), CamelizeOption.LOWERCASE_FIRST_LETTER);
                if (opScopes == null) continue;
                CodegenSecurity opSecurity = authMethod.filterByScopeNames(opScopes);
                result.add(opSecurity);
            }
        }
        return result;
    }

    private boolean isStreamType(CodegenProperty parameter) {
        return parameter.isString || parameter.isBoolean || parameter.isDate || parameter.isDateTime || parameter.isInteger || parameter.isLong || parameter.isFreeFormObject && !parameter.isMap;
    }

    private boolean isModelType(CodegenProperty parameter) {
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        if (!(isModel || parameter.isPrimitiveType || parameter.isDate || parameter.isFreeFormObject || parameter.isString || parameter.isContainer || parameter.isFile || parameter.dataType.startsWith(this.openApiPackageName))) {
            isModel = true;
        }
        return isModel;
    }

    private boolean isStreamType(CodegenParameter parameter) {
        return parameter.isString || parameter.isBoolean || parameter.isDate || parameter.isDateTime || parameter.isInteger || parameter.isLong || parameter.isFreeFormObject && !parameter.isMap;
    }

    private boolean isModelType(CodegenParameter parameter) {
        boolean isModel = parameter.dataType.startsWith(this.modelPackage);
        if (!(isModel || parameter.isPrimitiveType || parameter.isDate || parameter.isFreeFormObject || parameter.isString || parameter.isContainer || parameter.isFile || parameter.dataType.startsWith(this.openApiPackageName))) {
            isModel = true;
        }
        return isModel;
    }

    private Map<String, List<String>> getAuthScopes(List<SecurityRequirement> securities, Map<String, SecurityScheme> securitySchemes) {
        HashMap<String, List<String>> scopes = new HashMap<String, List<String>>();
        Optional.ofNullable(securitySchemes).ifPresent(_securitySchemes -> {
            for (SecurityRequirement requirement : securities) {
                for (String key : requirement.keySet()) {
                    Optional.ofNullable((SecurityScheme)securitySchemes.get(key)).ifPresent(securityScheme -> scopes.put(key, (List)requirement.get((Object)key)));
                }
            }
        });
        return scopes;
    }

    private String useType(String name) {
        if (name == null) {
            return null;
        }
        int pos = name.lastIndexOf(46);
        if (pos <= 0) {
            return null;
        }
        String pkg = name.substring(0, pos);
        if (pkg.equals(this.modelPackage + ".Models")) {
            return null;
        }
        return pkg;
    }

    private boolean isMimetypeXml(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_XML) || mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_PROBLEM_XML) || mimetype.toLowerCase(Locale.ROOT).startsWith(TEXT_XML);
    }

    private boolean isMimetypeJson(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_JSON) || mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_MERGE_PATCH_JSON) || mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_PROBLEM_JSON);
    }

    private boolean isMimetypeWwwFormUrlEncoded(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_X_WWW_FORM_URLENCODED);
    }

    private boolean isMimetypeMultipartFormData(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/form-data");
    }

    private boolean isMimetypeOctetStream(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith(APPLICATION_OCTET_STREAM);
    }

    private boolean isMimetypeMultipartRelated(String mimetype) {
        return mimetype.toLowerCase(Locale.ROOT).startsWith("multipart/related");
    }

    private boolean isMimetypeUnknown(String mimetype) {
        return "*/*".equals(mimetype);
    }

    private boolean isMimetypePlain(String mimetype) {
        return !this.isMimetypeUnknown(mimetype) && !this.isMimetypeXml(mimetype) && !this.isMimetypeJson(mimetype) && !this.isMimetypeWwwFormUrlEncoded(mimetype) && !this.isMimetypeMultipartFormData(mimetype) && !this.isMimetypeMultipartRelated(mimetype);
    }

    private int collectMediaList(List<String> mediaList) {
        for (int i = 0; i < this.mediaGroups.size(); ++i) {
            if (!mediaList.equals(this.mediaGroups.get(i))) continue;
            return i + 1;
        }
        this.mediaGroups.add(mediaList);
        ArrayList<NameBinding> varList = new ArrayList<NameBinding>();
        int pos = 0;
        for (String media : mediaList) {
            Object varName = this.mediaToVariableName.get(media);
            if (varName == null) {
                varName = "Mime_" + (this.mediaVariables.size() + 1);
                this.mediaVariables.add(new NameBinding(this.mediaVariables.size() + 1, (String)varName, media));
                varName = (String)varName + "'Access";
            }
            varList.add(new NameBinding(++pos, (String)varName, media));
        }
        this.mediaLists.add(varList);
        return this.mediaGroups.size();
    }

    static class ModelDepend
    implements Comparable<ModelDepend> {
        final List<String> depend;
        final ModelMap model;
        final String name;

        ModelDepend(ModelMap model, List<String> depend, String name) {
            this.model = model;
            this.depend = depend;
            this.name = name;
        }

        @Override
        public int compareTo(ModelDepend second) {
            if (this.depend != null && this.depend.contains(second.name)) {
                return 1;
            }
            if (second.depend != null && second.depend.contains(this.name)) {
                return -1;
            }
            if (this.depend != null && this.depend.size() != (second.depend == null ? 0 : second.depend.size())) {
                return this.depend.size() - second.depend.size();
            }
            return this.name.compareTo(second.name);
        }
    }

    static class NameBinding {
        public int position;
        public String name;
        public String value;

        NameBinding(int pos, String name, String value) {
            this.position = pos;
            this.name = name;
            this.value = value;
        }
    }
}

