/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.languages.GoClientCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.model.WebhooksMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGoCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractGoCodegen.class);
    private static final String NUMERIC_ENUM_PREFIX = "_";
    protected boolean withGoCodegenComment = false;
    protected boolean withAWSV4Signature = false;
    protected boolean withXml = false;
    protected boolean enumClassPrefix = false;
    protected boolean structPrefix = false;
    protected boolean generateInterfaces = false;
    protected boolean withGoMod = false;
    protected boolean generateMarshalJSON = true;
    protected String packageName = "openapi";
    protected Set<String> numberTypes;

    public AbstractGoCodegen() {
        this.supportsInheritance = true;
        this.hideGenerationTimestamp = Boolean.FALSE;
        this.defaultIncludes = new HashSet<String>(Arrays.asList("map", "array"));
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "bool", "uint", "uint32", "uint64", "int", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "map[string]interface{}", "interface{}"));
        this.instantiationTypes.clear();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("number", "float32");
        this.typeMapping.put("float", "float32");
        this.typeMapping.put("double", "float64");
        this.typeMapping.put("decimal", "float64");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("URI", "string");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "time.Time");
        this.typeMapping.put("password", "string");
        this.typeMapping.put("File", "*os.File");
        this.typeMapping.put("file", "*os.File");
        this.typeMapping.put("binary", "*os.File");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("null", "nil");
        this.typeMapping.put("object", "map[string]interface{}");
        this.typeMapping.put("AnyType", "interface{}");
        this.numberTypes = new HashSet<String>(Arrays.asList("uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64"));
        this.apiNameSuffix = "API";
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "Go package name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption("packageVersion", "Go package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("GO_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable GO_POST_PROCESS_FILE not defined so Go code may not be properly formatted. To define it, try `export GO_POST_PROCESS_FILE=\"/usr/local/bin/gofmt -w\"` (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return StringUtils.camelize(name) + NUMERIC_ENUM_PREFIX;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if (((String)(name = this.sanitizeName((String)name))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize((String)name)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as variable name. Renamed to {}", name, (Object)this.escapeReservedWord((String)name));
            name = this.escapeReservedWord((String)name);
        }
        if (((String)name).matches("^\\d.*")) {
            name = "Var" + (String)name;
        }
        if ("AdditionalProperties".equals(name)) {
            return "AdditionalPropertiesField";
        }
        return name;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return word != null && (this.reservedWords.contains(word) || this.reservedWordsMappings().containsKey(word));
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if (this.isReservedWord((String)(name = StringUtils.camelize(this.toVarName((String)name), CamelizeOption.LOWERCASE_FIRST_LETTER)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as parameter name. Renamed to {}_", name, name);
            name = (String)name + NUMERIC_ENUM_PREFIX;
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        return StringUtils.camelize(this.toModel(name));
    }

    protected boolean isReservedFilename(String name) {
        String[] parts = name.split(NUMERIC_ENUM_PREFIX);
        String suffix = parts[parts.length - 1];
        HashSet<String> reservedSuffixes = new HashSet<String>(Arrays.asList("test", "aix", "android", "darwin", "dragonfly", "freebsd", "illumos", "js", "linux", "netbsd", "openbsd", "plan9", "solaris", "windows", "386", "amd64", "arm", "arm64", "mips", "mips64", "mips64le", "mipsle", "ppc64", "ppc64le", "s390x", "wasm"));
        return reservedSuffixes.contains(suffix);
    }

    @Override
    public String toModelFilename(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            name = (String)this.modelNameMapping.get(name);
        }
        if (this.isReservedFilename((String)(name = this.toModel("model_" + (String)name)))) {
            this.LOGGER.warn("{}.go with suffix (reserved word) cannot be used as filename. Renamed to {}_.go", name, name);
            name = (String)name + NUMERIC_ENUM_PREFIX;
        }
        return name;
    }

    public String toModel(String name) {
        return this.toModel(name, true);
    }

    public String toModel(String name, boolean doUnderscore) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + NUMERIC_ENUM_PREFIX + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + NUMERIC_ENUM_PREFIX + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)(name = this.sanitizeName((String)name)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (doUnderscore) {
            return StringUtils.underscore((String)name);
        }
        return name;
    }

    @Override
    public String toApiFilename(String name) {
        Object api = name.replaceAll("-", NUMERIC_ENUM_PREFIX);
        if (this.isReservedFilename((String)(api = "api_" + StringUtils.underscore((String)api)))) {
            this.LOGGER.warn("{}.go with suffix (reserved word) cannot be used as filename. Renamed to {}_.go", (Object)name, api);
            api = (String)api + NUMERIC_ENUM_PREFIX;
        }
        Object apiName = api;
        return apiName;
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + "_test";
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            if (inner != null) {
                inner = this.unaliasSchema(inner);
            }
            Object typDecl = inner != null ? this.getTypeDeclaration(inner) : "interface{}";
            if (inner != null && Boolean.TRUE.equals(inner.getNullable())) {
                typDecl = "*" + (String)typDecl;
            }
            return "[]" + (String)typDecl;
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "[string]" + this.getTypeDeclaration(this.unaliasSchema(inner));
        }
        String openAPIType = this.getSchemaType(p);
        String ref = p.get$ref();
        if (ref != null && !ref.isEmpty()) {
            String tryRefV2 = "#/definitions/" + openAPIType;
            String tryRefV3 = "#/components/schemas/" + openAPIType;
            if (ref.equals(tryRefV2) || ref.equals(tryRefV3)) {
                return this.toModelName(openAPIType);
            }
        }
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.typeMapping.containsValue(openAPIType)) {
            return openAPIType;
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        String ref = p.get$ref();
        if (ref != null && !ref.isEmpty()) {
            type = this.toModelName(openAPIType);
        } else if ("object".equals(openAPIType) && ModelUtils.isAnyType(p)) {
            type = "interface{}";
        } else if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return type;
    }

    @Override
    public String toInstantiationType(Schema property) {
        if (ModelUtils.isMapSchema(property)) {
            return this.getTypeDeclaration(property);
        }
        if (ModelUtils.isArraySchema(property)) {
            return this.getTypeDeclaration(property);
        }
        return super.toInstantiationType(property);
    }

    @Override
    public String toOperationId(String operationId) {
        Object sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord((String)sanitizedOperationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize("call_" + (String)sanitizedOperationId));
            sanitizedOperationId = "call_" + (String)sanitizedOperationId;
        }
        if (((String)sanitizedOperationId).matches("^\\d.*")) {
            this.LOGGER.warn("{} (starting with a number) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.camelize("call_" + (String)sanitizedOperationId));
            sanitizedOperationId = "call_" + (String)sanitizedOperationId;
        }
        return StringUtils.camelize((String)sanitizedOperationId);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            operation.httpMethod = StringUtils.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
        }
        List<Map<String, String>> imports = objs.getImports();
        if (imports == null) {
            return objs;
        }
        Iterator<Map<String, String>> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = iterator.next().get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "strings"));
            break;
        }
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        boolean addedReflectImport = false;
        for (CodegenOperation operation : operations) {
            if (!addedOSImport && "*os.File".equals(operation.returnType)) {
                imports.add(this.createMapping("import", "os"));
                addedOSImport = true;
            }
            for (CodegenParameter param : operation.allParams) {
                char nameFirstChar;
                if (!addedOSImport && "*os.File".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (!addedTimeImport && "time.Time".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (!addedReflectImport && param.isCollectionFormatMulti) {
                    imports.add(this.createMapping("import", "reflect"));
                    addedReflectImport = true;
                }
                if (Character.isUpperCase(nameFirstChar = param.paramName.charAt(0))) {
                    param.vendorExtensions.put("x-export-param-name", param.paramName);
                    continue;
                }
                StringBuilder sb = new StringBuilder(param.paramName);
                sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
                param.vendorExtensions.put("x-export-param-name", sb.toString());
            }
            this.setExportParameterName(operation.queryParams);
            this.setExportParameterName(operation.formParams);
            this.setExportParameterName(operation.headerParams);
            this.setExportParameterName(operation.bodyParams);
            this.setExportParameterName(operation.cookieParams);
            this.setExportParameterName(operation.optionalParams);
            this.setExportParameterName(operation.requiredParams);
        }
        List<Map<String, String>> recursiveImports = objs.getImports();
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = listIterator.next().get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    @Override
    public WebhooksMap postProcessWebhooksWithModels(WebhooksMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getWebhooks();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            operation.httpMethod = StringUtils.camelize(operation.httpMethod.toLowerCase(Locale.ROOT));
        }
        List<Map<String, String>> imports = objs.getImports();
        if (imports == null) {
            return objs;
        }
        Iterator<Map<String, String>> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = iterator.next().get("import");
            if (!_import.startsWith(this.apiPackage())) continue;
            iterator.remove();
        }
        for (CodegenOperation operation : operations) {
            if (operation.pathParams == null || operation.pathParams.size() <= 0) continue;
            imports.add(this.createMapping("import", "strings"));
            break;
        }
        boolean addedTimeImport = false;
        boolean addedOSImport = false;
        boolean addedReflectImport = false;
        for (CodegenOperation operation : operations) {
            if (!addedOSImport && "*os.File".equals(operation.returnType)) {
                imports.add(this.createMapping("import", "os"));
                addedOSImport = true;
            }
            for (CodegenParameter param : operation.allParams) {
                char nameFirstChar;
                if (!addedOSImport && "*os.File".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "os"));
                    addedOSImport = true;
                }
                if (!addedTimeImport && "time.Time".equals(param.dataType)) {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (!addedReflectImport && param.isCollectionFormatMulti) {
                    imports.add(this.createMapping("import", "reflect"));
                    addedReflectImport = true;
                }
                if (Character.isUpperCase(nameFirstChar = param.paramName.charAt(0))) {
                    param.vendorExtensions.put("x-export-param-name", param.paramName);
                    continue;
                }
                StringBuilder sb = new StringBuilder(param.paramName);
                sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
                param.vendorExtensions.put("x-export-param-name", sb.toString());
            }
            this.setExportParameterName(operation.queryParams);
            this.setExportParameterName(operation.formParams);
            this.setExportParameterName(operation.headerParams);
            this.setExportParameterName(operation.bodyParams);
            this.setExportParameterName(operation.cookieParams);
            this.setExportParameterName(operation.optionalParams);
            this.setExportParameterName(operation.requiredParams);
        }
        List<Map<String, String>> recursiveImports = objs.getImports();
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = listIterator.next().get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return objs;
    }

    private void setExportParameterName(List<CodegenParameter> codegenParameters) {
        for (CodegenParameter param : codegenParameters) {
            char nameFirstChar = param.paramName.charAt(0);
            if (Character.isUpperCase(nameFirstChar)) {
                param.vendorExtensions.put("x-export-param-name", param.paramName);
                continue;
            }
            StringBuilder sb = new StringBuilder(param.paramName);
            sb.setCharAt(0, Character.toUpperCase(nameFirstChar));
            param.vendorExtensions.put("x-export-param-name", sb.toString());
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        if (property.isContainer || property.isFreeFormObject || property.isAnyType && !property.isModel) {
            property.vendorExtensions.put("x-golang-is-container", true);
        }
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<Map<String, String>> imports = objs.getImports();
        String prefix = this.modelPackage();
        Iterator<Map<String, String>> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String _import = iterator.next().get("import");
            if (!_import.startsWith(prefix)) continue;
            iterator.remove();
        }
        for (ModelMap m : objs.getModels()) {
            boolean addedTimeImport = false;
            boolean addedOSImport = false;
            CodegenModel model = m.getModel();
            ArrayList<CodegenProperty> inheritedProperties = new ArrayList<CodegenProperty>();
            if (model.getComposedSchemas() != null) {
                if (model.getComposedSchemas().getAnyOf() != null) {
                    inheritedProperties.addAll(model.getComposedSchemas().getAnyOf());
                }
                if (model.getComposedSchemas().getOneOf() != null) {
                    inheritedProperties.addAll(model.getComposedSchemas().getOneOf());
                }
            }
            ArrayList<CodegenProperty> codegenProperties = new ArrayList<CodegenProperty>();
            if (model.getComposedSchemas() == null || model.getComposedSchemas() != null && model.getComposedSchemas().getAllOf() != null) {
                codegenProperties.addAll(model.vars);
            } else {
                codegenProperties.addAll(inheritedProperties);
            }
            for (CodegenProperty cp : codegenProperties) {
                if (!addedTimeImport && ("time.Time".equals(cp.dataType) || cp.items != null && "time.Time".equals(cp.items.dataType))) {
                    imports.add(this.createMapping("import", "time"));
                    addedTimeImport = true;
                }
                if (addedOSImport || !"*os.File".equals(cp.dataType) && (cp.items == null || !"*os.File".equals(cp.items.dataType))) continue;
                imports.add(this.createMapping("import", "os"));
                addedOSImport = true;
            }
            if (this instanceof GoClientCodegen && model.isEnum) {
                imports.add(this.createMapping("import", "fmt"));
            }
            if (model.oneOf != null && !model.oneOf.isEmpty() && model.oneOf.contains("nil")) {
                model.isNullable = true;
                model.oneOf.remove("nil");
            }
            if (model.anyOf != null && !model.anyOf.isEmpty() && model.anyOf.contains("nil")) {
                model.isNullable = true;
                model.anyOf.remove("nil");
            }
            if (!this.generateMarshalJSON) continue;
            model.vendorExtensions.put("x-go-generate-marshal-json", true);
        }
        List<Map<String, String>> recursiveImports = objs.getImports();
        if (recursiveImports == null) {
            return objs;
        }
        ListIterator<Map<String, String>> listIterator = imports.listIterator();
        while (listIterator.hasNext()) {
            String _import = listIterator.next().get("import");
            if (!this.importMapping.containsKey(_import)) continue;
            listIterator.add(this.createMapping("import", (String)this.importMapping.get(_import)));
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.defaultIncludes.contains(type) && !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if (this.isNumberType(datatype) || "bool".equals(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + NUMERIC_ENUM_PREFIX + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (this.enumNameMapping.containsKey(name)) {
            return (String)this.enumNameMapping.get(name);
        }
        if (name.length() == 0) {
            return "EMPTY";
        }
        if (this.isNumberType(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return NUMERIC_ENUM_PREFIX + varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", ""))) {
            return this.escapeReservedWord(enumName);
        }
        if (enumName.matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        if (this.enumNameMapping.containsKey(property.name)) {
            return (String)this.enumNameMapping.get(property.name);
        }
        String enumName = StringUtils.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return NUMERIC_ENUM_PREFIX + enumName;
        }
        return enumName;
    }

    public void setWithGoCodegenComment(boolean withGoCodegenComment) {
        this.withGoCodegenComment = withGoCodegenComment;
    }

    public void setWithAWSV4Signature(boolean withAWSV4Signature) {
        this.withAWSV4Signature = withAWSV4Signature;
    }

    public void setWithXml(boolean withXml) {
        this.withXml = withXml;
    }

    public void setEnumClassPrefix(boolean enumClassPrefix) {
        this.enumClassPrefix = enumClassPrefix;
    }

    public void setStructPrefix(boolean structPrefix) {
        this.structPrefix = structPrefix;
    }

    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    public void setWithGoMod(boolean withGoMod) {
        this.withGoMod = withGoMod;
    }

    public void setGenerateMarshalJSON(boolean generateMarshalJSON) {
        this.generateMarshalJSON = generateMarshalJSON;
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if ((schema = this.unaliasSchema(schema)).getDefault() != null) {
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String goPostProcessFile = System.getenv("GO_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)goPostProcessFile)) {
            return;
        }
        HashSet<String> supportedFileType = new HashSet<String>(Arrays.asList("supporting-mustache", "model-test", "model", "api-test", "api"));
        if (!supportedFileType.contains(fileType)) {
            return;
        }
        if ("go".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = goPostProcessFile + " " + file;
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit code: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: {}", (Object)command);
                }
            }
            catch (IOException | InterruptedException e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    protected boolean isNumberType(String datatype) {
        return this.numberTypes.contains(datatype);
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.GO;
    }
}

