/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractAdaCodegen;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;

public class AdaCodegen
extends AbstractAdaCodegen
implements CodegenConfig {
    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ada";
    }

    @Override
    public String getHelp() {
        return "Generates an Ada client implementation (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modifyFeatureSet(features -> features.excludeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.OAuth2_Password, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Implicit, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Header, ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath}));
        if (this.additionalProperties.containsKey("packageName")) {
            this.packageName = (String)this.additionalProperties.get("packageName");
        }
        if (StringUtils.isEmpty((CharSequence)this.packageName)) {
            this.packageName = this.modelPackage;
        }
        String srcPrefix = "src" + File.separator;
        String modelPrefix = srcPrefix + "model" + File.separator + this.toFilename(this.modelPackage);
        String clientPrefix = srcPrefix + "client" + File.separator + this.toFilename(this.modelPackage);
        this.supportingFiles.add(new SupportingFile("model-spec.mustache", "", modelPrefix + "-models.ads"));
        this.supportingFiles.add(new SupportingFile("model-body.mustache", "", modelPrefix + "-models.adb"));
        this.supportingFiles.add(new SupportingFile("client-spec.mustache", "", clientPrefix + "-clients.ads"));
        this.supportingFiles.add(new SupportingFile("client-body.mustache", "", clientPrefix + "-clients.adb"));
        this.projectName = this.additionalProperties.containsKey("projectName") ? (String)this.additionalProperties.get("projectName") : this.packageName.replaceAll("\\.", "_");
        String configBaseName = this.modelPackage.toLowerCase(Locale.ROOT);
        this.supportingFiles.add(new SupportingFile("gnat-project.mustache", "", this.toFilename(this.projectName) + ".gpr"));
        this.supportingFiles.add(new SupportingFile("config.gpr", "", "config.gpr"));
        this.additionalProperties.put("package", this.modelPackage);
        this.additionalProperties.put("packageConfig", configBaseName);
        this.additionalProperties.put("packageDir", "client");
        this.additionalProperties.put("mainName", "client");
        this.additionalProperties.put("isServer", false);
        this.additionalProperties.put("httpClientPackageName", this.httpClientPackageName);
        this.additionalProperties.put("openApiPackageName", this.openApiPackageName);
        this.additionalProperties.put("projectName", this.projectName);
        String[] names = this.modelPackage.split("\\.");
        Object pkgName = names[0];
        this.additionalProperties.put("packageLevel1", pkgName);
        this.supportingFiles.add(new SupportingFile("package-spec-level1.mustache", "", "src" + File.separator + this.toFilename(names[0]) + ".ads"));
        if (names.length > 1) {
            String fileName = this.toFilename(names[0]) + "-" + this.toFilename(names[1]) + ".ads";
            pkgName = names[0] + "." + names[1];
            this.additionalProperties.put("packageLevel2", pkgName);
            this.supportingFiles.add(new SupportingFile("package-spec-level2.mustache", "", "src" + File.separator + fileName));
        }
        pkgName = this.modelPackage;
        this.supportingFiles.add(new SupportingFile("client.mustache", "", "src" + File.separator + this.toFilename((String)pkgName) + "-client.adb"));
        this.additionalProperties.put("packageName", this.toFilename((String)pkgName));
        this.additionalProperties.put("lambdaAdaComment", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replaceAll("\n$", "");
                writer.write(content.replaceAll("\n", "\n   --  "));
            }
        });
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "model" + File.separator + this.modelPackage().replace('.', File.separatorChar);
    }
}

