/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.annotations.VisibleForTesting;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaJAXRSServerCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures {
    public static final String SERVER_PORT = "serverPort";
    public static final String USE_TAGS = "useTags";
    protected static final String JAXRS_TEMPLATE_DIRECTORY_NAME = "JavaJaxRS";
    protected static final String X_MICROPROFILE_OPEN_API_RETURN_SCHEMA_CONTAINER = "x-microprofile-open-api-return-schema-container";
    protected static final String X_MICROPROFILE_OPEN_API_RETURN_UNIQUE_ITEMS = "x-microprofile-open-api-return-unique-items";
    protected static final String X_MICROPROFILE_OPEN_API_SCHEMA_TYPE = "x-microprofile-open-api-schema-type";
    protected static final String SCHEMA_TYPE_ARRAY = "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.ARRAY";
    protected static final Map<String, String> ARRAY_OF_MICROPROFILE_OPEN_API_SCHEMA_TYPES;
    protected String implFolder = "src/main/java";
    protected String testResourcesFolder = "src/test/resources";
    protected String title = "OpenAPI Server";
    protected String serverPort = "8080";
    protected boolean useBeanValidation = true;
    protected boolean useTags = false;
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaJAXRSServerCodegen.class);

    public AbstractJavaJAXRSServerCodegen() {
        this.sourceFolder = "src/gen/java";
        this.invokerPackage = "org.openapitools.api";
        this.artifactId = "openapi-jaxrs-server";
        this.dateLibrary = "legacy";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.updateOption("dateLibrary", this.getDateLibrary());
        this.updateOption("sourceFolder", this.getSourceFolder());
        this.additionalProperties.put("title", this.title);
        this.additionalProperties.put("jackson", "true");
        this.cliOptions.add(new CliOption("implFolder", "folder for generated implementation code").defaultValue(this.implFolder));
        this.cliOptions.add(new CliOption("title", "a title describing the application").defaultValue(this.title));
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use BeanValidation API annotations", this.useBeanValidation));
        this.cliOptions.add(new CliOption(SERVER_PORT, "The port on which the server should be started").defaultValue(this.serverPort));
        this.cliOptions.add(CliOption.newBoolean(USE_TAGS, "use tags for creating interface and controller classnames"));
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("implFolder")) {
            this.implFolder = (String)this.additionalProperties.get("implFolder");
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        if (this.additionalProperties.containsKey(USE_TAGS)) {
            this.setUseTags(this.convertPropertyToBoolean(USE_TAGS));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
    }

    @Override
    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        String basePath = StringUtils.substringBefore((String)StringUtils.removeStart((String)resourcePath, (String)"/"), (String)"/");
        if (!StringUtils.isEmpty((CharSequence)basePath)) {
            boolean bl = co.subresourceOperation = !co.path.isEmpty();
        }
        if (this.useTags) {
            super.addOperationToGroup(tag, resourcePath, operation, co, operations);
        } else {
            co.baseName = basePath;
            if (StringUtils.isEmpty((CharSequence)co.baseName) || StringUtils.containsAny((CharSequence)co.baseName, (CharSequence[])new CharSequence[]{"{", "}"})) {
                co.baseName = "default";
            }
            List opList = operations.computeIfAbsent(co.baseName, k -> new ArrayList());
            opList.add(co);
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (!this.additionalProperties.containsKey(SERVER_PORT)) {
            URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
            this.additionalProperties.put(SERVER_PORT, URLPathUtils.getPort(url, this.serverPort));
        }
        if (openAPI.getPaths() != null) {
            for (Map.Entry openAPIGetPathsEntry : openAPI.getPaths().entrySet()) {
                String pathname = (String)openAPIGetPathsEntry.getKey();
                PathItem path = (PathItem)openAPIGetPathsEntry.getValue();
                if (path.readOperations() == null) continue;
                for (Operation operation : path.readOperations()) {
                    if (operation.getTags() == null) continue;
                    ArrayList tags = new ArrayList();
                    for (String tag : operation.getTags()) {
                        HashMap<String, String> value = new HashMap<String, String>();
                        value.put("tag", tag);
                        tags.add(value);
                    }
                    if (operation.getTags().size() > 0) {
                        String tag = (String)operation.getTags().get(0);
                        operation.setTags(Arrays.asList(tag));
                    }
                    operation.addExtension("x-tags", tags);
                }
            }
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationsMap updatedObjs = AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
        OperationMap operations = updatedObjs.getOperations();
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation co : ops) {
                this.handleImplicitHeaders(co);
            }
        }
        return updatedObjs;
    }

    static OperationsMap jaxrsPostProcessOperations(OperationsMap objs) {
        OperationMap operations = objs.getOperations();
        String commonPath = null;
        if (operations != null) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                Map<String, String> firstType;
                if (operation.hasConsumes == Boolean.TRUE && (firstType = operation.consumes.get(0)) != null && "multipart/form-data".equals(firstType.get("mediaType"))) {
                    operation.isMultipart = Boolean.TRUE;
                }
                boolean isMultipartPost = false;
                List<Map<String, String>> consumes = operation.consumes;
                if (consumes != null) {
                    for (Map map : consumes) {
                        String mt = (String)map.get("mediaType");
                        if (mt == null || !mt.startsWith("multipart/form-data")) continue;
                        isMultipartPost = true;
                    }
                }
                for (CodegenParameter codegenParameter : operation.allParams) {
                    if (!isMultipartPost) continue;
                    codegenParameter.vendorExtensions.put("x-multipart", "true");
                }
                List<CodegenResponse> responses = operation.responses;
                if (responses != null) {
                    for (CodegenResponse resp : responses) {
                        if ("0".equals(resp.code)) {
                            resp.code = "200";
                        }
                        if (resp.baseType == null) {
                            resp.dataType = "void";
                            resp.baseType = "Void";
                            resp.vendorExtensions.put("x-java-is-response-void", true);
                        }
                        if ("array".equals(resp.containerType)) {
                            resp.containerType = "List";
                            resp.vendorExtensions.put(X_MICROPROFILE_OPEN_API_RETURN_SCHEMA_CONTAINER, SCHEMA_TYPE_ARRAY);
                        } else if ("set".equals(resp.containerType)) {
                            resp.containerType = "Set";
                            resp.vendorExtensions.put(X_MICROPROFILE_OPEN_API_RETURN_SCHEMA_CONTAINER, SCHEMA_TYPE_ARRAY);
                            resp.vendorExtensions.put(X_MICROPROFILE_OPEN_API_RETURN_UNIQUE_ITEMS, true);
                        } else if ("map".equals(resp.containerType)) {
                            resp.containerType = "Map";
                        }
                        if (resp.getResponseHeaders() == null) continue;
                        AbstractJavaJAXRSServerCodegen.handleHeaders(resp.getResponseHeaders());
                    }
                }
                if (operation.returnBaseType == null) {
                    operation.returnType = "void";
                    operation.returnBaseType = "Void";
                    operation.vendorExtensions.put("x-java-is-response-void", true);
                }
                if ("array".equals(operation.returnContainer)) {
                    operation.returnContainer = "List";
                } else if ("set".equals(operation.returnContainer)) {
                    operation.returnContainer = "Set";
                } else if ("map".equals(operation.returnContainer)) {
                    operation.returnContainer = "Map";
                }
                if (commonPath == null) {
                    commonPath = operation.path;
                    continue;
                }
                commonPath = AbstractJavaJAXRSServerCodegen.getCommonPath(commonPath, operation.path);
            }
            for (CodegenOperation co : ops) {
                co.path = StringUtils.removeStart((String)co.path, commonPath);
                co.subresourceOperation = co.path.length() > 1;
            }
            objs.put("commonPath", "/".equals(commonPath) ? "" : commonPath);
        }
        return objs;
    }

    private static void handleHeaders(List<CodegenParameter> headers) {
        for (CodegenParameter header : headers) {
            String schemaType;
            if (header.getSchema() == null || header.getSchema().getOpenApiType() == null || (schemaType = ARRAY_OF_MICROPROFILE_OPEN_API_SCHEMA_TYPES.get(header.getSchema().getOpenApiType())) == null) continue;
            header.vendorExtensions.put(X_MICROPROFILE_OPEN_API_SCHEMA_TYPE, schemaType);
        }
    }

    @Override
    public String toApiName(String name) {
        String computed = name;
        if (computed.length() > 0) {
            computed = this.sanitizeName(computed);
        }
        return super.toApiName(computed);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        Object result = super.apiFilename(templateName, tag);
        if (templateName.endsWith("Impl.mustache")) {
            int ix = ((String)result).lastIndexOf(File.separator);
            result = ((String)result).substring(0, ix) + "/impl" + ((String)result).substring(ix, ((String)result).length() - 5) + "ServiceImpl.java";
            result = ((String)result).replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Factory.mustache")) {
            int ix = ((String)result).lastIndexOf(File.separator);
            result = ((String)result).substring(0, ix) + "/factories" + ((String)result).substring(ix, ((String)result).length() - 5) + "ServiceFactory.java";
            result = ((String)result).replace(this.apiFileFolder(), this.implFileFolder(this.implFolder));
        } else if (templateName.endsWith("Service.mustache")) {
            int ix = ((String)result).lastIndexOf(46);
            result = ((String)result).substring(0, ix) + "Service.java";
        }
        return result;
    }

    private static String getCommonPath(String path1, String path2) {
        String[] parts1 = StringUtils.split((String)path1, (String)"/");
        String[] parts2 = StringUtils.split((String)path2, (String)"/");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < Math.min(parts1.length, parts2.length) && parts1[i].equals(parts2[i]); ++i) {
            builder.append("/").append(parts1[i]);
        }
        return builder.toString();
    }

    private String implFileFolder(String output) {
        return this.outputFolder + "/" + output + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @VisibleForTesting
    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    static {
        HashMap<String, String> schemaTypes = new HashMap<String, String>();
        schemaTypes.put("integer", "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.INTEGER");
        schemaTypes.put("number", "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.NUMBER");
        schemaTypes.put("boolean", "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.BOOLEAN");
        schemaTypes.put("string", "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.STRING");
        schemaTypes.put("object", "org.eclipse.microprofile.openapi.annotations.enums.SchemaType.OBJECT");
        schemaTypes.put("array", SCHEMA_TYPE_ARRAY);
        ARRAY_OF_MICROPROFILE_OPEN_API_SCHEMA_TYPES = Collections.unmodifiableMap(schemaTypes);
    }
}

