/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.AbstractDartCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartDioNextClientCodegen
extends AbstractDartCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(DartDioNextClientCodegen.class);
    public static final String DATE_LIBRARY = "dateLibrary";
    public static final String DATE_LIBRARY_CORE = "core";
    public static final String DATE_LIBRARY_TIME_MACHINE = "timemachine";
    public static final String DATE_LIBRARY_DEFAULT = "core";
    public static final String SERIALIZATION_LIBRARY_BUILT_VALUE = "built_value";
    public static final String SERIALIZATION_LIBRARY_DEFAULT = "built_value";
    private static final String DIO_IMPORT = "package:dio/dio.dart";
    private static final String CLIENT_NAME = "clientName";
    private String dateLibrary;
    private String clientName;

    public DartDioNextClientCodegen() {
        this.modifyFeatureSet(features -> features.includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.Authorizations, ClientModificationFeature.UserAgent}));
        this.generatorMetadata = GeneratorMetadata.newBuilder().stability(Stability.EXPERIMENTAL).build();
        this.outputFolder = "generated-code/dart-dio-next";
        this.embeddedTemplateDir = "dart/libraries/dio";
        this.setTemplateDir(this.embeddedTemplateDir);
        this.apiPackage = "lib.src.api";
        this.modelPackage = "lib.src.model";
        this.supportedLibraries.put("built_value", "[DEFAULT] built_value");
        CliOption serializationLibrary = CliOption.newString("serializationLibrary", "Specify serialization library");
        serializationLibrary.setEnum(this.supportedLibraries);
        serializationLibrary.setDefault("built_value");
        this.cliOptions.add(serializationLibrary);
        CliOption dateOption = CliOption.newString(DATE_LIBRARY, "Specify Date library");
        dateOption.setDefault("core");
        HashMap<String, String> dateOptions = new HashMap<String, String>();
        dateOptions.put("core", "[DEFAULT] Dart core library (DateTime)");
        dateOptions.put(DATE_LIBRARY_TIME_MACHINE, "Time Machine is date and time library for Flutter, Web, and Server with support for timezones, calendars, cultures, formatting and parsing.");
        dateOption.setEnum(dateOptions);
        this.cliOptions.add(dateOption);
    }

    public String getDateLibrary() {
        return this.dateLibrary;
    }

    public void setDateLibrary(String library) {
        this.dateLibrary = library;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    @Override
    public String getName() {
        return "dart-dio-next";
    }

    @Override
    public String getHelp() {
        return "Generates a Dart Dio client library with null-safety.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("DART_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable DART_POST_PROCESS_FILE not defined so the Dart code may not be properly formatted. To define it, try `export DART_POST_PROCESS_FILE=\"/usr/local/bin/dartfmt -w\"` (Linux/Mac)");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (!this.additionalProperties.containsKey("serializationLibrary")) {
            this.additionalProperties.put("serializationLibrary", "built_value");
            this.LOGGER.debug("Serialization library not set, using default {}", (Object)"built_value");
        }
        this.setLibrary(this.additionalProperties.get("serializationLibrary").toString());
        if (!this.additionalProperties.containsKey(DATE_LIBRARY)) {
            this.additionalProperties.put(DATE_LIBRARY, "core");
            this.LOGGER.debug("Date library not set, using default {}", (Object)"core");
        }
        this.setDateLibrary(this.additionalProperties.get(DATE_LIBRARY).toString());
        if (!this.additionalProperties.containsKey(CLIENT_NAME)) {
            String name = StringUtils.camelize(this.pubName);
            this.additionalProperties.put(CLIENT_NAME, name);
            this.LOGGER.debug("Client name not set, using default {}", (Object)"core");
        }
        this.setClientName(this.additionalProperties.get(CLIENT_NAME).toString());
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", "analysis_options.yaml"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("lib.mustache", libFolder, this.pubName + ".dart"));
        String srcFolder = libFolder + File.separator + "src";
        this.supportingFiles.add(new SupportingFile("api_client.mustache", srcFolder, "api.dart"));
        String authFolder = srcFolder + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/basic_auth.mustache", authFolder, "basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/bearer_auth.mustache", authFolder, "bearer_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/auth.mustache", authFolder, "auth.dart"));
        this.configureSerializationLibrary(srcFolder);
        this.configureDateLibrary(srcFolder);
    }

    private void configureSerializationLibrary(String srcFolder) {
        switch (this.library) {
            default: 
        }
        this.additionalProperties.put("useBuiltValue", "true");
        this.configureSerializationLibraryBuiltValue(srcFolder);
    }

    private void configureSerializationLibraryBuiltValue(String srcFolder) {
        this.supportingFiles.add(new SupportingFile("serialization/built_value/serializers.mustache", srcFolder, "serializers.dart"));
        this.supportingFiles.add(new SupportingFile("serialization/built_value/api_util.mustache", srcFolder, "api_util.dart"));
        this.typeMapping.put("Array", "BuiltList");
        this.typeMapping.put("array", "BuiltList");
        this.typeMapping.put("List", "BuiltList");
        this.typeMapping.put("set", "BuiltSet");
        this.typeMapping.put("map", "BuiltMap");
        this.typeMapping.put("file", "Uint8List");
        this.typeMapping.put("binary", "Uint8List");
        this.typeMapping.put("object", "JsonObject");
        this.typeMapping.put("AnyType", "JsonObject");
        this.imports.put("BuiltList", "package:built_collection/built_collection.dart");
        this.imports.put("BuiltSet", "package:built_collection/built_collection.dart");
        this.imports.put("BuiltMap", "package:built_collection/built_collection.dart");
        this.imports.put("JsonObject", "package:built_value/json_object.dart");
        this.imports.put("Uint8List", "dart:typed_data");
        this.imports.put("MultipartFile", DIO_IMPORT);
    }

    private void configureDateLibrary(String srcFolder) {
        switch (this.dateLibrary) {
            case "timemachine": {
                this.additionalProperties.put("useDateLibTimeMachine", "true");
                this.typeMapping.put("date", "OffsetDate");
                this.typeMapping.put("Date", "OffsetDate");
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("datetime", "OffsetDateTime");
                this.imports.put("OffsetDate", "package:time_machine/time_machine.dart");
                this.imports.put("OffsetDateTime", "package:time_machine/time_machine.dart");
                if (!"built_value".equals(this.library)) break;
                this.supportingFiles.add(new SupportingFile("serialization/built_value/offset_date_serializer.mustache", srcFolder, "local_date_serializer.dart"));
                break;
            }
            default: {
                this.additionalProperties.put("useDateLibCore", "true");
                if (!"built_value".equals(this.library)) break;
                this.typeMapping.put("date", "Date");
                this.typeMapping.put("Date", "Date");
                this.importMapping.put("Date", "package:" + this.pubName + "/src/model/date.dart");
                this.supportingFiles.add(new SupportingFile("serialization/built_value/date.mustache", srcFolder + File.separator + "model", "date.dart"));
                this.supportingFiles.add(new SupportingFile("serialization/built_value/date_serializer.mustache", srcFolder, "date_serializer.dart"));
            }
        }
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema.getDefault() != null) {
            if ("built_value".equals(this.library)) {
                if (ModelUtils.isArraySchema(schema)) {
                    if (ModelUtils.isSet(schema)) {
                        return "SetBuilder()";
                    }
                    return "ListBuilder()";
                }
                if (ModelUtils.isMapSchema(schema)) {
                    return "MapBuilder()";
                }
            }
            if (ModelUtils.isDateSchema(schema) || ModelUtils.isDateTimeSchema(schema)) {
                return null;
            }
            if (ModelUtils.isStringSchema(schema)) {
                return "'" + schema.getDefault().toString().replaceAll("'", "\\'") + "'";
            }
            return schema.getDefault().toString();
        }
        return null;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs = super.postProcessModels(objs);
        List<ModelMap> models = objs.getModels();
        ProcessUtils.addIndexToProperties(models, 1);
        for (ModelMap mo : models) {
            CodegenModel cm = mo.getModel();
            cm.imports = this.rewriteImports(cm.imports, true);
            cm.vendorExtensions.put("x-has-vars", !cm.vars.isEmpty());
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if ("built_value".equals(this.library)) {
            CodegenProperty items;
            if (property.isEnum) {
                model.imports.add("BuiltSet");
            }
            if (property.isContainer && (items = property.items).getAdditionalProperties() != null) {
                this.addBuiltValueSerializer(new BuiltValueSerializer(items.isArray, items.getUniqueItems(), items.isMap, items.items.isNullable, items.getAdditionalProperties().dataType));
            }
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<ModelMap> allModels) {
        super.postProcessOperationsWithModels(objs, allModels);
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        HashSet<String> resultImports = new HashSet<String>();
        for (CodegenOperation op : operationList) {
            for (CodegenParameter param2 : op.allParams) {
                if ((!op.isMultipart || !param2.isFormParam) && !param2.isBodyParam || !param2.isBinary && !param2.isFile) continue;
                param2.dataType = param2.dataType.replace("Uint8List", "MultipartFile");
                param2.baseType = param2.baseType.replace("Uint8List", "MultipartFile");
                op.imports.add("MultipartFile");
                if (!"built_value".equals(this.library)) continue;
                boolean skipFormModel = Boolean.parseBoolean(GlobalSettings.getProperty("skipFormModel", "true"));
                if (!param2.isFormParam || !param2.isContainer || skipFormModel) continue;
                this.addBuiltValueSerializerImport("Uint8List");
            }
            if (op.allParams.stream().noneMatch(param -> param.dataType.equals("Uint8List")) && op.responses.stream().filter(response -> response.dataType != null).noneMatch(response -> response.dataType.equals("Uint8List"))) {
                op.imports.remove("Uint8List");
            }
            for (CodegenParameter param2 : op.allParams) {
                if (!param2.isContainer || param2.isBinary || param2.isFile) continue;
                this.addBuiltValueSerializer(new BuiltValueSerializer(param2.isArray, param2.uniqueItems, param2.isMap, param2.items.isNullable, param2.baseType));
            }
            resultImports.addAll(this.rewriteImports(op.imports, false));
            if (op.getHasFormParams() || op.getHasQueryParams()) {
                resultImports.add("package:" + this.pubName + "/src/api_util.dart");
            }
            if (op.returnContainer == null || op.isResponseBinary || op.isResponseFile) continue;
            this.addBuiltValueSerializer(new BuiltValueSerializer(Objects.equals("array", op.returnContainer) || Objects.equals("set", op.returnContainer), op.uniqueItems, Objects.equals("map", op.returnContainer), false, op.returnBaseType));
        }
        objs.put("imports", resultImports.stream().sorted().collect(Collectors.toList()));
        return objs;
    }

    private void addBuiltValueSerializerImport(String type) {
        this.additionalProperties.compute("builtValueSerializerImports", (k, v) -> {
            Set<String> imports = v == null ? Sets.newHashSet() : (Set)v;
            imports.addAll(this.rewriteImports(Sets.newHashSet((Object[])new String[]{type}), true));
            return imports;
        });
    }

    private void addBuiltValueSerializer(BuiltValueSerializer serializer) {
        this.additionalProperties.compute("builtValueSerializers", (k, v) -> {
            Set<BuiltValueSerializer> serializers = v == null ? Sets.newHashSet() : (Set)v;
            serializers.add(serializer);
            return serializers;
        });
    }

    private Set<String> rewriteImports(Set<String> originalImports, boolean isModel) {
        HashSet resultImports = Sets.newHashSet();
        for (String modelImport : originalImports) {
            if (this.imports.containsKey(modelImport)) {
                String i = (String)this.imports.get(modelImport);
                if (Objects.equals(i, DIO_IMPORT) && !isModel) continue;
                resultImports.add(i);
                continue;
            }
            if (this.importMapping().containsKey(modelImport)) {
                resultImports.add(this.importMapping().get(modelImport));
                continue;
            }
            resultImports.add("package:" + this.pubName + "/src/model/" + StringUtils.underscore(modelImport) + ".dart");
        }
        return resultImports;
    }

    static class BuiltValueSerializer {
        final boolean isArray;
        final boolean uniqueItems;
        final boolean isMap;
        final boolean isNullable;
        final String dataType;

        private BuiltValueSerializer(boolean isArray, boolean uniqueItems, boolean isMap, boolean isNullable, String dataType) {
            this.isArray = isArray;
            this.uniqueItems = uniqueItems;
            this.isMap = isMap;
            this.isNullable = isNullable;
            this.dataType = dataType;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public boolean isUniqueItems() {
            return this.uniqueItems;
        }

        public boolean isMap() {
            return this.isMap;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        public String getDataType() {
            return this.dataType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuiltValueSerializer that = (BuiltValueSerializer)o;
            return this.isArray == that.isArray && this.uniqueItems == that.uniqueItems && this.isMap == that.isMap && this.isNullable == that.isNullable && this.dataType.equals(that.dataType);
        }

        public int hashCode() {
            return Objects.hash(this.isArray, this.uniqueItems, this.isMap, this.isNullable, this.dataType);
        }
    }
}

