/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhpSlim4ServerCodegen
extends AbstractPhpCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(PhpSlim4ServerCodegen.class);
    public static final String USER_CLASSNAME_KEY = "userClassname";
    public static final String PSR7_IMPLEMENTATION = "psr7Implementation";
    protected String groupId = "org.openapitools";
    protected String artifactId = "openapi-server";
    protected String authDirName = "Auth";
    protected String authPackage = "";
    protected String psr7Implementation = "slim-psr7";
    protected String interfacesDirName = "Interfaces";
    protected String interfacesPackage = "";

    public PhpSlim4ServerCodegen() {
        this.testBasePath = "tests";
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.MockServer}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.importMapping.clear();
        this.variableNamingConvention = "camelCase";
        this.artifactVersion = "1.0.0";
        this.setInvokerPackage("OpenAPIServer");
        this.apiPackage = this.invokerPackage + "\\" + this.apiDirName;
        this.modelPackage = this.invokerPackage + "\\" + this.modelDirName;
        this.authPackage = this.invokerPackage + "\\" + this.authDirName;
        this.interfacesPackage = this.invokerPackage + "\\" + this.interfacesDirName;
        this.outputFolder = "generated-code" + File.separator + "slim4";
        this.modelTestTemplateFiles.put("model_test.mustache", ".php");
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.templateDir = "php-slim4-server";
        this.embeddedTemplateDir = "php-slim4-server";
        this.additionalProperties.put("groupId", this.groupId);
        this.additionalProperties.put("artifactId", this.artifactId);
        this.updateOption("variableNamingConvention", "camelCase");
        CliOption psr7Option = new CliOption(PSR7_IMPLEMENTATION, "Slim 4 provides its own PSR-7 implementation so that it works out of the box. However, you are free to replace Slim\u2019s default PSR-7 objects with a third-party implementation. Ref: https://www.slimframework.com/docs/v4/concepts/value-objects.html");
        psr7Option.addEnum("slim-psr7", "Slim PSR-7 Message implementation").addEnum("nyholm-psr7", "Nyholm PSR-7 Message implementation").addEnum("guzzle-psr7", "Guzzle PSR-7 Message implementation").addEnum("zend-diactoros", "Zend Diactoros PSR-7 Message implementation").setDefault("slim-psr7");
        this.cliOptions.add(psr7Option);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-slim4";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP Slim 4 Framework server library(with Mock server).";
    }

    @Override
    public String apiFileFolder() {
        if (this.apiPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.apiPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.apiPackage, this.srcBasePath);
    }

    @Override
    public String modelFileFolder() {
        if (this.modelPackage.startsWith(this.invokerPackage + "\\")) {
            return this.outputFolder + File.separator + this.toSrcPath(org.apache.commons.lang3.StringUtils.removeStart((String)this.modelPackage, (String)(this.invokerPackage + "\\")), this.srcBasePath);
        }
        return this.outputFolder + File.separator + this.toSrcPath(this.modelPackage, this.srcBasePath);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        Boolean generateModels = this.additionalProperties.containsKey("generateModels") && Boolean.TRUE.equals(this.additionalProperties.get("generateModels"));
        Boolean generateApiTests = this.additionalProperties.containsKey("generateApiTests") && Boolean.TRUE.equals(this.additionalProperties.get("generateApiTests"));
        Boolean generateModelTests = this.additionalProperties.containsKey("generateModelTests") && Boolean.TRUE.equals(this.additionalProperties.get("generateModelTests"));
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.authPackage = this.invokerPackage + "\\" + this.authDirName;
            this.interfacesPackage = this.invokerPackage + "\\" + this.interfacesDirName;
        }
        this.additionalProperties.put("authPackage", this.authPackage);
        this.additionalProperties.put("authSrcPath", "./" + this.toSrcPath(this.authPackage, this.srcBasePath));
        this.additionalProperties.put("interfacesPackage", this.interfacesPackage);
        this.additionalProperties.put("interfacesSrcPath", "./" + this.toSrcPath(this.interfacesPackage, this.srcBasePath));
        this.additionalProperties.put("interfacesTestPath", "./" + this.toSrcPath(this.interfacesPackage, this.testBasePath));
        if (this.additionalProperties.containsKey(PSR7_IMPLEMENTATION)) {
            this.setPsr7Implementation((String)this.additionalProperties.get(PSR7_IMPLEMENTATION));
        }
        this.additionalProperties.put("isSlimPsr7", Boolean.FALSE);
        this.additionalProperties.put("isNyholmPsr7", Boolean.FALSE);
        this.additionalProperties.put("isGuzzlePsr7", Boolean.FALSE);
        this.additionalProperties.put("isZendDiactoros", Boolean.FALSE);
        switch (this.getPsr7Implementation()) {
            case "slim-psr7": {
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
                break;
            }
            case "nyholm-psr7": {
                this.additionalProperties.put("isNyholmPsr7", Boolean.TRUE);
                break;
            }
            case "guzzle-psr7": {
                this.additionalProperties.put("isGuzzlePsr7", Boolean.TRUE);
                break;
            }
            case "zend-diactoros": {
                this.additionalProperties.put("isZendDiactoros", Boolean.TRUE);
                break;
            }
            default: {
                this.LOGGER.warn("\"{}\" is invalid \"psr7Implementation\" codegen option. Default \"slim-psr7\" used instead.", (Object)this.getPsr7Implementation());
                this.additionalProperties.put("isSlimPsr7", Boolean.TRUE);
            }
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("composer.mustache", "", "composer.json"));
        this.supportingFiles.add(new SupportingFile("index.mustache", "public", "index.php"));
        this.supportingFiles.add(new SupportingFile(".htaccess", "public", ".htaccess"));
        this.supportingFiles.add(new SupportingFile("SlimRouter.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "SlimRouter.php"));
        if (Boolean.TRUE.equals(generateApiTests) || Boolean.TRUE.equals(generateModelTests)) {
            this.supportingFiles.add(new SupportingFile("phpunit.xml.mustache", "", "phpunit.xml.dist"));
            this.additionalProperties.put("generateTests", Boolean.TRUE);
        }
        this.supportingFiles.add(new SupportingFile("phpcs.xml.mustache", "", "phpcs.xml.dist"));
        this.supportingFiles.add(new SupportingFile("htaccess_deny_all", "config", ".htaccess"));
        this.supportingFiles.add(new SupportingFile("config_example.mustache", "config" + File.separator + "dev", "example.inc.php"));
        this.supportingFiles.add(new SupportingFile("config_example.mustache", "config" + File.separator + "prod", "example.inc.php"));
        if (Boolean.TRUE.equals(generateModels)) {
            this.supportingFiles.add(new SupportingFile("base_model.mustache", this.toSrcPath(this.invokerPackage, this.srcBasePath), "BaseModel.php"));
        }
        if (Boolean.TRUE.equals(generateModelTests)) {
            this.supportingFiles.add(new SupportingFile("base_model_test.mustache", this.toSrcPath(this.invokerPackage, this.testBasePath), "BaseModelTest.php"));
        }
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        this.addUserClassnameToOperations(operations);
        this.escapeMediaType(operationList);
        return objs;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Map apiInfo = (Map)objs.get("apiInfo");
        List apiList = (List)apiInfo.get("apis");
        for (HashMap api : apiList) {
            HashMap operations = (HashMap)api.get("operations");
            List operationList = (List)operations.get("operation");
            Collections.sort(operationList, new Comparator<CodegenOperation>(){

                @Override
                public int compare(CodegenOperation one, CodegenOperation another) {
                    if (one.getHasPathParams() && !another.getHasPathParams()) {
                        return 1;
                    }
                    if (!one.getHasPathParams() && another.getHasPathParams()) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        if (objs.containsKey("hasAuthMethods") && Boolean.TRUE.equals(objs.get("hasAuthMethods"))) {
            this.supportingFiles.add(new SupportingFile("abstract_authenticator.mustache", this.toSrcPath(this.authPackage, this.srcBasePath), this.toAbstractName("Authenticator") + ".php"));
        }
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return this.toAbstractName("DefaultApi");
        }
        return this.toAbstractName(StringUtils.camelize(name) + "Api");
    }

    @Override
    public String toApiTestFilename(String name) {
        if (name.length() == 0) {
            return "DefaultApiTest";
        }
        return StringUtils.camelize(name) + "ApiTest";
    }

    private void addUserClassnameToOperations(Map<String, Object> operations) {
        String classname = (String)operations.get("classname");
        classname = classname.replaceAll("^" + this.abstractNamePrefix, "");
        classname = classname.replaceAll(this.abstractNameSuffix + "$", "");
        operations.put(USER_CLASSNAME_KEY, classname);
    }

    @Override
    public String encodePath(String input) {
        if (input == null) {
            return input;
        }
        input = super.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\\", "\\\\"));
        input = input.trim();
        try {
            input = URLEncoder.encode(input, "UTF-8").replaceAll("\\+", "%20").replaceAll("\\%2F", "/").replaceAll("\\%7B", "{").replaceAll("\\%7D", "}").replaceAll("\\%5B", "[").replaceAll("\\%5D", "]").replaceAll("\\%3A", ":").replaceAll("\\%2B", "+").replaceAll("\\%5C\\%5Cd", "\\\\d");
        }
        catch (UnsupportedEncodingException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return input;
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        op.path = this.encodePath(path);
        return op;
    }

    public void setPsr7Implementation(String psr7Implementation) {
        switch (psr7Implementation) {
            case "slim-psr7": 
            case "nyholm-psr7": 
            case "guzzle-psr7": 
            case "zend-diactoros": {
                this.psr7Implementation = psr7Implementation;
                break;
            }
            default: {
                this.psr7Implementation = "slim-psr7";
                this.LOGGER.warn("\"{}\" is invalid \"psr7Implementation\" argument. Default \"slim-psr7\" used instead.", (Object)psr7Implementation);
            }
        }
    }

    public String getPsr7Implementation() {
        return this.psr7Implementation;
    }
}

