/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractApexCodegen;
import org.openapitools.codegen.utils.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexClientCodegen
extends AbstractApexCodegen {
    private static final String CLASS_PREFIX = "classPrefix";
    private static final String API_VERSION = "apiVersion";
    private static final String BUILD_METHOD = "buildMethod";
    private static final String NAMED_CREDENTIAL = "namedCredential";
    private final Logger LOGGER = LoggerFactory.getLogger(ApexClientCodegen.class);
    private String classPrefix = "OAS";
    private String apiVersion = "42.0";
    private String buildMethod = "sfdx";
    private String namedCredential;
    private String srcPath = "force-app/main/default/";
    private String sfdxConfigPath = "config/";
    private HashMap<String, Object> primitiveDefaults = new HashMap();

    public ApexClientCodegen() {
        this.importMapping.clear();
        this.templateDir = "apex";
        this.embeddedTemplateDir = "apex";
        this.outputFolder = "generated-code" + File.separator + "apex";
        this.modelPackage = this.apiPackage = this.srcPath + "classes";
        this.testPackage = "force-app.main.default.classes";
        this.modelNamePrefix = this.classPrefix;
        this.apiTemplateFiles.put("api.mustache", ".cls");
        this.apiTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.apiTestTemplateFiles.put("api_test.mustache", ".cls");
        this.apiTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTemplateFiles.put("model.mustache", ".cls");
        this.modelTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.modelTestTemplateFiles.put("model_test.mustache", ".cls");
        this.modelTestTemplateFiles.put("cls-meta.mustache", ".cls-meta.xml");
        this.cliOptions.add(CliOption.newString(CLASS_PREFIX, "Prefix for generated classes. Set this to avoid overwriting existing classes in your org."));
        this.cliOptions.add(CliOption.newString(API_VERSION, "The Metadata API version number to use for components in this package."));
        this.cliOptions.add(CliOption.newString(BUILD_METHOD, "The build method for this package."));
        this.cliOptions.add(CliOption.newString(NAMED_CREDENTIAL, "The named credential name for the HTTP callouts"));
        this.supportingFiles.add(new SupportingFile("OAS.cls", this.srcPath + "classes", "OAS.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "OAS.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("OASTest.cls", this.srcPath + "classes", "OASTest.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "OASTest.cls-meta.xml"));
        this.supportingFiles.add(new SupportingFile("OASResponseMock.cls", this.srcPath + "classes", "OASResponseMock.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", "OASResponseMock.cls-meta.xml"));
        this.typeMapping.put("BigDecimal", "Double");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "Blob");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Datetime");
        this.typeMapping.put("file", "Blob");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("number", "Double");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "activate", "and", "any", "array", "as", "asc", "autonomous", "begin", "bigdecimal", "blob", "boolean", "break", "bulk", "by", "byte", "case", "cast", "catch", "char", "class", "collect", "commit", "const", "continue", "currency", "date", "datetime", "decimal", "default", "delete", "desc", "do", "double", "else", "end", "enum", "exception", "exit", "export", "extends", "false", "final", "finally", "float", "for", "from", "global", "goto", "group", "having", "hint", "if", "implements", "import", "in", "inner", "insert", "instanceof", "int", "integer", "interface", "into", "join", "like", "limit", "list", "long", "loop", "map", "merge", "new", "not", "null", "nulls", "number", "object", "of", "on", "or", "outer", "override", "package", "parallel", "pragma", "private", "protected", "public", "retrieve", "return", "rollback", "select", "set", "short", "sObject", "sort", "static", "string", "super", "switch", "synchronized", "system", "testmethod", "then", "this", "throw", "time", "transaction", "trigger", "true", "try", "undelete", "update", "upsert", "using", "virtual", "void", "webservice", "when", "where", "while"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Blob", "Boolean", "Date", "Datetime", "Decimal", "Double", "ID", "Integer", "Long", "Object", "String", "Time"));
        this.primitiveDefaults.put("Boolean", true);
        this.primitiveDefaults.put("Decimal", 1);
        this.primitiveDefaults.put("Double", 1);
        this.primitiveDefaults.put("Integer", 1);
        this.primitiveDefaults.put("Long", 1);
        this.primitiveDefaults.put("String", "");
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CLASS_PREFIX)) {
            this.setClassPrefix((String)this.additionalProperties.get(CLASS_PREFIX));
        }
        this.additionalProperties.put(CLASS_PREFIX, this.classPrefix);
        if (this.additionalProperties.containsKey(API_VERSION)) {
            this.setApiVersion(this.toApiVersion((String)this.additionalProperties.get(API_VERSION)));
        }
        this.additionalProperties.put(API_VERSION, this.apiVersion);
        if (this.additionalProperties.containsKey(BUILD_METHOD)) {
            this.setBuildMethod((String)this.additionalProperties.get(BUILD_METHOD));
        }
        this.additionalProperties.put(BUILD_METHOD, this.buildMethod);
        if (this.additionalProperties.containsKey(NAMED_CREDENTIAL)) {
            this.setNamedCredential((String)this.additionalProperties.get(NAMED_CREDENTIAL));
        }
        this.additionalProperties.put(NAMED_CREDENTIAL, this.namedCredential);
        this.postProcessOpts();
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        String calloutLabel = openAPI.getInfo().getTitle();
        if (StringUtils.isNotBlank((CharSequence)this.namedCredential)) {
            calloutLabel = this.namedCredential;
        }
        this.additionalProperties.put("calloutLabel", calloutLabel);
        String sanitized = this.sanitizeName(calloutLabel);
        this.additionalProperties.put("calloutName", sanitized);
        this.supportingFiles.add(new SupportingFile("namedCredential.mustache", this.srcPath + "/namedCredentials", sanitized + ".namedCredential-meta.xml"));
        if (this.additionalProperties.get(BUILD_METHOD).equals("sfdx")) {
            this.generateSfdxSupportingFiles();
        } else if (this.additionalProperties.get(BUILD_METHOD).equals("ant")) {
            this.generateAntSupportingFiles();
        }
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "\\'");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return input.replace("'", "\\'").replace("\n", "\\n").replace("\r", "\\r").replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String toApiName(String name) {
        return org.openapitools.codegen.utils.StringUtils.camelize(this.classPrefix + super.toApiName(name));
    }

    @Override
    public String escapeReservedWord(String name) {
        return "r" + super.escapeReservedWord(name);
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        if (modelName.length() > 36) {
            modelName = modelName.substring(0, 36);
        }
        return modelName;
    }

    @Override
    public String toDefaultValue(Schema p) {
        String out = null;
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            out = String.format(Locale.ROOT, "new List<%s>()", inner == null ? "Object" : this.getTypeDeclaration(inner));
        } else if (ModelUtils.isBooleanSchema(p)) {
            out = String.valueOf(p.getDefault());
        } else if (ModelUtils.isLongSchema(p)) {
            Long def = (Long)p.getDefault();
            out = def == null ? out : def + "L";
        } else if (ModelUtils.isMapSchema(p)) {
            Schema inner = this.getAdditionalProperties(p);
            String s = inner == null ? "Object" : this.getTypeDeclaration(inner);
            out = String.format(Locale.ROOT, "new Map<String, %s>()", s);
        } else if (ModelUtils.isStringSchema(p)) {
            String def;
            if (p.getDefault() != null && (def = p.getDefault().toString()) != null) {
                out = p.getEnum() == null ? String.format(Locale.ROOT, "'%s'", this.escapeText(def)) : def;
            }
        } else {
            out = super.toDefaultValue(p);
        }
        return "null".equals(out) ? null : out;
    }

    public void setBuildMethod(String buildMethod) {
        if (buildMethod.equals("ant")) {
            this.srcPath = "deploy/";
        }
        this.buildMethod = buildMethod;
    }

    public void setNamedCredential(String namedCredential) {
        this.namedCredential = namedCredential;
    }

    public void setClassPrefix(String classPrefix) {
        this.modelNamePrefix = classPrefix;
        this.classPrefix = classPrefix;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    private String toApiVersion(String apiVersion) {
        if (apiVersion.matches("^\\d{2}(\\.0)?$")) {
            return apiVersion.substring(0, 2) + ".0";
        }
        this.LOGGER.warn(String.format(Locale.ROOT, "specified API version is invalid: %s - defaulting to %s", apiVersion, this.apiVersion));
        return this.apiVersion;
    }

    private void postProcessOpts() {
        this.supportingFiles.add(new SupportingFile("client.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls"));
        this.supportingFiles.add(new SupportingFile("cls-meta.mustache", this.srcPath + "classes", this.classPrefix + "Client.cls-meta.xml"));
    }

    @Override
    public void updateCodegenPropertyEnum(CodegenProperty var) {
        super.updateCodegenPropertyEnum(var);
        if (var.isEnum && var.example != null) {
            String example = var.example.replace("'", "");
            example = this.toEnumVarName(example, var.dataType);
            var.example = this.toEnumDefaultValue(example, var.datatypeWithEnum);
        }
    }

    private void generateAntSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("package.mustache", "deploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "undeploy", "destructiveChanges.xml"));
        this.supportingFiles.add(new SupportingFile("build.mustache", "build.xml"));
        this.supportingFiles.add(new SupportingFile("build.properties", "build.properties"));
        this.supportingFiles.add(new SupportingFile("remove.package.mustache", "undeploy", "package.xml"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README_ant.mustache", "README.md").doNotOverwrite());
    }

    private void generateSfdxSupportingFiles() {
        this.supportingFiles.add(new SupportingFile("sfdx-project-scratch-def.json", this.sfdxConfigPath, "project-scratch-def.json"));
        this.supportingFiles.add(new SupportingFile("sfdx-project.json.mustache", "sfdx-project.json"));
        this.supportingFiles.add(new SupportingFile("README_sfdx.mustache", "README.md").doNotOverwrite());
    }
}

