/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenConstants;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeScriptClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(TypeScriptClientCodegen.class);
    private static final String X_DISCRIMINATOR_TYPE = "x-discriminator-value";
    private static final String UNDEFINED_VALUE = "undefined";
    private static final String FRAMEWORK_SWITCH = "framework";
    private static final String FRAMEWORK_SWITCH_DESC = "Specify the framework which should be used in the client code.";
    private static final String[] FRAMEWORKS = new String[]{"fetch-api", "jquery"};
    private static final String PLATFORM_SWITCH = "platform";
    private static final String PLATFORM_SWITCH_DESC = "Specifies the platform the code should run on. The default is 'node' for the 'request' framework and 'browser' otherwise.";
    private static final String[] PLATFORMS = new String[]{"browser", "node", "deno"};
    private static final String FILE_CONTENT_DATA_TYPE = "fileContentDataType";
    private static final String FILE_CONTENT_DATA_TYPE_DESC = "Specifies the type to use for the content of a file - i.e. Blob (Browser, Deno) / Buffer (node)";
    private static final String USE_RXJS_SWITCH = "useRxJS";
    private static final String USE_RXJS_SWITCH_DESC = "Enable this to internally use rxjs observables. If disabled, a stub is used instead. This is required for the 'angular' framework.";
    private static final String USE_INVERSIFY_SWITCH = "useInversify";
    private static final String USE_INVERSIFY_SWITCH_DESC = "Enable this to generate decorators and service identifiers for the InversifyJS inversion of control container. If you set 'deno' as 'platform', the generator will process this value as 'disable'.";
    private static final String USE_OBJECT_PARAMS_SWITCH = "useObjectParameters";
    private static final String USE_OBJECT_PARAMS_DESC = "Use aggregate parameter objects as function arguments for api operations instead of passing each parameter as a separate function argument.";
    private final Map<String, String> frameworkToHttpLibMap = new HashMap<String, String>();
    private static final String SNAPSHOT = "snapshot";
    protected static final ThreadLocal<SimpleDateFormat> SNAPSHOT_SUFFIX_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmm", Locale.ROOT));
    private static final String NPM_REPOSITORY = "npmRepository";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    protected String npmRepository = null;
    protected String snapshot = null;
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String modelPropertyNaming = "camelCase";
    protected HashSet<String> languageGenericTypes;

    public TypeScriptClientCodegen() {
        this.frameworkToHttpLibMap.put("fetch-api", "isomorphic-fetch");
        this.frameworkToHttpLibMap.put("jquery", "jquery");
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.EXPERIMENTAL).build();
        this.importMapping.clear();
        this.outputFolder = "generated-code" + File.separator + "typescript";
        this.templateDir = "typescript";
        this.embeddedTemplateDir = "typescript";
        this.supportsInheritance = true;
        this.reservedWords.addAll(Arrays.asList("varLocalPath", "queryParameters", "headerParams", "formParams", "useFormData", "varLocalDeferred", "requestOptions", "abstract", "await", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "false", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "let", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "transient", "true", "try", "typeof", "var", "void", "volatile", "while", "with", "yield"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("string", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "Object", "Array", "Date", "number", "any", "File", "Error", "Map"));
        this.languageGenericTypes = new HashSet<String>(Arrays.asList("Array"));
        this.instantiationTypes.put("array", "Array");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "Array");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("boolean", "boolean");
        this.typeMapping.put("string", "string");
        this.typeMapping.put("int", "number");
        this.typeMapping.put("float", "number");
        this.typeMapping.put("number", "number");
        this.typeMapping.put("long", "number");
        this.typeMapping.put("short", "number");
        this.typeMapping.put("char", "string");
        this.typeMapping.put("double", "number");
        this.typeMapping.put("object", "any");
        this.typeMapping.put("integer", "number");
        this.typeMapping.put("Map", "any");
        this.typeMapping.put("date", "string");
        this.typeMapping.put("DateTime", "Date");
        this.typeMapping.put("binary", "any");
        this.typeMapping.put("File", "any");
        this.typeMapping.put("ByteArray", "string");
        this.typeMapping.put("UUID", "string");
        this.typeMapping.put("Error", "Error");
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package. Required to generate a full package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package. If not provided, using the version from the OpenAPI specification file.").defaultValue(this.getNpmVersion()));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(CliOption.newBoolean(SNAPSHOT, "When setting this property to true, the version will be suffixed with -SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().toPattern(), false));
        this.cliOptions.add(new CliOption("modelPropertyNaming", "Naming convention for the property: 'camelCase', 'PascalCase', 'snake_case' and 'original', which keeps the original name").defaultValue("camelCase"));
        this.cliOptions.add(new CliOption("supportsES6", "Generate code that conforms to ES6.").defaultValue("false"));
        this.cliOptions.add(new CliOption(FILE_CONTENT_DATA_TYPE, FILE_CONTENT_DATA_TYPE_DESC).defaultValue("Buffer"));
        this.cliOptions.add(new CliOption(USE_RXJS_SWITCH, USE_RXJS_SWITCH_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_OBJECT_PARAMS_SWITCH, USE_OBJECT_PARAMS_DESC).defaultValue("false"));
        this.cliOptions.add(new CliOption(USE_INVERSIFY_SWITCH, USE_INVERSIFY_SWITCH_DESC).defaultValue("false"));
        CliOption frameworkOption = new CliOption(FRAMEWORK_SWITCH, FRAMEWORK_SWITCH_DESC);
        for (String option : FRAMEWORKS) {
            frameworkOption.addEnum(option, option);
        }
        frameworkOption.defaultValue(FRAMEWORKS[0]);
        this.cliOptions.add(frameworkOption);
        CliOption platformOption = new CliOption(PLATFORM_SWITCH, PLATFORM_SWITCH_DESC);
        for (String option : PLATFORMS) {
            platformOption.addEnum(option, option);
        }
        platformOption.defaultValue(PLATFORMS[0]);
        this.cliOptions.add(platformOption);
        this.supportingFiles.add(new SupportingFile(".gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("util.mustache", "", "util.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "exception.mustache", "apis", "exception.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "http.mustache", "http", "http.ts"));
        this.supportingFiles.add(new SupportingFile("http" + File.separator + "servers.mustache", "servers.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("auth" + File.separator + "auth.mustache", "auth", "auth.ts"));
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "models_all.mustache", "models", "all.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "PromiseAPI.mustache", "types", "PromiseAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObservableAPI.mustache", "types", "ObservableAPI.ts"));
        this.supportingFiles.add(new SupportingFile("types" + File.separator + "ObjectParamAPI.mustache", "types", "ObjectParamAPI.ts"));
        this.setModelPackage("");
        this.supportingFiles.add(new SupportingFile("model" + File.separator + "ObjectSerializer.mustache", "models", "ObjectSerializer.ts"));
        this.modelTemplateFiles.put("model" + File.separator + "model.mustache", ".ts");
        this.setApiPackage("");
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "middleware.mustache", "", "middleware.ts"));
        this.supportingFiles.add(new SupportingFile("api" + File.separator + "baseapi.mustache", "apis", "baseapi.ts"));
        this.apiTemplateFiles.put("api" + File.separator + "api.mustache", ".ts");
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            if (this.additionalProperties.containsKey(NPM_VERSION)) {
                this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
            } else if (openAPI.getInfo() != null && openAPI.getInfo().getVersion() != null) {
                this.setNpmVersion(openAPI.getInfo().getVersion());
            }
            if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.parseBoolean(this.additionalProperties.get(SNAPSHOT).toString())) {
                if (this.npmVersion.toUpperCase(Locale.ROOT).matches("^.*-SNAPSHOT$")) {
                    this.setNpmVersion(this.npmVersion + "." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                } else {
                    this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.get().format(new Date()));
                }
            }
            this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        Object propFramework = this.additionalProperties.get(FRAMEWORK_SWITCH);
        HashMap<String, Boolean> frameworks = new HashMap<String, Boolean>();
        for (String framework : FRAMEWORKS) {
            frameworks.put(framework, framework.equals(propFramework));
        }
        objs.put(FRAMEWORK_SWITCH, propFramework);
        objs.put("frameworks", frameworks);
        objs.put(FILE_CONTENT_DATA_TYPE, this.additionalProperties.get(FILE_CONTENT_DATA_TYPE));
        return objs;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> operations, List<Object> models) {
        List imports = (List)operations.get("imports");
        for (Map im : imports) {
            im.put("filename", ((String)im.get("import")).replace(".", "/"));
            im.put("classname", this.getModelnameFromModelFilename(im.get("import").toString()));
        }
        Map operationsMap = (Map)operations.get("operations");
        List operationList = (List)operationsMap.get("operation");
        for (CodegenOperation operation : operationList) {
            List<CodegenResponse> responses = operation.responses;
            operation.returnType = this.getReturnType(responses);
        }
        return operations;
    }

    private String getReturnType(List<CodegenResponse> responses) {
        HashSet<String> returnTypes = new HashSet<String>();
        for (CodegenResponse response : responses) {
            if (!response.is2xx) continue;
            if (response.dataType != null) {
                returnTypes.add(response.dataType);
                continue;
            }
            returnTypes.add("void");
        }
        if (returnTypes.size() == 0) {
            return null;
        }
        return String.join((CharSequence)" | ", returnTypes);
    }

    private String getModelnameFromModelFilename(String filename) {
        String name = filename.substring((this.modelPackage() + File.separator).length());
        return StringUtils.camelize(name);
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toVarName(String name) {
        if ("_".equals(name = this.sanitizeName(name))) {
            name = "_u";
        }
        if (name.matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord(name = this.getNameUsingModelPropertyNaming(name)) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toModelName(String name) {
        name = this.sanitizeName(name);
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name)) {
            String modelName = StringUtils.camelize("model_" + name);
            this.LOGGER.warn(name + " (reserved word) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (name.matches("^\\d.*")) {
            String modelName = StringUtils.camelize("model_" + name);
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + modelName);
            return modelName;
        }
        if (this.languageSpecificPrimitives.contains(name)) {
            String modelName = StringUtils.camelize("model_" + name);
            this.LOGGER.warn(name + " (model name matches existing language type) cannot be used as a model name. Renamed to " + modelName);
            return modelName;
        }
        return StringUtils.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    protected String getParameterDataType(Parameter parameter, Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema mp1 = (ArraySchema)p;
            Schema inner = mp1.getItems();
            return this.getSchemaType(p) + "<" + this.getParameterDataType(parameter, inner) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "{ [key: string]: " + this.getParameterDataType(parameter, inner) + "; }";
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getEnum() != null) {
                return this.enumValuesToEnumTypeUnion(p.getEnum(), "string");
            }
        } else if (ModelUtils.isIntegerSchema(p) ? p.getEnum() != null : ModelUtils.isNumberSchema(p) && p.getEnum() != null) {
            return this.numericEnumValuesToEnumTypeUnion(new ArrayList<Number>(p.getEnum()));
        }
        return this.getTypeDeclaration(p);
    }

    protected String enumValuesToEnumTypeUnion(List<String> values, String dataType) {
        StringBuilder b = new StringBuilder();
        boolean isFirst = true;
        for (String value : values) {
            if (!isFirst) {
                b.append(" | ");
            }
            b.append(this.toEnumValue(value.toString(), dataType));
            isFirst = false;
        }
        return b.toString();
    }

    protected String numericEnumValuesToEnumTypeUnion(List<Number> values) {
        ArrayList<String> stringValues = new ArrayList<String>();
        for (Number value : values) {
            stringValues.add(value.toString());
        }
        return this.enumValuesToEnumTypeUnion(stringValues, "number");
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isDateTimeSchema(p)) {
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            return UNDEFINED_VALUE;
        }
        if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                return "'" + (String)p.getDefault() + "'";
            }
            return UNDEFINED_VALUE;
        }
        return UNDEFINED_VALUE;
    }

    @Override
    protected boolean isReservedWord(String word) {
        return this.reservedWords.contains(word);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        if (this.isReservedWord(operationId)) {
            return this.escapeReservedWord(StringUtils.camelize(this.sanitizeName(operationId), true));
        }
        return StringUtils.camelize(this.sanitizeName(operationId), true);
    }

    public void setModelPropertyNaming(String naming) {
        if (!("original".equals(naming) || "camelCase".equals(naming) || "PascalCase".equals(naming) || "snake_case".equals(naming))) {
            throw new IllegalArgumentException("Invalid model property naming '" + naming + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
        }
        this.modelPropertyNaming = naming;
    }

    public String getModelPropertyNaming() {
        return this.modelPropertyNaming;
    }

    public String getNameUsingModelPropertyNaming(String name) {
        switch (CodegenConstants.MODEL_PROPERTY_NAMING_TYPE.valueOf(this.getModelPropertyNaming())) {
            case original: {
                return name;
            }
            case camelCase: {
                return StringUtils.camelize(name, true);
            }
            case PascalCase: {
                return StringUtils.camelize(name);
            }
            case snake_case: {
                return StringUtils.underscore(name);
            }
        }
        throw new IllegalArgumentException("Invalid model property naming '" + name + "'. Must be 'original', 'camelCase', 'PascalCase' or 'snake_case'");
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equals(datatype)) {
            return value;
        }
        return "'" + this.escapeText(value) + "'";
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        if (this.getSymbolName(name) != null) {
            return StringUtils.camelize(this.getSymbolName(name));
        }
        if ("number".equals(datatype)) {
            String varName = "NUMBER_" + name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        String enumName = this.sanitizeName(name);
        enumName = enumName.replaceFirst("^_", "");
        enumName = enumName.replaceFirst("_$", "");
        if ((enumName = StringUtils.camelize(enumName)).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = this.toModelName(property.name) + "Enum";
        if (enumName.matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get("models");
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (Map mo : models) {
            CodegenModel cm = (CodegenModel)mo.get("model");
            mo.put("tsImports", this.toTsImports(cm, cm.imports));
        }
        return objs;
    }

    private List<Map<String, String>> toTsImports(CodegenModel cm, Set<String> imports) {
        ArrayList<Map<String, String>> tsImports = new ArrayList<Map<String, String>>();
        for (String im : imports) {
            if (im.equals(cm.classname)) continue;
            HashMap<String, String> tsImport = new HashMap<String, String>();
            tsImport.put("classname", im);
            tsImport.put("filename", this.toModelFilename(im));
            tsImports.add(tsImport);
        }
        return tsImports;
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map<String, Object> result = super.postProcessAllModels(objs);
        for (Map.Entry<String, Object> entry : result.entrySet()) {
            Map inner = (Map)entry.getValue();
            List models = (List)inner.get("models");
            for (Map mo : models) {
                CodegenModel cm = (CodegenModel)mo.get("model");
                if (cm.discriminator == null || cm.children == null) continue;
                for (CodegenModel child : cm.children) {
                    this.setDiscriminatorValue(child, cm.discriminator.getPropertyName(), this.getDiscriminatorValue(child));
                }
            }
        }
        return result;
    }

    private void setDiscriminatorValue(CodegenModel model, String baseName, String value) {
        for (CodegenProperty prop : model.allVars) {
            if (!prop.baseName.equals(baseName)) continue;
            prop.discriminatorValue = value;
        }
        if (model.children != null) {
            boolean newDiscriminator = model.discriminator != null;
            for (CodegenModel child : model.children) {
                this.setDiscriminatorValue(child, baseName, newDiscriminator ? value : this.getDiscriminatorValue(child));
            }
        }
    }

    private String getDiscriminatorValue(CodegenModel model) {
        return model.vendorExtensions.containsKey(X_DISCRIMINATOR_TYPE) ? (String)model.vendorExtensions.get(X_DISCRIMINATOR_TYPE) : model.classname;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "").replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String getName() {
        return "typescript";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    @Override
    public void processOpts() {
        boolean useInversify;
        boolean useRxJS;
        super.processOpts();
        if (this.additionalProperties.containsKey("modelPropertyNaming")) {
            this.setModelPropertyNaming((String)this.additionalProperties.get("modelPropertyNaming"));
        }
        this.convertPropertyToBooleanAndWriteBack("supportsES6");
        this.apiPackage = this.apiPackage + ".apis";
        this.modelPackage = this.modelPackage + ".models";
        this.testPackage = this.testPackage + ".tests";
        this.additionalProperties.putIfAbsent(FRAMEWORK_SWITCH, FRAMEWORKS[0]);
        this.supportingFiles.add(new SupportingFile("index.mustache", "index.ts"));
        String httpLibName = this.getHttpLibForFramework(this.additionalProperties.get(FRAMEWORK_SWITCH).toString());
        this.supportingFiles.add(new SupportingFile("http" + File.separator + httpLibName + ".mustache", "http", httpLibName + ".ts"));
        Object propPlatform = this.additionalProperties.get(PLATFORM_SWITCH);
        if (propPlatform == null) {
            propPlatform = "browser";
            this.additionalProperties.put(PLATFORM_SWITCH, propPlatform);
        }
        HashMap<String, Boolean> platforms = new HashMap<String, Boolean>();
        for (String platform : PLATFORMS) {
            platforms.put(platform, platform.equals(propPlatform));
        }
        this.additionalProperties.put("platforms", platforms);
        this.additionalProperties.putIfAbsent(FILE_CONTENT_DATA_TYPE, propPlatform.equals("node") ? "Buffer" : "Blob");
        if (!propPlatform.equals("deno")) {
            this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
            this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
            this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        }
        if (propPlatform.equals("deno")) {
            this.additionalProperties.put("extensionForDeno", ".ts");
        }
        if (!(useRxJS = this.convertPropertyToBooleanAndWriteBack(USE_RXJS_SWITCH))) {
            this.supportingFiles.add(new SupportingFile("rxjsStub.mustache", "rxjsStub.ts"));
        }
        if (useInversify = this.convertPropertyToBooleanAndWriteBack(USE_INVERSIFY_SWITCH)) {
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "index.mustache", "services", "index.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "configuration.mustache", "services", "configuration.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "PromiseAPI.mustache", "services", "PromiseAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObservableAPI.mustache", "services", "ObservableAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "ObjectParamAPI.mustache", "services", "ObjectParamAPI.ts"));
            this.supportingFiles.add(new SupportingFile("services" + File.separator + "http.mustache", "services", "http.ts"));
            this.apiTemplateFiles.put("services" + File.separator + "api.mustache", ".service.ts");
        }
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
    }

    private String getHttpLibForFramework(String object) {
        return this.frameworkToHttpLibMap.get(object);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            Schema inner = ((ArraySchema)p).getItems();
            return this.getSchemaType(p) + "<" + this.getTypeDeclaration(ModelUtils.unaliasSchema(this.openAPI, inner)) + ">";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = (Schema)p.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(ModelUtils.unaliasSchema(this.openAPI, inner)) + "; }";
        }
        if (ModelUtils.isFileSchema(p)) {
            return "HttpFile";
        }
        if (ModelUtils.isBinarySchema(p)) {
            return "any";
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)schema.getAdditionalProperties());
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }
}

