/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.ProcessUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerShellClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(PowerShellClientCodegen.class);
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    protected String sourceFolder = "src";
    protected String packageName = "PSOpenAPITools";
    protected String packageVersion = "0.1.2";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String apiTestPath = "tests/Api";
    protected String modelTestPath = "tests/Model";
    protected HashSet nullablePrimitives;
    protected String powershellGalleryUrl;
    protected HashSet powershellVerbs;
    protected Map<String, String> commonVerbs;
    protected HashSet methodNames;
    protected boolean useOneOfDiscriminatorLookup = false;
    protected boolean discardReadOnly = false;
    protected boolean skipVerbParsing = false;
    protected String projectUri;
    protected String licenseUri;
    protected String releaseNotes;
    protected String tags;
    protected String iconUri;
    protected Set<String> paramNameReservedWords;

    public PowerShellClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.outputFolder = "generated-code" + File.separator + "powershell-expiermental";
        this.modelTemplateFiles.put("model.mustache", ".ps1");
        this.apiTemplateFiles.put("api.mustache", ".ps1");
        this.modelTestTemplateFiles.put("model_test.mustache", ".ps1");
        this.apiTestTemplateFiles.put("api_test.mustache", ".ps1");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "powershell";
        this.embeddedTemplateDir = "powershell";
        this.apiPackage = this.packageName + File.separator + "Api";
        this.modelPackage = this.packageName + File.separator + "Model";
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "System.IO.FileInfo", "Version"));
        this.commonVerbs = new HashMap<String, String>();
        HashMap<String, List<String>> verbMappings = new HashMap<String, List<String>>();
        verbMappings.put("Add", Arrays.asList("Append", "Attach", "Concatenate", "Insert"));
        verbMappings.put("Clear", Arrays.asList("Flush", "Erase", "Release", "Unmark", "Unset", "Nullify"));
        verbMappings.put("Close", Arrays.asList(new String[0]));
        verbMappings.put("Copy", Arrays.asList("Duplicate", "Clone", "Replicate", "Sync"));
        verbMappings.put("Enter", Arrays.asList("PushInto"));
        verbMappings.put("Exit", Arrays.asList("PopOut"));
        verbMappings.put("Find", Arrays.asList(new String[0]));
        verbMappings.put("Format", Arrays.asList(new String[0]));
        verbMappings.put("Get", Arrays.asList("Read", "Open", "Cat", "Type", "Dir", "Obtain", "Dump", "Acquire", "Examine", "Find", "Search"));
        verbMappings.put("Hide", Arrays.asList("Block"));
        verbMappings.put("Join", Arrays.asList("Combine", "Unite", "Connect", "Associate"));
        verbMappings.put("Lock", Arrays.asList("RestrictSecure"));
        verbMappings.put("Move", Arrays.asList("Transfer", "Name", "Migrate"));
        verbMappings.put("New", Arrays.asList("Create", "Generate", "Build", "Make", "Allocate"));
        verbMappings.put("Open", Arrays.asList(new String[0]));
        verbMappings.put("Optimize", Arrays.asList(new String[0]));
        verbMappings.put("Pop", Arrays.asList(new String[0]));
        verbMappings.put("Push", Arrays.asList(new String[0]));
        verbMappings.put("Redo", Arrays.asList(new String[0]));
        verbMappings.put("Remove", Arrays.asList("Clear", "Cut", "Dispose", "Discard", "Erase"));
        verbMappings.put("Rename", Arrays.asList("Change"));
        verbMappings.put("Reset", Arrays.asList(new String[0]));
        verbMappings.put("Search", Arrays.asList("FindLocate"));
        verbMappings.put("Select", Arrays.asList("FindLocate"));
        verbMappings.put("Set", Arrays.asList("Write", "Reset", "Assign", "Configure"));
        verbMappings.put("Show", Arrays.asList("DisplayProduce"));
        verbMappings.put("Skip", Arrays.asList("BypassJump"));
        verbMappings.put("Split", Arrays.asList("parate"));
        verbMappings.put("Step", Arrays.asList(new String[0]));
        verbMappings.put("Switch", Arrays.asList(new String[0]));
        verbMappings.put("Undo", Arrays.asList(new String[0]));
        verbMappings.put("Unlock", Arrays.asList("Release", "Unrestrict", "Unsecure"));
        verbMappings.put("Watch", Arrays.asList(new String[0]));
        verbMappings.put("Connect", Arrays.asList("JoinTelnet"));
        verbMappings.put("Disconnect", Arrays.asList("BreakLogoff"));
        verbMappings.put("Read", Arrays.asList("Acquire", "Prompt", "Get"));
        verbMappings.put("Receive", Arrays.asList("Read", "Accept", "Peek"));
        verbMappings.put("Send", Arrays.asList("Put", "Broadcast", "Mail", "Fax"));
        verbMappings.put("Write", Arrays.asList("PutPrint"));
        verbMappings.put("Backup", Arrays.asList(" Save", " Burn", " Replicate", "Sync"));
        verbMappings.put("Checkpoint", Arrays.asList("  Diff"));
        verbMappings.put("Compare", Arrays.asList("  Diff"));
        verbMappings.put("Compress", Arrays.asList("  Compact"));
        verbMappings.put("Convert", Arrays.asList(" Change", " Resize", "Resample"));
        verbMappings.put("ConvertFrom", Arrays.asList(" Export", " Output", "Out"));
        verbMappings.put("ConvertTo", Arrays.asList(" Import", " Input", "In"));
        verbMappings.put("Dismount", Arrays.asList(" UnmountUnlink"));
        verbMappings.put("Edit", Arrays.asList(" Change", " Update", "Modify"));
        verbMappings.put("Expand", Arrays.asList(" ExplodeUncompress"));
        verbMappings.put("Export", Arrays.asList(" ExtractBackup"));
        verbMappings.put("Group", Arrays.asList(" Aggregate", " Arrange", " Associate", "Correlate"));
        verbMappings.put("Import", Arrays.asList(" BulkLoadLoad"));
        verbMappings.put("Initialize", Arrays.asList(" Erase", " Init", " Renew", " Rebuild", " Reinitialize", "Setup"));
        verbMappings.put("Limit", Arrays.asList("  Quota"));
        verbMappings.put("Merge", Arrays.asList(" CombineJoin"));
        verbMappings.put("Mount", Arrays.asList(" Connect"));
        verbMappings.put("Out", Arrays.asList(new String[0]));
        verbMappings.put("Publish", Arrays.asList(" Deploy", " Release", "Install"));
        verbMappings.put("Restore", Arrays.asList(" Repair", " Return", " Undo", "Fix"));
        verbMappings.put("Save", Arrays.asList(new String[0]));
        verbMappings.put("Sync", Arrays.asList(" Replicate", " Coerce", "Match"));
        verbMappings.put("Unpublish", Arrays.asList(" Uninstall", " Revert", "Hide"));
        verbMappings.put("Update", Arrays.asList(" Refresh", " Renew", " Recalculate", "Re-index"));
        verbMappings.put("Debug", Arrays.asList("Diagnose"));
        verbMappings.put("Measure", Arrays.asList("Calculate", "Determine", "Analyze"));
        verbMappings.put("Ping", Arrays.asList(new String[0]));
        verbMappings.put("Repair", Arrays.asList("FixRestore"));
        verbMappings.put("Resolve", Arrays.asList("ExpandDetermine"));
        verbMappings.put("Test", Arrays.asList("Diagnose", "Analyze", "Salvage", "Verify"));
        verbMappings.put("Trace", Arrays.asList("Track", "Follow", "Inspect", "Dig"));
        verbMappings.put("Approve", Arrays.asList(new String[0]));
        verbMappings.put("Assert", Arrays.asList("Certify"));
        verbMappings.put("Build", Arrays.asList(new String[0]));
        verbMappings.put("Complete", Arrays.asList(new String[0]));
        verbMappings.put("Confirm", Arrays.asList("Acknowledge", "Agree", "Certify", "Validate", "Verify"));
        verbMappings.put("Deny", Arrays.asList("Block", "Object", "Refuse", "Reject"));
        verbMappings.put("Deploy", Arrays.asList(new String[0]));
        verbMappings.put("Disable", Arrays.asList("HaltHide"));
        verbMappings.put("Enable", Arrays.asList("StartBegin"));
        verbMappings.put("Install", Arrays.asList("Setup"));
        verbMappings.put("Invoke", Arrays.asList("RunStart"));
        verbMappings.put("Register", Arrays.asList(new String[0]));
        verbMappings.put("Request", Arrays.asList(new String[0]));
        verbMappings.put("Restart", Arrays.asList("Recycle"));
        verbMappings.put("Resume", Arrays.asList(new String[0]));
        verbMappings.put("Start", Arrays.asList("Launch", "Initiate", "Boot"));
        verbMappings.put("Stop", Arrays.asList("End", "Kill", "Terminate", "Cancel"));
        verbMappings.put("Submit", Arrays.asList("Post"));
        verbMappings.put("Suspend", Arrays.asList("Pause"));
        verbMappings.put("Uninstall", Arrays.asList(new String[0]));
        verbMappings.put("Unregister", Arrays.asList("Remove"));
        verbMappings.put("Wait", Arrays.asList("SleepPause"));
        verbMappings.put("Block", Arrays.asList("Prevent", "Limit", "Deny"));
        verbMappings.put("Grant", Arrays.asList("AllowEnable"));
        verbMappings.put("Protect", Arrays.asList("Encrypt", "Safeguard", "Seal"));
        verbMappings.put("Revoke", Arrays.asList("RemoveDisable"));
        verbMappings.put("Unblock", Arrays.asList("ClearAllow"));
        verbMappings.put("Unprotect", Arrays.asList("DecryptUnseal"));
        verbMappings.put("Use", Arrays.asList(new String[0]));
        for (Map.Entry entry : verbMappings.entrySet()) {
            for (String verb : (List)entry.getValue()) {
                if (verbMappings.containsKey(verb)) {
                    this.LOGGER.debug("verbmapping: skipped {}", (Object)verb);
                    continue;
                }
                this.commonVerbs.put(verb, (String)entry.getKey());
                this.LOGGER.debug("verbmapping: adding {} => {}", (Object)verb, entry.getKey());
            }
        }
        this.powershellVerbs = new HashSet<String>(Arrays.asList("Add", "Clear", "Close", "Copy", "Enter", "Exit", "Find", "Format", "Get", "Hide", "Join", "Lock", "Move", "New", "Open", "Optimize", "Pop", "Push", "Redo", "Remove", "Rename", "Reset", "Search", "Select", "Set", "Show", "Skip", "Split", "Step", "Switch", "Undo", "Unlock", "Watch", "Connect", "Disconnect", "Read", "Receive", "Send", "Write", "Backup", "Checkpoint", "Compare", "Compress", "Convert", "ConvertFrom", "ConvertTo", "Dismount", "Edit", "Expand", "Export", "Group", "Import", "Initialize", "Limit", "Merge", "Mount", "Out", "Publish", "Restore", "Save", "Sync", "Unpublish", "Update", "Debug", "Measure", "Ping", "Repair", "Resolve", "Test", "Trace", "Approve", "Assert", "Build", "Complete", "Confirm", "Deny", "Deploy", "Disable", "Enable", "Install", "Invoke", "Register", "Request", "Restart", "Resume", "Start", "Stop", "Submit", "Suspend", "Uninstall", "Unregister", "Wait", "Block", "Grant", "Protect", "Revoke", "Unblock", "Unprotect", "Use"));
        this.methodNames = new HashSet();
        this.nullablePrimitives = new HashSet<String>(Arrays.asList("System.Nullable[Byte]", "System.Nullable[SByte]", "System.Nullable[Int16]", "System.Nullable[Int32]", "System.Nullable[Int64]", "System.Nullable[UInt16]", "System.Nullable[UInt32]", "System.Nullable[UInt64]", "System.Nullable[Decimal]", "System.Nullable[Single]", "System.Nullable[Double]", "System.Nullable[Boolean]"));
        this.reservedWords = new HashSet<String>(Arrays.asList("begin", "break", "catch", "continue", "data", "do", "dynamicparam", "else", "elseif", "end", "exit", "filter", "finally", "for", "foreach", "from", "function", "if", "in", "param", "process", "return", "switch", "throw", "trap", "try", "until", "while", "local", "private", "where", "args", "consolefilename", "error", "event", "eventargs", "eventsubscriber", "executioncontext", "false", "foreach", "home", "host", "input", "lastexitcode", "matches", "myinvocation", "nestedpromptlevel", "null", "pid", "profile", "pscmdlet", "pscommandpath", "psculture", "psdebugcontext", "pshome", "psitem", "psscriptroot", "pssenderinfo", "psuiculture", "psversiontable", "sender", "shellid", "stacktrace", "this", "true"));
        this.paramNameReservedWords = new HashSet<String>(Arrays.asList("args", "error", "executioncontext", "false", "home", "host", "input", "myinvocation", "nestedpromptlevel", "null", "pid", "profile", "pscommandpath", "psculture", "pshome", "psscriptroot", "psuiculture", "psversiontable", "shellid", "stacktrace", "true"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("Byte", "SByte", "Byte[]", "Int16", "Int32", "Int64", "UInt16", "UInt32", "UInt64", "Decimal", "Single", "Double", "TimeSpan", "System.DateTime", "ProgressRecord", "Char", "String", "XmlDocument", "SecureString", "Boolean", "Guid", "Uri", "System.IO.FileInfo", "Version"));
        this.typeMapping = new HashMap();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("integer", "Int32");
        this.typeMapping.put("float", "Double");
        this.typeMapping.put("long", "Int64");
        this.typeMapping.put("double", "Double");
        this.typeMapping.put("number", "Decimal");
        this.typeMapping.put("object", "System.Collections.Hashtable");
        this.typeMapping.put("file", "System.IO.FileInfo");
        this.typeMapping.put("ByteArray", "System.Byte[]");
        this.typeMapping.put("binary", "System.IO.FileInfo");
        this.typeMapping.put("date", "System.DateTime");
        this.typeMapping.put("date-time", "System.DateTime");
        this.typeMapping.put("Date", "System.DateTime");
        this.typeMapping.put("DateTime", "System.DateTime");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("powershellGalleryUrl", "URL to the module in PowerShell Gallery (e.g. https://www.powershellgallery.com/packages/PSTwitter/)."));
        this.cliOptions.add(new CliOption("packageName", "Client package name (e.g. PSTwitter).").defaultValue(this.packageName));
        this.cliOptions.add(new CliOption("packageVersion", "Package version (e.g. 0.1.2).").defaultValue(this.packageVersion));
        this.cliOptions.add(new CliOption("packageGuid", "GUID for PowerShell module (e.g. a27b908d-2a20-467f-bc32-af6f3a654ac5). A random GUID will be generated by default."));
        this.cliOptions.add(new CliOption("apiNamePrefix", "Prefix that will be appended to all PS objects. Default: empty string. e.g. Pet => PSPet."));
        this.cliOptions.add(new CliOption("commonVerbs", "PS common verb mappings. e.g. Delete=Remove:Patch=Update to map Delete with Remove and Patch with Update accordingly."));
        this.cliOptions.add(new CliOption("useOneOfDiscriminatorLookup", "Use the discriminator's mapping in oneOf to speed up the model lookup. IMPORTANT: Validation (e.g. one and only one match in oneOf's schemas) will be skipped."));
        this.cliOptions.add(new CliOption("discardReadOnly", "Set discardReadonly to true to generate the Initialize cmdlet without readonly parameters"));
        this.cliOptions.add(new CliOption("tags", "Tags applied to the generated PowerShell module. These help with module discovery in online galleries"));
        this.cliOptions.add(new CliOption("projectUri", "A URL to the main website for this project"));
        this.cliOptions.add(new CliOption("licenseUri", "A URL to the license for the generated PowerShell module"));
        this.cliOptions.add(new CliOption("iconUri", "A URL to an icon representing the generated PowerShell module"));
        this.cliOptions.add(new CliOption("releaseNotes", "Release notes of the generated PowerShell module"));
        this.cliOptions.add(new CliOption("skipVerbParsing", "Set skipVerbParsing to not try get powershell verbs of operation names"));
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
        this.additionalProperties.put("powershellVersion", "6.2");
        this.additionalProperties.put("author", "OpenAPI Generator Team");
        this.additionalProperties.put("companyName", "openapitools.org");
        this.additionalProperties.put("psData", null);
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "powershell";
    }

    @Override
    public String getHelp() {
        return "Generates a PowerShell API client (beta)";
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
        this.apiPackage = packageName + File.separator + "Api";
        this.modelPackage = packageName + File.separator + "Model";
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    public void setPowershellGalleryUrl(String powershellGalleryUrl) {
        this.powershellGalleryUrl = powershellGalleryUrl;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    public void setDiscardReadOnly(boolean discardReadOnly) {
        this.discardReadOnly = discardReadOnly;
    }

    public boolean getDiscardReadOnly() {
        return this.discardReadOnly;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setLicenseUri(String licenseUri) {
        this.licenseUri = licenseUri;
    }

    public void setProjectUri(String projectUri) {
        this.projectUri = projectUri;
    }

    public void setReleaseNotes(String releaseNotes) {
        this.releaseNotes = releaseNotes;
    }

    public void setIconUri(String iconUri) {
        this.iconUri = iconUri;
    }

    public void setSkipVerbParsing(boolean skipVerbParsing) {
        this.skipVerbParsing = skipVerbParsing;
    }

    @Override
    public void processOpts() {
        String[] entries;
        this.setLegacyDiscriminatorBehavior(false);
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("POWERSHELL_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Environment variable POWERSHELL_POST_PROCESS_FILE not defined so the PowerShell code may not be properly formatted. To define it, try 'export POWERSHELL_POST_PROCESS_FILE=\"Edit-DTWBeautifyScript\"'");
            this.LOGGER.info("NOTE: To enable file post-processing, 'enablePostProcessFile' must be set to `true` (--enable-post-process-file for CLI).");
        }
        if (this.additionalProperties.containsKey("powershellGalleryUrl")) {
            this.setPowershellGalleryUrl((String)this.additionalProperties.get("powershellGalleryUrl"));
        } else {
            this.additionalProperties.put("powershellGalleryUrl", this.powershellGalleryUrl);
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
        if (this.additionalProperties.containsKey("discardReadOnly")) {
            this.setDiscardReadOnly(this.convertPropertyToBooleanAndWriteBack("discardReadOnly"));
        } else {
            this.additionalProperties.put("discardReadOnly", this.discardReadOnly);
        }
        if (this.additionalProperties.containsKey("skipVerbParsing")) {
            this.setSkipVerbParsing(this.convertPropertyToBoolean("skipVerbParsing"));
        } else {
            this.additionalProperties.put("skipVerbParsing", this.skipVerbParsing);
        }
        if (this.additionalProperties.containsKey("tags")) {
            entries = ((String)this.additionalProperties.get("tags")).split(",");
            String prefix = "";
            StringBuilder tagStr = new StringBuilder("@(");
            for (String entry : entries) {
                tagStr.append(prefix);
                prefix = ",";
                tagStr.append(String.format(Locale.ROOT, "'%s' ", entry));
            }
            tagStr.append(")");
            this.setTags(tagStr.toString());
            this.additionalProperties.put("tags", tagStr.toString());
        }
        if (this.additionalProperties.containsKey("releaseNotes")) {
            this.setReleaseNotes((String)this.additionalProperties.get("releaseNotes"));
        } else {
            this.additionalProperties.put("releaseNotes", this.releaseNote);
        }
        if (this.additionalProperties.containsKey("licenseUri")) {
            this.setLicenseUri((String)this.additionalProperties.get("licenseUri"));
        } else {
            this.additionalProperties.put("licenseUri", this.licenseUri);
        }
        if (this.additionalProperties.containsKey("projectUri")) {
            this.setProjectUri((String)this.additionalProperties.get("projectUri"));
        } else {
            this.additionalProperties.put("projectUri", this.tags);
        }
        if (this.additionalProperties.containsKey("iconUri")) {
            this.setIconUri((String)this.additionalProperties.get("iconUri"));
        } else {
            this.additionalProperties.put("iconUri", this.iconUri);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.powershellGalleryUrl)) {
            this.additionalProperties.put("powershellGalleryId", this.powershellGalleryUrl.replaceFirst(".*/([^/?]+).*", "$1"));
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        } else {
            this.additionalProperties.put("packageGuid", this.packageGuid);
        }
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.additionalProperties.put("packageVersion", this.packageVersion);
        }
        if (this.additionalProperties.containsKey("commonVerbs")) {
            for (String entry : entries = ((String)this.additionalProperties.get("commonVerbs")).split(":")) {
                String[] pair = entry.split("=");
                if (pair.length == 2) {
                    this.commonVerbs.put(pair[0], pair[1]);
                    this.LOGGER.debug("Add commonVerbs: {} => {}", (Object)pair[0], (Object)pair[1]);
                    continue;
                }
                this.LOGGER.error("Failed to parse commonVerbs: {}", (Object)entry);
            }
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.LOGGER.warn("modelPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.LOGGER.warn("apiPackage with " + this.getName() + " generator is ignored. Setting this value independently of " + "packageName" + " is not currently supported.");
        }
        if (this.additionalProperties.containsKey("disallowAdditionalPropertiesIfNotPresent")) {
            this.setDisallowAdditionalPropertiesIfNotPresent(Boolean.valueOf(this.additionalProperties.get("disallowAdditionalPropertiesIfNotPresent").toString()));
        }
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Build.ps1.mustache", "", "Build.ps1"));
        String infrastructureFolder = this.sourceFolder + File.separator + this.packageName + File.separator;
        this.supportingFiles.add(new SupportingFile("Org.OpenAPITools.psm1.mustache", infrastructureFolder, this.packageName + ".psm1"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", infrastructureFolder + "Client", this.apiNamePrefix + "Configuration.ps1"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", infrastructureFolder + "Private", this.apiNamePrefix + "ApiClient.ps1"));
        this.supportingFiles.add(new SupportingFile("Get-CommonParameters.mustache", infrastructureFolder + File.separator + "Private" + File.separator, "Get-CommonParameters.ps1"));
        this.supportingFiles.add(new SupportingFile("Out-DebugParameter.mustache", infrastructureFolder + File.separator + "Private" + File.separator, "Out-DebugParameter.ps1"));
        this.supportingFiles.add(new SupportingFile("http_signature_auth.mustache", infrastructureFolder + "Private", this.apiNamePrefix + "HttpSignatureAuth.ps1"));
        this.supportingFiles.add(new SupportingFile("rsa_provider.mustache", infrastructureFolder + "Private", this.apiNamePrefix + "RSAEncryptionProvider.cs"));
        this.supportingFiles.add(new SupportingFile("about_Org.OpenAPITools.help.txt.mustache", infrastructureFolder + File.separator + "en-US" + File.separator + "about_" + this.packageName + ".help.txt"));
        this.supportingFiles.add(new SupportingFile("appveyor.mustache", "", "appveyor.yml"));
    }

    @Override
    public String escapeText(String input) {
        if (input == null) {
            return input;
        }
        return this.escapeUnsafeCharacters(StringEscapeUtils.unescapeJava((String)StringEscapeUtils.escapeJava((String)input).replace("\\/", "/")).replaceAll("[\\t\\n\\r]", " ").replace("\"", "\"\""));
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("#>", "#_>").replace("<#", "<_#");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String toApiTestFilename(String name) {
        return this.toApiFilename(name) + ".Tests";
    }

    @Override
    public String toModelTestFilename(String name) {
        return this.toModelFilename(name) + ".Tests";
    }

    @Override
    public String apiTestFileFolder() {
        return (this.outputFolder + "/" + this.apiTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.apiPackage();
    }

    @Override
    public String modelTestFileFolder() {
        return (this.outputFolder + "/" + this.modelTestPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.modelPackage();
    }

    @Override
    public String escapeReservedWord(String name) {
        return "Var" + name;
    }

    @Override
    public String toModelName(String name) {
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord(name = StringUtils.camelize(this.sanitizeName(name)))) {
            this.LOGGER.warn(name + " (reserved word or special variable name) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = StringUtils.camelize("model_" + name);
        }
        if (name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (model name starts with number) cannot be used as model name. Renamed to " + StringUtils.camelize("model_" + name));
            name = StringUtils.camelize("model_" + name);
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String getSchemaType(Schema p) {
        String type;
        String openAPIType = super.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return this.toModelName(type);
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getTypeDeclaration(inner) + "[]";
        }
        if (ModelUtils.isMapSchema(p)) {
            return "System.Collections.Hashtable";
        }
        if (!this.languageSpecificPrimitives.contains(this.getSchemaType(p))) {
            return super.getTypeDeclaration(p);
        }
        return super.getTypeDeclaration(p);
    }

    @Override
    public String toOperationId(String operationId) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)operationId)) {
            throw new RuntimeException("Empty method name (operationId) not allowed");
        }
        return this.sanitizeName(operationId);
    }

    @Override
    public String toParamName(String name) {
        if (this.paramNameReservedWords.contains(name = StringUtils.camelize(this.sanitizeName(name))) || name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (reserved word or special variable name) cannot be used in naming. Renamed to " + this.escapeReservedWord(name));
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        HashMap<String, Integer> processedModelMaps = new HashMap<String, Integer>();
        for (Object o : allModels) {
            HashMap h = (HashMap)o;
            CodegenModel m = (CodegenModel)h.get("model");
            modelMaps.put(m.classname, m);
        }
        List operationList = (List)operations.get("operation");
        for (CodegenOperation op : operationList) {
            int index = 0;
            for (CodegenParameter p : op.allParams) {
                p.vendorExtensions.put("x-powershell-data-type", this.getPSDataType(p));
                p.vendorExtensions.put("x-powershell-example", this.constructExampleCode(p, modelMaps, processedModelMaps));
                p.vendorExtensions.put("x-index", index);
                ++index;
            }
            if (!op.vendorExtensions.containsKey("x-powershell-method-name")) {
                String methodName = this.toMethodName(op.operationId);
                op.vendorExtensions.put("x-powershell-method-name", methodName);
                op.vendorExtensions.put("x-powershell-method-name-lowercase", methodName);
            } else {
                op.vendorExtensions.put("x-powershell-method-name-lowercase", ((String)op.vendorExtensions.get("x-powershell-method-name")).toLowerCase(Locale.ROOT));
            }
            if (this.methodNames.contains(op.vendorExtensions.get("x-powershell-method-name"))) {
                this.LOGGER.error("Duplicated method name found: {}", op.vendorExtensions.get("x-powershell-method-name"));
            } else {
                this.methodNames.add(op.vendorExtensions.get("x-powershell-method-name"));
            }
            if (op.produces == null || op.produces.size() <= 1) continue;
            op.vendorExtensions.put("x-powershell-select-accept", true);
        }
        processedModelMaps.clear();
        for (CodegenOperation operation : operationList) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-powershell-example", this.constructExampleCode(cp, modelMaps, processedModelMaps));
            }
        }
        for (CodegenOperation op : operationList) {
            if (op.returnType == null || !modelMaps.containsKey(op.returnType) || modelMaps.get(op.returnType) == null) continue;
            CodegenModel cm = modelMaps.get(op.returnType);
            if (cm.oneOf != null && !cm.oneOf.isEmpty()) {
                op.vendorExtensions.put("x-ps-return-type-one-of", true);
            }
            if (cm.anyOf == null || cm.anyOf.isEmpty()) continue;
            op.vendorExtensions.put("x-ps-return-type-any-of", true);
        }
        return objs;
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        ProcessUtils.addIndexToProperties(models);
        for (Object _mo : models) {
            Map _model = (Map)_mo;
            CodegenModel model = (CodegenModel)_model.get("model");
            CodegenProperty lastWritableProperty = null;
            for (CodegenProperty cp : model.allVars) {
                cp.vendorExtensions.put("x-powershell-data-type", this.getPSDataType(cp));
                if (!this.discardReadOnly || cp.isReadOnly) continue;
                lastWritableProperty = cp;
            }
            if (this.discardReadOnly && lastWritableProperty != null) {
                lastWritableProperty.vendorExtensions.put("x-powershell-last-writable", true);
                model.allVars.set(model.allVars.indexOf(lastWritableProperty), lastWritableProperty);
            }
            if (model.oneOf != null && !model.oneOf.isEmpty() && model.oneOf.contains("ModelNull")) {
                model.isNullable = true;
                model.oneOf.remove("ModelNull");
            }
            if (model.anyOf == null || model.anyOf.isEmpty() || !model.anyOf.contains("ModelNull")) continue;
            model.isNullable = true;
            model.anyOf.remove("ModelNull");
        }
        return objs;
    }

    @Override
    public String toVarName(String name) {
        name = this.sanitizeName(name);
        if (this.isReservedWord(name = StringUtils.camelize(name)) || name.matches("^\\d.*")) {
            this.LOGGER.warn(name + " (reserved word or special variable name) cannot be used in naming. Renamed to " + this.escapeReservedWord(name));
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    private String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenParameter.isArray) {
            return "@(" + this.constructExampleCode(codegenParameter.items, modelMaps, processedModelMap) + ")";
        }
        if (codegenParameter.isMap) {
            return "@{ \"Key\" = \"Value\" }";
        }
        if (this.languageSpecificPrimitives.contains(codegenParameter.dataType) || this.nullablePrimitives.contains(codegenParameter.dataType)) {
            if ("String".equals(codegenParameter.dataType) || "Character".equals(codegenParameter.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                    return "\"" + codegenParameter.example + "\"";
                }
                if (Boolean.TRUE.equals(codegenParameter.isEnum)) {
                    List enumValues = (List)codegenParameter.allowableValues.get("values");
                    return "\"" + String.valueOf(enumValues.get(0)) + "\"";
                }
                return "\"" + codegenParameter.paramName + "_example\"";
            }
            if ("Boolean".equals(codegenParameter.dataType) || "System.Nullable[Boolean]".equals(codegenParameter.dataType)) {
                if (Boolean.parseBoolean(codegenParameter.example)) {
                    return "true";
                }
                return "false";
            }
            if ("URL".equals(codegenParameter.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("System.DateTime".equals(codegenParameter.dataType)) {
                return "Get-Date";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenParameter.example)) {
                return codegenParameter.example;
            }
            return "987";
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, processedModelMap);
        }
        return "TODO";
    }

    private String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        if (codegenProperty.isArray) {
            return "@(" + this.constructExampleCode(codegenProperty.items, modelMaps, processedModelMap) + ")";
        }
        if (codegenProperty.isMap) {
            return "\"TODO\"";
        }
        if (this.languageSpecificPrimitives.contains(codegenProperty.dataType) || this.nullablePrimitives.contains(codegenProperty.dataType)) {
            if ("String".equals(codegenProperty.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                if (Boolean.TRUE.equals(codegenProperty.isEnum)) {
                    List enumValues = (List)codegenProperty.allowableValues.get("values");
                    return "\"" + String.valueOf(enumValues.get(0)) + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if ("Boolean".equals(codegenProperty.dataType) || "System.Nullable[Boolean]".equals(codegenProperty.dataType)) {
                if (Boolean.parseBoolean(codegenProperty.example)) {
                    return "$true";
                }
                return "$false";
            }
            if ("URL".equals(codegenProperty.dataType)) {
                return "URL(string: \"https://example.com\")!";
            }
            if ("System.DateTime".equals(codegenProperty.dataType)) {
                return "Get-Date";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "123";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, processedModelMap);
        }
        return "\"TODO\"";
    }

    /*
     * Enabled aggressive block sorting
     */
    private String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, HashMap<String, Integer> processedModelMap) {
        block5: {
            String model = codegenModel.name;
            if (processedModelMap.containsKey(model)) {
                int count = processedModelMap.get(model);
                if (count == 1) {
                    processedModelMap.put(model, 2);
                    break block5;
                } else {
                    if (count != 2) throw new RuntimeException("Invalid count when constructing example: " + count);
                    return "";
                }
            }
            processedModelMap.put(model, 1);
        }
        String example = "(Initialize-" + codegenModel.name + " ";
        ArrayList<String> propertyExamples = new ArrayList<String>();
        Iterator<CodegenProperty> iterator = codegenModel.allVars.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                example = example + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)" ");
                return example + ")";
            }
            CodegenProperty codegenProperty = iterator.next();
            propertyExamples.add("-" + codegenProperty.name + " " + this.constructExampleCode(codegenProperty, modelMaps, processedModelMap));
        }
    }

    private String getPSDataType(CodegenProperty cp) {
        if (cp.isPrimitiveType) {
            String dataType = cp.dataType;
            if (!(cp.isString || cp.isFile || cp.isContainer || !cp.isNullable && cp.required)) {
                dataType = "System.Nullable[" + dataType + "]";
            }
            return dataType;
        }
        if (cp.isArray) {
            return this.getPSDataType(cp.items) + "[]";
        }
        if (cp.isMap) {
            return "System.Collections.Hashtable";
        }
        return "PSCustomObject";
    }

    private String getPSDataType(CodegenParameter cp) {
        if (cp.isPrimitiveType) {
            String dataType = cp.dataType;
            if (!(cp.isString || cp.isFile || cp.isContainer || !cp.isNullable && cp.required)) {
                dataType = "System.Nullable[" + dataType + "]";
            }
            return dataType;
        }
        if (cp.isArray) {
            return this.getPSDataType(cp.items) + "[]";
        }
        if (cp.isMap) {
            return "System.Collections.Hashtable";
        }
        return "PSCustomObject";
    }

    private String toMethodName(String operationId) {
        String methodName = StringUtils.camelize(operationId);
        if (!this.skipVerbParsing) {
            for (String string : this.powershellVerbs) {
                if (!methodName.startsWith(string)) continue;
                methodName = string + "-" + this.apiNamePrefix + methodName.substring(string.length());
                this.LOGGER.info("Naming the method using the PowerShell verb: {} => {}", (Object)operationId, (Object)methodName);
                return methodName;
            }
            for (Map.Entry entry : this.commonVerbs.entrySet()) {
                if (!methodName.startsWith((String)entry.getKey())) continue;
                methodName = (String)entry.getValue() + "-" + this.apiNamePrefix + methodName.substring(((String)entry.getKey()).length());
                this.LOGGER.info("Naming the method by mapping the common verbs (e.g. Create, Change) to PS verbs: {} => {}", (Object)operationId, (Object)methodName);
                return methodName;
            }
        }
        return "Invoke-" + this.apiNamePrefix + methodName;
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        if (file == null) {
            return;
        }
        String powershellPostProcessFile = System.getenv("POWERSHELL_POST_PROCESS_FILE");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)powershellPostProcessFile)) {
            return;
        }
        if ("ps".equals(FilenameUtils.getExtension((String)file.toString()))) {
            String command = powershellPostProcessFile + " " + file.toString();
            try {
                Process p = Runtime.getRuntime().exec(command);
                int exitValue = p.waitFor();
                if (exitValue != 0) {
                    this.LOGGER.error("Error running the command ({}). Exit value: {}", (Object)command, (Object)exitValue);
                } else {
                    this.LOGGER.info("Successfully executed: " + command);
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
            }
        }
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.escapeText(pattern);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (p.getDefault() != null) {
            if (ModelUtils.isBooleanSchema(p)) {
                if (Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "$true";
                }
                return "$false";
            }
            if (ModelUtils.isDateSchema(p)) {
                this.LOGGER.warn("Default value for `date` not yet supported. Please open an issue with https://github.com/openapitools/openapi-generator");
            } else if (ModelUtils.isDateTimeSchema(p)) {
                this.LOGGER.warn("Default value for `datetime` not yet supported. Please open an issue with https://github.com/openapitools/openapi-generator");
            } else {
                if (ModelUtils.isNumberSchema(p)) {
                    return p.getDefault().toString();
                }
                if (ModelUtils.isIntegerSchema(p)) {
                    return p.getDefault().toString();
                }
                if (ModelUtils.isStringSchema(p)) {
                    return "\"" + p.getDefault() + "\"";
                }
            }
        }
        return null;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator has been refactored by wing328 (https://github.com/wing328)   #");
        System.out.println("# Please support his work directly by purchasing a copy of the eBook \ud83d\udcd8        #");
        System.out.println("# - OpenAPI Generator for PowerShell Developers      https://bit.ly/3qBWfRJ    #");
        System.out.println("################################################################################");
    }
}

