/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class MaximumValidator
extends BaseJsonValidator<OAI3> {
    private static final ValidationResult EXCLUSIVE_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1009), "Excluded maximum is '%s', found '%s'.");
    private static final ValidationResult ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(1010), "Maximum is '%s', found '%s'.");
    private static final ValidationResults.CrumbInfo CRUMB_INFO = new ValidationResults.CrumbInfo("maximum", true);
    private final BigDecimal maximum;
    private final boolean excludeEqual;

    MaximumValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.maximum = schemaNode.isNumber() ? schemaNode.decimalValue() : null;
        JsonNode exclusiveMaximumNode = schemaParentNode.get("exclusiveMaximum");
        this.excludeEqual = exclusiveMaximumNode != null && exclusiveMaximumNode.isBoolean() ? exclusiveMaximumNode.booleanValue() : false;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        if (this.maximum == null || !valueNode.isNumber()) {
            return false;
        }
        BigDecimal value = valueNode.decimalValue();
        int compResult = value.compareTo(this.maximum);
        if (this.excludeEqual && compResult == 0) {
            validation.add(CRUMB_INFO, EXCLUSIVE_ERR, this.maximum, value);
        } else if (compResult > 0) {
            validation.add(CRUMB_INFO, ERR, this.maximum, value);
        }
        return false;
    }
}

